import { MgControlBase } from '@magic-xpa/gui';
import { StorageAttribute } from '@magic-xpa/utils';
import { EventCommand } from './EventCommand';
import { RollbackEventCommand, RollbackEventCommand_RollbackType } from './RollbackEventCommand';
import { DataviewCommand, DataViewCommandType } from './DataviewCommand';
import { Task } from '../../tasks/Task';
import { UserRange } from '../../tasks/TaskBase';
import { AddUserRangeDataviewCommand } from './AddUserRangeDataviewCommand';
import { Sort } from '../../tasks/sort/Sort';
import { AddUserSortDataViewCommand } from './AddUserSortDataViewCommand';
import { AddUserLocateDataViewCommand } from './AddUserLocateDataViewCommand';
import { SetTransactionStateDataviewCommand } from './SetTransactionStateDataviewCommand';
import { RefreshEventCommand } from './RefreshEventCommand';
import { ArgumentsList } from '../../rt/ArgumentsList';
import { FetchDataControlValuesEventCommand } from './FetchDataControlValuesEventCommand';
import { SubformRefreshEventCommand } from './SubformRefreshEventCommand';
import { BrowserEscEventCommand } from './BrowserEscEventCommand';
import { IndexChangeEventCommand } from './IndexChangeEventCommand';
import { ColumnSortEventCommand } from './ColumnSortEventCommand';
import { RefreshScreenEventCommand } from './RefreshScreenEventCommand';
import { SubformOpenEventCommand } from './SubformOpenEventCommand';
import { ComputeEventCommand } from './ComputeEventCommand';
import { NonReversibleExitEventCommand } from './NonReversibleExitEventCommand';
import { RecomputeCommand } from './RecomputeCommand';
import { TransactionCommand } from './TransactionCommand';
import { UnloadCommand } from './UnloadCommand';
import { ExecOperCommand } from './ExecOperCommand';
import { EvaluateCommand } from './EvaluateCommand';
import { GlobalParamsQueryCommand } from './GlobalParamsQueryCommand';
import { IniputForceWriteCommand } from './IniputForceWriteCommand';
import { ContextTerminationEventCommand } from './ContextTerminationEventCommand';
import { ContextTimeoutResetCommand } from './ContextTimeoutResetCommand';
import { ControlItemsRefreshCommand } from './ControlItemsRefreshCommand';
export declare class CommandFactory {
    static CreateEventCommand(taskTag: string, magicEvent: number): EventCommand;
    static CreateRollbackEventCommand(taskTag: string, rollbackType: RollbackEventCommand_RollbackType): RollbackEventCommand;
    static CreateDataViewCommand(taskId: string, commandType: DataViewCommandType): DataviewCommand;
    static CreateControlItemsRefreshCommand(taskId: string, control: MgControlBase): ControlItemsRefreshCommand;
    static CreateAddUserRangeDataviewCommand(taskId: string, userRange: UserRange): AddUserRangeDataviewCommand;
    static CreateAddUserSortDataviewCommand(taskId: string, sort: Sort): AddUserSortDataViewCommand;
    static CreateAddUserLocateDataviewCommand(taskId: string, userRange: UserRange): AddUserLocateDataViewCommand;
    static CreateSetTransactionStateDataviewCommand(taskId: string, transactionIsOpened: boolean): SetTransactionStateDataviewCommand;
    static CreateInternalRefreshCommand(taskId: string, magicEvent: number, currentRecId: number, currentRow: number): RefreshEventCommand;
    static CreateRealRefreshCommand(taskId: string, magicEvent: number, currentRow: number, argList: ArgumentsList, currentRecId: number): Promise<RefreshEventCommand>;
    static CreatecFetchDataControlValuesCommand(taskTag: string, controlName: string): FetchDataControlValuesEventCommand;
    static CreateSubformRefreshCommand(taskTag: string, subformTaskTag: string, explicitSubformRefresh: boolean): SubformRefreshEventCommand;
    static CreateSubformOpenCommand(taskTag: string, subformDitIdx: number): SubformOpenEventCommand;
    static CreateScreenRefreshCommand(taskTag: string, topRecIdx: number, clientRecId: number): RefreshScreenEventCommand;
    static CreateColumnSortCommand(taskTag: string, direction: number, ditIdx: number, fieldId: number, recId: number): ColumnSortEventCommand;
    static CreateIndexChangeCommand(taskTag: string, recId: number, argList: ArgumentsList): Promise<IndexChangeEventCommand>;
    static CreateBrowserEscEventCommand(taskTag: string, closeSubformOnly: boolean): BrowserEscEventCommand;
    static CreateComputeEventCommand(taskTag: string, subforms: boolean, clientRecId: number): ComputeEventCommand;
    static CreateContextTerminationEventCommand(taskTag: string): ContextTerminationEventCommand;
    static CreateContextTimeoutResetEventCommand(): ContextTimeoutResetCommand;
    static CreateNonReversibleExitCommand(taskTag: string, closeSubformOnly: boolean): NonReversibleExitEventCommand;
    static CreateRecomputeCommand(taskTag: string, fieldId: number, ignoreSubformRecompute: boolean): RecomputeCommand;
    static CreateTransactionCommand(oper: string, taskTag: string, cReversibleExit: boolean, level: string): TransactionCommand;
    static CreateUnloadCommand(): UnloadCommand;
    static CreateExecOperCommand(taskTag: string, handlerId: string, operIdx: number, ditIdx: number, value: string): ExecOperCommand;
    static CreateSelectProgramCommand(taskTag: string, handlerId: string, operIdx: number, ditIdx: number, value: string): ExecOperCommand;
    static CreateEvaluateCommand(taskTag: string, expType: StorageAttribute, expIdx: number, expValLen: number, mprgCreator: Task): EvaluateCommand;
    static CreateQueryGlobalParamsCommand(): GlobalParamsQueryCommand;
    static CreateIniputForceWriteCommand(param: string): IniputForceWriteCommand;
}
