import { DataModificationTypes, DcValues, IRecord, ObjectReferenceBase, ObjectReferencesCollection } from '@magic-xpa/gui';
import { IComparable, List, StringBuilder } from '@magic-xpa/mscorelib';
import { StorageAttribute, XmlParser } from '@magic-xpa/utils';
import { Field } from './Field';
import { TableCache } from '../rt/TableCache';
import { FieldsTableExt as FieldsTable } from './FieldsTable';
import { DataViewBase } from './DataViewBase';
export declare class Record implements IComparable, IRecord {
    static FLAG_NULL: number;
    static FLAG_INVALID: number;
    static FLAG_MODIFIED: number;
    static FLAG_UPDATED: number;
    static FLAG_CRSR_MODIFIED: number;
    static FLAG_VALUE_NOT_PASSED: number;
    static FLAG_MODIFIED_ATLEAST_ONCE: number;
    protected _id: number;
    protected dbViewRowIdx: number;
    protected _mode: DataModificationTypes;
    private _dcRefs;
    _inCompute: boolean;
    _inRecompute: boolean;
    _newRec: boolean;
    get InCompute(): boolean;
    get InRecompute(): boolean;
    protected static INCREASE: boolean;
    protected static DECREASE: boolean;
    protected _tableCache: TableCache;
    protected _inDeleteProcess: boolean;
    protected _addAfter: number;
    protected _causeInvalidation: boolean;
    protected _dbPosBase64Val: string;
    protected _dataview: DataViewBase;
    private _fieldsData;
    protected _flags: Uint8Array;
    protected _flagsHistory: Uint8Array;
    protected _forceSaveOrg: boolean;
    protected _hashKey: number;
    protected _computed: boolean;
    protected _lateCompute: boolean;
    protected _linksFldsPos: string;
    protected _modified: boolean;
    protected _next: Record;
    protected _prev: Record;
    protected _sendToServer: boolean;
    protected _updated: boolean;
    InForceUpdate: boolean;
    Synced: boolean;
    ValueInBase64: boolean;
    constructor(dvOrTableCache: DataViewBase | TableCache);
    constructor(cId: number, dataview: DataViewBase);
    constructor(Record: Record);
    private constructor_0;
    Initialize(): void;
    private constructor_1;
    get Modified(): boolean;
    get Updated(): boolean;
    get SendToServer(): boolean;
    CompareTo(obj: Object): number;
    getMode(): DataModificationTypes;
    getId(): number;
    isNewRec(): boolean;
    private getFieldDataXML;
    getFieldsTab(): FieldsTable;
    setInitialFldVals(clobberedOnly: boolean, isNewRec: boolean): void;
    setId(cId: number): void;
    setDBViewRowIdx(rowId: number): void;
    getDBViewRowIdx(): number;
    fillData(parser: XmlParser): boolean;
    protected initElements(tokensVector: List<string>): boolean;
    protected peekIsCurrRec(tokensVector: List<string>): boolean;
    fillFieldsData(fldValInBytes: Uint8Array, recFlags: string): void;
    fillFieldsData(fldsVal: string, recFlags: string, isCurrRec: boolean): void;
    private fillFieldsData_0;
    private fillFieldsData_1;
    fillDCRef(valueStr: string): void;
    private buildFieldsData;
    getXMLForValue(fldIdx: number, fldVal: string): string;
    getFromFldIdx(isCurrRec: boolean): number;
    getSizeFld(isCurrRec: boolean): number;
    buildXML(message: StringBuilder, isCurrRec: boolean): void;
    buildXML(message: StringBuilder, isCurrRec: boolean, forceBuild: boolean): void;
    private buildXML_0;
    protected buildXML_1(message: StringBuilder, isCurrRec: boolean, forceBuild: boolean): void;
    protected setShrinkFlags(): void;
    setShrinkFlag(fldIdx: number): void;
    SetFieldValue(idx: number, isNull: boolean, value: string): void;
    setFieldValue(fldIdx: number, mgVal: string, setRecordUpdated: boolean): void;
    CheckMgValue(mgVal: string, isNull: boolean, fld: Field): string;
    setModified(): void;
    resetModified(): void;
    setUpdated(): void;
    resetUpdated(): void;
    GetFieldValue(fldIdx: number): string;
    replicate(): Record;
    setSameAs(rec: Record, realOnly: boolean, rId: number): void;
    setSameAs(rec: Record, realOnly: boolean): void;
    private setSameAs_0;
    private setSameAs_1;
    IsNull(fldIdx: number): boolean;
    isLinkInvalid(fldIdx: number): boolean;
    isFldModified(fldIdx: number): boolean;
    IsFldModifiedAtLeastOnce(fldIdx: number): boolean;
    isFldUpdated(fldIdx: number): boolean;
    setFlag(fldIdx: number, aFlag: number): void;
    clearFlag(fldIdx: number, aFlags: number): void;
    clearFlagsHistory(): void;
    clearFlags(aFlags: number): void;
    clearFlagsForRealOnly(aFlags: number): void;
    clearHistoryFlag(fldIdx: number): void;
    checkFlags(fldIdx: number): void;
    restart(oldMode: DataModificationTypes): void;
    setLateCompute(val: boolean): void;
    lateCompute(): boolean;
    setInDeleteProcess(val: boolean): void;
    inDeleteProcess(): boolean;
    removeRecFromDc(): void;
    isSameRecData(rec: Record, currRec: boolean, checkOnlyParetOfDataview: boolean): boolean;
    fldValsEqual(rec: Record, fldIdx: number): boolean;
    getHashKey(): number;
    setNextRec(nextRec: Record): void;
    setPrevRec(prevRec: Record): void;
    getPrevRec(): Record;
    getNextRec(): Record;
    getDcRefs(): ObjectReferencesCollection;
    setDcRefs(newDcRefs: ObjectReferencesCollection): void;
    realModified(): boolean;
    ToString(): string;
    setSendToServer(val: boolean): void;
    getRecSize(): number;
    copyCrsrModifiedFlags(rec: Record): void;
    getDbPosVal(): string;
    buildLinksPosStr(): void;
    setForceSaveOrg(val: boolean): void;
    getForceSaveOrg(): boolean;
    isCauseInvalidation(): boolean;
    setCauseInvalidation(causeInvalidation: boolean): void;
    isComputed(): boolean;
    setComputed(val: boolean): void;
    setInCompute(val: boolean): void;
    setInRecompute(val: boolean): void;
    setMode(newMode: DataModificationTypes): void;
    clearMode(): void;
    setOldRec(): void;
    setNewRec(): void;
    static serializeItemVal(itemVal: string, itemAttr: StorageAttribute, cellAttr: StorageAttribute, ToBase64: boolean): string;
    SetDcValueId(): void;
    resetDcValueId(): void;
    AddDcValuesReference(controlId: number, dcValuesId: number): void;
}
export declare class DcValuesReference extends ObjectReferenceBase {
    ditIdx: number;
    get DcValues(): DcValues;
    constructor(controlId: number, referencedDcValues: DcValues);
    Clone(): ObjectReferenceBase;
    static Parse(couple: string, dcValuesOwner: DataViewBase): DcValuesReference;
}
