import { IRecordsTable } from "./IRecordsTable";
import { Record } from "./Record";
import { DataView } from "./DataView";
import { StringBuilder } from "@magic-xpa/mscorelib";
import { XmlParser } from "@magic-xpa/utils";
export declare class RecordsTable implements IRecordsTable {
    static REC_NOT_FOUND: number;
    private _useLinkedList;
    private _hashTab;
    private _initialCurrRecId;
    private _records;
    private _serverCurrRec;
    InsertedRecordsCount: number;
    constructor(withLinkedList: boolean);
    constructor(recordTable: RecordsTable);
    fillData(dataview: DataView, insertAt: string, parser: XmlParser): string;
    InsertRecord(insertAt: string, record: Record): void;
    buildXML(message: StringBuilder, skipCurrRec: boolean, currRecId: number): void;
    getRecord(id: number): Record;
    getRecIdx(id: number): number;
    getRecByIdx(idx: number): Record;
    removeAll(): void;
    getSize(): number;
    getInitialCurrRecId(): number;
    addRecord(rec: Record): void;
    private addRec;
    insertRecord(rec: Record, idx: number): void;
    removeRecord(recIdx: number): void;
    removeRecord(rec: Record): void;
    private removeRecord_0;
    private removeRecord_1;
    replicate(): RecordsTable;
    getServerCurrRec(): Record;
    zeroServerCurrRec(): void;
    GetSize(): number;
    GetRecByIdx(idx: number): Record;
    RemoveAll(): void;
}
