import { Transaction } from "../rt/Transaction";
import { ReturnResult } from "../util/ReturnResult";
import { DataviewManagerBase } from "./DataviewManagerBase";
import { Task } from "../tasks/Task";
import { RefParam } from "@magic-xpa/mscorelib";
export declare class TaskTransactionManager {
    task: Task;
    private get isClosingTopmostTask();
    constructor(task: Task);
    AllowTransaction(transBegin: string, forLocal: boolean): boolean;
    PrepareTransactionProperties(transaction: Transaction, forLocal: boolean): void;
    GetTransactionBeginValue(forLocal: boolean): string;
    checkAndCommit(reversibleExit: boolean, level: string, isAbort: boolean): Promise<boolean>;
    ExecuteLocalUpdatesCommand(): Promise<ReturnResult>;
    checkAndCommitPerDataview(dataviewmanager: DataviewManagerBase, reversibleExit: boolean, level: string, oper: string, refResult: RefParam<ReturnResult>): Promise<boolean>;
    HandelTransactionErrorHandlingsRetry(transBegin: string[]): void;
}
