import { IEnvironment } from '@magic-xpa/gui';
import { Encoding, List } from '@magic-xpa/mscorelib';
import { XmlParser } from '@magic-xpa/utils';
export declare class Environment implements IEnvironment {
    private _environments;
    private _contextInactivityTimeout;
    private _clientContextInactivityTimeout;
    private _contextInactivityWarningTime;
    private _toolitipTimeout;
    private _contextUnloadTimeout;
    private _canReplaceDecimalSeparator;
    private _codePage;
    private _dateSeparator;
    private _decimalSeparator;
    private _thousandsSeparator;
    private _timeSeparator;
    private _guid;
    private _imeAutoOff;
    private _language;
    private _localAs400Set;
    private _localExtraGengo;
    private _localFlags;
    private _lowHigh;
    private _owner;
    private _debugMode;
    private _significantNumSize;
    private _specialAnsiExpression;
    private _specialImmediatehandlerEnd;
    private _specialShowStatusBarPanes;
    private _specialRouteToRootProgOnContextRecreation;
    private _specialCancelOnCreate;
    private _system;
    private _terminal;
    private _forwardSlash;
    private _dropUserFormats;
    private _webclientReinitSession;
    private _specialValNewPolicy;
    static Instance: Environment;
    get Language(): string;
    IgnoreReplaceDecimalSeparator: boolean;
    get SpecialRestoreMaximizedForm(): boolean;
    set ForwardSlashUsage(value: string);
    get ForwardSlashUsage(): string;
    fillData(parser: XmlParser): void;
    fillData(tokensVector: List<string>): void;
    fillData_0(parser: XmlParser): void;
    private fillData_1;
    fillFromUrl(tagName: string, parser: XmlParser): Promise<void>;
    private getEnvDet;
    GetDateMode(compIdx: number): string;
    GetThousands(): string;
    GetDecimal(): string;
    setDecimalSeparator(value: string): void;
    setThousandsSeparator(value: string): void;
    setDateSeparator(value: string): void;
    setTimeSeparator(value: string): void;
    GetDate(): string;
    getIdleTime(compIdx: number): number;
    getOwner(): string;
    GetTime(): string;
    GetCentury(compIdx: number): number;
    allowUpdateInQueryMode(compIdx: number): boolean;
    allowCreateInModifyMode(compIdx: number): boolean;
    GetSignificantNumSize(): number;
    setSignificantNumSize(newSize: number): void;
    getCodePage(): number;
    GetEncoding(): Encoding;
    getSystem(): string;
    GetDebugLevel(): number;
    CanReplaceDecimalSeparator(): boolean;
    getClientContextInactivityTimeout(): number;
    getContextInactivityTimeout(): number;
    getContextInactivityWarningTime(): number;
    getContextUnloadTimeout(): number;
    GetTooltipTimeout(): number;
    getLowHigh(): boolean;
    GetImeAutoOff(): boolean;
    GetLocalAs400Set(): boolean;
    getLocalExtraGengo(): string;
    GetLocalFlag(f: string): boolean;
    getSpecialImmediateHandlerEnd(): boolean;
    getSpecialAnsiExpression(): boolean;
    getSpecialShowStatusBarPanes(): boolean;
    getTerminal(): number;
    getWebClientReinitSession(): string;
    setWebClientReinitSession(session: string): void;
    getSpecialRouteToRootProgOnContextRecreation(): boolean;
    GetGUID(): string;
    getProjDir(compIdx: number): string;
    GetSpecialLogInternalExceptions(): boolean;
    setOwner(val: string): void;
    setDateMode(compIdx: number, val: string): void;
    setCentury(compIdx: number, val: number): void;
    setIdleTime(compIdx: number, val: number): void;
    setAllowUpdateInQueryMode(compIdx: number, val: boolean): void;
    setAllowCreateInModifyMode(compIdx: number, val: boolean): void;
    setContextInactivityTimeout(val: number): void;
    setContextInactivityWarningTime(val: number): void;
    setContextUnloadTimeout(val: number): void;
    setTerminal(val: number): void;
    GetDropUserFormats(): string;
    GetSpecialValNewPolicy(): boolean;
    GetSpecialCancelOnCreate(): boolean;
}
export declare class EnvironmentDetails {
    private _createInModifyMode;
    private _updateInQueryMode;
    CompIdx: number;
    DateMode: string;
    Century: number;
    IdleTime: number;
    set UpdateInQueryMode(value: boolean);
    set CreateInModifyMode(value: boolean);
    ProjDir: string;
    constructor();
    allowUpdateInQueryMode(): boolean;
    allowCreateInModifyMode(): boolean;
}
