import { XmlParser } from "@magic-xpa/utils";
import { ExpVal } from "@magic-xpa/gui";
import { Event } from "./Event";
import { OperationTable } from "../rt/OperationTable";
import { RunTimeEvent } from "./RunTimeEvent";
import { Task } from "../tasks/Task";
export declare class EventHandler {
    private _enabledExp;
    private _operationTab;
    private _propagateExp;
    private _isHandlerOnForm;
    private _ctrl;
    private _ctrlName;
    private _dvLen;
    private _dvPos;
    private _evt;
    private _handledByClient;
    private _handlerFld;
    private _hasParameters;
    private _id;
    private _level;
    private _scope;
    private _task;
    private _taskMgdID;
    constructor();
    getCtrlName(): string;
    fillData(taskRef: Task, parser: XmlParser): void;
    private initInnerObjects;
    private initInnerElements;
    private initElements;
    calculateCtrlFromControlName(taskRef: Task): void;
    isSpecificHandlerOf(rtEvt: RunTimeEvent): boolean;
    isNonSpecificHandlerOf(rtEvt: RunTimeEvent): boolean;
    isGlobalHandlerOf(rtEvt: RunTimeEvent): boolean;
    isGlobalSpecificHandlerOf(rtEvt: RunTimeEvent): boolean;
    execute(rtEvt: RunTimeEvent, returnedFromServer: boolean, enabledCndCheckedAndTrue: boolean): Promise<RetVals>;
    private executeOperations;
    private getSignificantBlock;
    private getStartBlockIdxByEnd;
    private getStartBlockIdxByElse;
    private getStartBlockIfIdxByOper;
    getLevel(): string;
    getEvent(): Event;
    getId(): number;
    isEnabled(): Promise<boolean>;
    private resetLocalVariables;
    private getArgValsFromFlds;
    getTask(): Task;
    argsMatch(Exp_params: ExpVal[]): boolean;
    getOperationTab(): OperationTable;
    getControlNameForControlHeader(): string;
    getVarNameForVariableHeader(): string;
    getEventHandlerInfo(): string;
    toString(): string;
}
export declare class RetVals {
    BlockIfReturnedFromServer: boolean;
    Enabled: boolean;
    NextOperIdx: number;
    Propagate: boolean;
    ReturnedFromServer: boolean;
    constructor(p: boolean, e: boolean);
    constructor(operIdx: number, inReturnedFromServer: boolean, inBlockIfReturnedFromServer: boolean);
    private constructor_0;
    private constructor_1;
}
