import { ForceExit, Priority } from '@magic-xpa/utils';
import { ApplicationException, List, RefParam } from '@magic-xpa/mscorelib';
import { ITask, KeyboardItem, MgControlBase, MgFormBase, Modifiers } from '@magic-xpa/gui';
import { EventSubType } from '../enums';
import { MgControl } from '../gui/MgControl';
import { CompMainPrgTable } from '../rt/CompMainPrgTable';
import { Field } from '../data/Field';
import { RunTimeEvent } from './RunTimeEvent';
import { Task } from '../tasks/Task';
import { TaskBase } from '../tasks/TaskBase';
import { ArgumentsList } from '../rt/ArgumentsList';
import { MGData } from '../tasks/MGData';
import { HandlersTable } from '../rt/HandlersTable';
import { Operation } from '../rt/Operation';
import { ExecutionStack } from '../rt/ExecutionStack';
import { ExecutionStackEntry } from '../rt/ExecutionStackEntry';
import { EventsAllowedType, IEventsManager } from './IEventsManager';
import { Subject } from 'rxjs';
import { ClearEventsOnStopExecution } from '../AccessHelper';
export declare class EventsManager implements IEventsManager {
    private static REAL_ONLY;
    private static MAX_OPER;
    private static userGrantedForContextActivity;
    private _eventsQueue;
    private _execStack;
    private _rtEvents;
    private _serverExecStack;
    private _allowEvents;
    private _compMainPrgTab;
    private _currCtrl;
    private _currField;
    private _currKbdItem;
    private _endOfWork;
    private _eventScope;
    private _forceExit;
    private _forceExitTask;
    private _ignoreUnknownAbort;
    private _initialized;
    private _isHandlingForceExit;
    private _isNonReversibleExit;
    private _isInRecordFlushEvent;
    private static clientInactivityTimerON;
    private static clientContextInactivityTimerAborted;
    private lastSavedRouteEvent;
    private _stopExecution;
    private _processingTopMostEndTask;
    private _stopExecutionCtrl;
    guiPendingEvent: any;
    readonly KBI_DOWN: KeyboardItem;
    readonly KBI_UP: KeyboardItem;
    readonly confirmationDialogMsg: string;
    readonly confirmationDialogTitle: string;
    static Instance: EventsManager;
    private _lastFailedFocusedControl;
    private isSpinnerShown;
    private isInViewRefresh;
    SpinnerStopped: Subject<number>;
    static clientBusyTimeStart: number;
    private constructor();
    getPendingGuiEvent(): any;
    setPendingGuiEvent(guiEvent: any): void;
    addToTail(rtEvt: RunTimeEvent): void;
    AddKeyboardEvent(mgForm: MgFormBase, mgControl: MgControlBase, modifier: Modifiers, keyCode: number, start: number, end: number, text: string, isActChar: boolean, suggestedValue: string, code: number): void;
    checkParkability(): Promise<void>;
    HandleParkabilityOnRowChange(itask: ITask): Promise<void>;
    HandleNonParkableControls(itask: ITask): Promise<void>;
    handleEvent(rtEvt: RunTimeEvent, returnedFromServer: boolean): Promise<void>;
    private simulateSelection;
    handleInternalEventWithTask(itask: ITask, eventCode: number): Promise<void>;
    handleInternalEventWithTaskAndSubformRefresh(itask: ITask, eventCode: number, subformRefresh: boolean): Promise<void>;
    handleInternalEventWithMgControlBase(ctrl: MgControlBase, eventCode: number): Promise<void>;
    GetStopExecutionFlag(): boolean;
    private getStopExecutionCtrl;
    Init(): void;
    addInternalEventWithItaskAndCode(itask: ITask, code: number): void;
    addInternalEventWithCtrlAndCode(ctrl: MgControlBase, code: number): void;
    addInternalEventWithCtrlAndDisplayLineAndCode(ctrl: MgControlBase, DisplayLine: number, code: number): void;
    addInternalEventWithCtrlAndCodeAndPriority(ctrl: MgControlBase, code: number, priority: Priority): void;
    addGuiTriggeredEventWithTaskAndCodeAndOnMultiMark(itask: ITask, code: number): void;
    addGuiTriggeredEventWithCtrlAndCodeAndLineAndModifier(ctrl: MgControlBase, code: number, line: number): void;
    addGuiTriggeredEventWithTaskAndCodeAndLine(task: Task, code: number, line: number): void;
    AddColumnClickEvent(columnCtrl: MgControlBase, direction: number, columnHeader: string): void;
    AddRouteEvent(task: ITask, code: number, routerpath: string, routerOutletName: string, routeParams: List<any>): void;
    AddRouterClosedEvent(task: Task): void;
    AddLastSavedRouteEvent(srcTask: Task, args: ArgumentsList): void;
    AddExternalValueEvent(ctrl: MgControl, value: any, refreshDisplay: boolean): void;
    addGuiTriggeredEventWithCtrlAndCodeAndLine(ctrl: MgControlBase, code: number, line: number): void;
    addGuiTriggeredEventWithCtrlAndLineAndCodeAndIsProductClick(ctrl: MgControlBase, code: number, line: number, isProduceClick: boolean): void;
    addGuiTriggeredEventWithCtrlAndCodeAndList(ctrl: MgControlBase, code: number, list: List<MgControlBase>): void;
    addGuiTriggeredEventWithTaskAndCode(task: ITask, code: number): void;
    addGuiTriggeredEventTaskAndCodeAndRaisedBy(task: ITask, code: number): void;
    private getEvent;
    getForceExit(): ForceExit;
    private setForceExit;
    private getForceExitTask;
    private setForceExitTask;
    isForceExitPreRecordUpdate(task: TaskBase): boolean;
    ExecuteClientContextInactivityTimer(): Promise<void>;
    CheckAndShowSpinner(show: boolean): Promise<void>;
    EventsLoop(mgData: MGData): Promise<void>;
    NonInteractiveEventsLoop(mgData: MGData, taskBase: TaskBase): Promise<void>;
    handleEvents(baseMgData: MGData, eventsToHandleCnt: number): Promise<void>;
    handleEvents(handlersTab: HandlersTable, rtEvt: RunTimeEvent): Promise<void>;
    private handleEvents_0;
    private handleStopExecution;
    private handleForceExitBefore;
    private handleForceExitAfter;
    private handleEvents_1;
    private handleKeyDown;
    private handleSelection;
    private handleMouseUp;
    checkAndSaveRouteEventIfCtxRemovedFromSrvr(aRtEvt: any): void;
    private handleFocus;
    private HandleSubformModality;
    private handleFocusOnNonMagicControl;
    private canGoToControl;
    private handleTimer;
    private handleContextInactivityAlert;
    handleExpressionHandlers(): Promise<void>;
    private handleResize;
    private handleRowDataCurPage;
    private handleTransferDataToGui;
    private fetchRecordsAheadFromServer;
    private handleEnableEvents;
    private handleCtrlPrefix;
    private commonHandlerBefore;
    protected selectProg(ctrl: MgControl): Promise<boolean>;
    private executeControlVerification;
    private onActSelection;
    private onSubformClose;
    performSubformClose(subformCtrl: MgControl): Promise<void>;
    private createEventArguments;
    DoTaskLevelRecordSuffix(task: TaskBase, refDoSuffix: RefParam<boolean>): Promise<boolean>;
    DoTaskLevelRecordPrefix(task: TaskBase): Promise<void>;
    private commonHandler;
    private HandleActEnterRowEditing;
    private HandleStopRowEditing;
    private OpenSubform;
    private static HandleRollbackAction;
    private HandleActCancel;
    private static HandleCancelEdit;
    private HandleActionDelline;
    private handleRefreshEvents;
    private gotoCreateMode;
    private commonHandlerAfter;
    handleNonReversibleEvent(task: TaskBase, eventCode: number): Promise<void>;
    handleInternalEventWithTaskAndEventSubtype(task: TaskBase, eventCode: number, eventSubType: EventSubType): Promise<void>;
    private handleInternalEventWithMgControl;
    getCurrField(): Field;
    getCurrCtrl(): MgControl;
    getCurrTask(): Task;
    setStopExecution(stop: boolean): void;
    setStopExecution(stop: boolean, clearEventsOnStopExecution: ClearEventsOnStopExecution): void;
    private setStopExecution_0;
    private setStopExecution_1;
    setStopExecutionCtrl(ctrl: MgControl): void;
    private delCurrRec;
    private updateConfirmed;
    setCompMainPrgTab(compMainPrgTable: CompMainPrgTable): void;
    setEndOfWork(endOfWork_: boolean): void;
    getEndOfWork(): boolean;
    getCompMainPrgTab(): CompMainPrgTable;
    inNonReversibleExit(): boolean;
    pushRtEvent(rtEvt: RunTimeEvent): void;
    popRtEvent(): RunTimeEvent;
    storeLastSavedRouteEventOnLocalStorage(): void;
    restoreLastSavedRouteEventFromLocalStorage(): void;
    getLastSavedRouteEvent(): RunTimeEvent;
    setLastSavedRouteEvent(rtEvt: RunTimeEvent): void;
    getLastRtEvent(): RunTimeEvent;
    setIgnoreUnknownAbort(val: boolean): void;
    ignoreUnknownAbort(): boolean;
    failTaskOverlay(taskId: string, mgd: MGData): Promise<void>;
    isEventScopeTrans(): boolean;
    setEventScopeTrans(): void;
    clearEventScope(): void;
    GetEventTime(): number;
    getMatchingAction(kbItm: KeyboardItem): number;
    getExecStack(): ExecutionStack;
    pushExecStack(taskId: string, handlerId: string, operIdx: number): void;
    popExecStack(): ExecutionStackEntry;
    pushNewExecStacks(): void;
    popNewExecStacks(): void;
    pushServerExecStack(taskId: string, handlerId: string, operIdx: number): void;
    clearServerExecStack(): void;
    reverseServerExecStack(): void;
    getNextOperIdx(oper: Operation, clearWhenFound: boolean): number;
    setProcessingTopMostEndTask(inProcessingTopMostEndTask: boolean): void;
    getProcessingTopMostEndTask(): boolean;
    setAllowEvents(AllowEvents: EventsAllowedType): void;
    setNonInteractiveAllowEvents(AllowEvents: boolean): void;
    getAllowEvents(): EventsAllowedType;
    NoEventsAllowed(): boolean;
    private handleCtrlModify;
    private ActAllowed;
    private commitRecord;
    incLocateTimerCB(taskObj: any): void;
    private static doSyncForSubformParent;
    ProcessAbortingError(ex: ApplicationException): Promise<void>;
    processHTMLContent(htmlContent: string): void;
    ShowErrorInMessageBox(ex: ApplicationException): boolean;
    getIsInViewRefresh(): boolean;
    setIsInViewRefresh(inViewRefresh: boolean): void;
}
