import { ApplicationException, RefParam } from "@magic-xpa/mscorelib";
import { GuiTaskBase, IGuiEventsManager, ITask, KeyboardItem, MgControlBase } from "@magic-xpa/gui";
import { RunTimeEvent } from "./RunTimeEvent";
import { ExecutionStackEntry } from "../rt/ExecutionStackEntry";
import { ExecutionStack } from "../rt/ExecutionStack";
import { CompMainPrgTable } from "../rt/CompMainPrgTable";
import { Field } from "../data/Field";
import { Task } from "../tasks/Task";
import { MgControl } from "../gui/MgControl";
import { EventSubType } from "../enums";
import { HandlersTable } from "../rt/HandlersTable";
import { MGData } from "../tasks/MGData";
import { TaskBase } from "../tasks/TaskBase";
import { Subject } from 'rxjs/internal/Subject';
import { ClearEventsOnStopExecution } from '../AccessHelper';
export declare enum EventsAllowedType {
    NONE = 0,
    NON_INTERACTIVE = 1,
    ALL = 2
}
export interface IEventsManager extends IGuiEventsManager {
    getMatchingAction(kbItm: KeyboardItem): number;
    ignoreUnknownAbort(): boolean;
    getLastRtEvent(): RunTimeEvent;
    getNextOperIdx(oper: any, clearWhenFound: boolean): number;
    pushExecStack(taskId: string, handlerId: string, operIdx: number): void;
    performSubformClose(subformCtrl: MgControl): Promise<void>;
    handleEvent(rtEvt: any, returnedFromServer: boolean): Promise<void>;
    popExecStack(): ExecutionStackEntry;
    addToTail(rtEvt: RunTimeEvent): void;
    getExecStack(): ExecutionStack;
    getCompMainPrgTab(): CompMainPrgTable;
    handleInternalEventWithTask(itask: ITask, eventCode: number): Promise<void>;
    getCurrField(): Field;
    getCurrTask(): Task;
    pushNewExecStacks(): void;
    popNewExecStacks(): void;
    GetStopExecutionFlag(): boolean;
    getCurrCtrl(): MgControl;
    setStopExecution(stop: boolean): void;
    setStopExecution(stop: boolean, clearEventsOnStopExecution: ClearEventsOnStopExecution): void;
    handleInternalEventWithTaskAndSubformRefresh(itask: ITask, eventCode: number, subformRefresh: boolean): Promise<void>;
    reverseServerExecStack(): void;
    pushServerExecStack(taskId: string, handlerId: string, operIdx: number): void;
    isForceExitPreRecordUpdate(task: GuiTaskBase): boolean;
    handleInternalEventWithTaskAndEventSubtype(task: GuiTaskBase, eventCode: number, eventSubType: EventSubType): Promise<void>;
    handleInternalEventWithMgControlBase(ctrl: MgControlBase, eventCode: number): Promise<void>;
    DoTaskLevelRecordSuffix(task: TaskBase, refDoSuffix: RefParam<boolean>): Promise<boolean>;
    HandleNonParkableControls(itask: ITask): Promise<void>;
    HandleParkabilityOnRowChange(itask: ITask): Promise<void>;
    DoTaskLevelRecordPrefix(task: GuiTaskBase): Promise<void>;
    getProcessingTopMostEndTask(): boolean;
    handleNonReversibleEvent(task: GuiTaskBase, eventCode: number): Promise<void>;
    handleEvents(baseMgData: MGData, eventsToHandleCnt: number): Promise<void>;
    handleEvents(handlersTab: HandlersTable, rtEvt: RunTimeEvent): Promise<void>;
    handleEvents(baseMgDataOrHandlersTab: any, eventsToHandleCntOrRtEvt: any): Promise<void>;
    setEventScopeTrans(): void;
    isEventScopeTrans(): boolean;
    clearEventScope(): void;
    addInternalEventWithItaskAndCode(itask: ITask, code: number): void;
    setProcessingTopMostEndTask(inProcessingTopMostEndTask: boolean): void;
    NonInteractiveEventsLoop(mgData: MGData, taskBase: GuiTaskBase): Promise<void>;
    EventsLoop(mgData: MGData): Promise<void>;
    setIgnoreUnknownAbort(val: boolean): void;
    setCompMainPrgTab(compMainPrgTable: CompMainPrgTable): void;
    ProcessAbortingError(ex: ApplicationException): Promise<void>;
    getAllowEvents(): EventsAllowedType;
    setAllowEvents(AllowEvents: EventsAllowedType): void;
    setNonInteractiveAllowEvents(AllowEvents: boolean): void;
    getPendingGuiEvent(): any;
    setPendingGuiEvent(guiEvent: any): void;
    checkAndSaveRouteEventIfCtxRemovedFromSrvr(rtEvent: any): void;
    CheckAndShowSpinner(show: boolean): Promise<void>;
    SpinnerStopped: Subject<number>;
    getIsInViewRefresh(): boolean;
    setIsInViewRefresh(inViewRefresh: boolean): void;
}
