import { IComparable, List, StringBuilder } from "@magic-xpa/mscorelib";
import { Priority } from "@magic-xpa/utils";
import { GuiFieldBase, LastFocusedVal, MgControlBase } from "@magic-xpa/gui";
import { EventSubType } from "../enums";
import { Event } from "./Event";
import { ArgumentsList } from "../rt/ArgumentsList";
import { MGData } from "../tasks/MGData";
import { TaskBase } from "../tasks/TaskBase";
import { RunTimeEventBase } from "./RunTimeEventBase";
export declare class RunTimeEvent extends RunTimeEventBase implements IComparable {
    private _controlsList;
    private _direction;
    private _displayLine;
    private _eventSubType;
    private _actEnableList;
    private _argList;
    private _ctrl;
    private _dotNetObject;
    private _eventFld;
    private _fromServer;
    private _guiTriggeredEvent;
    private _immediate;
    private _isIdleTimer;
    private _isRealRefresh;
    private _mgdId;
    private _routeParams;
    private _mprgCreator;
    private _priority;
    private _produceClick;
    private _reversibleExit;
    private _selectionEnd;
    private _selectionStart;
    private _sendAll;
    private _task;
    private _taskTag;
    private _val;
    set Control(value: MgControlBase);
    set DisplayLine(value: number);
    get Control(): MgControlBase;
    IgnoreSpecifiedControl: boolean;
    LastFocusedVal: LastFocusedVal;
    get ControlsList(): List<MgControlBase>;
    get Direction(): number;
    constructor(taskRef: TaskBase);
    constructor(taskRef: TaskBase, ctrlRef: MgControlBase);
    constructor(ctrlRef: MgControlBase);
    constructor(ctrlRef: MgControlBase, guiTriggeredEvent: boolean);
    constructor(ctrlRef: MgControlBase, guiTriggeredEvent: boolean, ignoreSpecifiedControl: boolean);
    constructor(taskref: TaskBase, guiTriggeredEvent: boolean);
    constructor(fldRef: GuiFieldBase);
    constructor(ctrlRef: MgControlBase, line: number);
    constructor(ctrlRef: MgControlBase, line: number, guiTriggeredEvent: boolean);
    constructor(ctrlRef: MgControlBase, controlsList: List<MgControlBase>, guiTriggeredEvent: boolean);
    constructor(ctrlRef: MgControlBase, direction: number, line: number);
    constructor(ctrlRef: MgControlBase, columnHeader: string, x: number, y: number, width: number, height: number);
    constructor(evt: Event, rtEvt: RunTimeEvent);
    constructor(rtEvt: RunTimeEvent);
    private constructor_5;
    private constructor_6;
    private constructor_7;
    private constructor_8;
    private constructor_9;
    private constructor_10;
    private constructor_11;
    private constructor_12;
    private constructor_13;
    private constructor_14;
    private constructor_15;
    private constructor_16;
    private constructor_17;
    CompareTo(obj: any): number;
    replicate(): RunTimeEvent;
    private init;
    convertParamsToArgs(): void;
    getTask(): TaskBase;
    setTask(taskRef: TaskBase): void;
    setTimer(sec: number, mgdID: number, isIdle: boolean): void;
    getDisplayLine(): number;
    getMgdID(): number;
    getBrkLevel(): string;
    getBrkLevel(flowMonitor: boolean): string;
    private getBrkLevel_00;
    private getBrkLevel_01;
    setCtrl(newCtrl: MgControlBase): void;
    setNonReversibleExit(): void;
    reversibleExit(): boolean;
    buildXML(message: StringBuilder): void;
    getArgList(): ArgumentsList;
    setArgList(aArgList: ArgumentsList): boolean;
    setRouteParamList(routeParams: List<any>): void;
    getRouteParamList(): List<any>;
    setImmediate(val: boolean): void;
    isImmediate(): boolean;
    setMainPrgCreator(src: TaskBase): void;
    getMainPrgCreator(): TaskBase;
    setIsRealRefresh(val: boolean): void;
    getRefreshType(): boolean;
    setFromServer(): void;
    resetFromServer(): void;
    isFromServer(): boolean;
    isQuit(): boolean;
    RollbackInCancel(): boolean;
    ExitDueToError(): boolean;
    RtViewRefreshUseCurrentRow(): boolean;
    SetEventSubType(eventSubType: EventSubType): void;
    getFld(): GuiFieldBase;
    isGuiTriggeredEvent(): boolean;
    getPriority(): Priority;
    setPriority(priority: Priority): void;
    isIdleTimer(): boolean;
    getValue(): any;
    setValue(val: any): void;
    getStartSelection(): number;
    getEndSelection(): number;
    setEditParms(start: number, end: number, text: string): void;
    isProduceClick(): boolean;
    setProduceClick(produceClick: boolean): void;
    getActEnableList(): number[];
    isSendAll(): boolean;
    setSendAll(sendAll: boolean): void;
    isBlockedByModalWindow(activeWindowData: MGData): boolean;
    toString(): string;
}
