import { CommandType, MgControlBase, MgFormBase, PropParentInterface } from '@magic-xpa/gui';
import { MgControlType, TableBehaviour, XmlParser } from '@magic-xpa/utils';
import { ArgumentsList } from '../rt/ArgumentsList';
import { TaskBase } from '../tasks/TaskBase';
import { MgForm } from './MgForm';
export declare class MgControl extends MgControlBase implements PropParentInterface {
    private _focusedStopExecution;
    private _inControlSuffix;
    private _rtEvtTask;
    private _subformTaskId;
    private _subformTask;
    IsInteractiveUpdate: boolean;
    private refreshOnString;
    SubformLoaded: boolean;
    HasZoomHandler: boolean;
    ArgList: ArgumentsList;
    static ReturnToCtrl: MgControl;
    private initialize;
    constructor();
    constructor(type: MgControlType);
    constructor(type: MgControlType, task: TaskBase, parentControl: number);
    constructor(type: MgControlType, parentMgForm: MgFormBase, parentControlIdx: number);
    GetVarIndex(): number;
    fillData(mgForm: MgFormBase, ditIdx: number, parser: XmlParser): Promise<void>;
    SetAttribute(attribute: string, valueStr: string): boolean;
    private GetArgumentList;
    isDescendent(parentForm: MgForm): boolean;
    refreshOnExpression(): Promise<void>;
    invoke(): Promise<boolean>;
    isParkable(checkEnabledAndVisible: boolean): Promise<boolean>;
    getSubformTaskId(): string;
    initSubformTask(): void;
    getParentTable(): MgControl;
    restoreOldValue(): Promise<void>;
    setRtEvtTask(curTask: TaskBase): void;
    getRtEvtTask(): TaskBase;
    setSubformTaskId(taskId: string): void;
    isFocusedStopExecution(): boolean;
    setFocusedStopExecution(focusedStopExecution: boolean): void;
    onTheSameSubFormControl(ctrl: MgControl): boolean;
    onDiffForm(ctrl: MgControl): boolean;
    isInControlSuffix(): boolean;
    setInControlSuffix(inControlSuffix: boolean): void;
    HasSelectProgram(): boolean;
    useZoomHandler(): boolean;
    updatePropertyLogicNesting(propId: number, commandType: CommandType, val: boolean, updateThis: boolean): Promise<void>;
    private ShouldSetSubformInvisible;
    updateSubformChildrenPropValue(propId: number, commandType: CommandType, val: boolean): Promise<void>;
    Init(): void;
    GetTableBehaviour(): TableBehaviour;
    validateAndSetValue(NewValue: any, updateCtrl: boolean): Promise<boolean>;
    private setValue;
    getSubformTask(): TaskBase;
    resetSubformTask(): void;
    GetSubformMgForm(): MgFormBase;
    IsTableWithAbsoluteScrollbar(): boolean;
    static validReturnToCtrl(): boolean;
    maySetValue(): boolean;
    validateAndSetValueIfAllowed(NewValue: any, refreshDisplay: boolean): Promise<boolean>;
}
