import { RefParam } from "@magic-xpa/mscorelib";
import { ICommunicationsFailureHandler } from "./ICommunicationsFailureHandler";
import { HttpHeaders, HttpResponse } from "@angular/common/http";
export declare enum RequestMethod {
    Get = 0,
    Post = 1,
    Put = 2,
    Delete = 3,
    Options = 4,
    Head = 5,
    Patch = 6
}
export declare abstract class HttpClientBase {
    private _HTTPMaxURLLength;
    CommunicationsFailureHandler: ICommunicationsFailureHandler;
    constructor();
    private DecideOnRequestMethod;
    GetContent(requestURL: string, requestContent: any, useCache: boolean): Promise<string>;
    private ExecuteHttpRequest;
    private LogRequestInfo;
    private static HeadersToString;
    abstract prepareRequest(): any;
    abstract addHeaders(urlString: string, useCache: boolean, httpHeaders: HttpHeaders, clientID: string): HttpHeaders;
    sendRequestToServer(httpMethod: RequestMethod, urlString: string, httpHeaders: HttpHeaders, requestContent: string, contentFromServer: RefParam<string>): Promise<any>;
    abstract logResponse(httpResponse: HttpResponse<string>, clientID: string, urlString: string, contentFromServer: RefParam<any>, timeBeforeRequest: number): any;
    abstract handleHttpErrorException(ex: any, urlString: string): any;
    shouldRetry(httpCommunicationTimeoutMS: number, urlString: string, communicationsFailureHandler: ICommunicationsFailureHandler, ex: any, startTimeRef: RefParam<number>): Promise<boolean>;
    abstract logAndThrowException(ex: any): any;
    abstract logExecutionAttempts(executionAttempts: number): any;
}
