import { HttpHeaders, HttpResponse } from "@angular/common/http";
import { RefParam } from "@magic-xpa/mscorelib";
import { HttpClientBase, RequestMethod } from "./HttpClientBase";
import { ICommunicationsFailureHandler } from "./ICommunicationsFailureHandler";
export declare class HttpClientSync extends HttpClientBase {
    private httpRequest;
    private headers;
    constructor();
    prepareRequest(): void;
    addHeaders(urlString: string, useCache: boolean, httpHeaders: HttpHeaders, clientID: string): HttpHeaders;
    sendRequestToServer(httpMethod: RequestMethod, urlString: string, httpHeaders: HttpHeaders, requestContent: string, contentFromServer: RefParam<string>): Promise<any>;
    logResponse(httpResponse: HttpResponse<string>, clientID: string, urlString: string, contentFromServer: RefParam<any>, timeBeforeRequest: number): void;
    handleHttpErrorException(ex: any, urlString: string): void;
    shouldRetry(httpCommunicationTimeoutMS: number, urlString: string, communicationsFailureHandler: ICommunicationsFailureHandler, ex: any, startTimeRef: RefParam<number>): Promise<boolean>;
    logAndThrowException(ex: any): void;
    logExecutionAttempts(executionAttempts: number): void;
}
