import { Logger_LogLevels } from "@magic-xpa/utils";
import { CommandsProcessorBase, CommandsProcessorBase_SendingInstruction, CommandsProcessorBase_SessionStage } from "../CommandsProcessorBase";
import { IResultValue } from "../rt/IResultValue";
import { OpeningTaskDetails } from "../tasks/TaskBase";
export declare class RemoteCommandsProcessor extends CommandsProcessorBase {
    static readonly RC_NO_CONTEXT_ID: string;
    private static _instance;
    static IsSessionReInitializing: boolean;
    private static lastExceptionMessage;
    private static InitialUrl;
    private static readonly WEB_COMMUNICATION_PROTOCOL_VERSION;
    private _lastRequestTime;
    ServerUrl: string;
    private static _shouldScrambleAndUnscrambleMessages;
    SessionId: string;
    DelayCommandExecution: boolean;
    private _requestInfo;
    static GetInstance(): RemoteCommandsProcessor;
    private constructor();
    CheckAndSetSessionCounter(newSessionCounter: number): void;
    ClearSessionCounter(): void;
    private SetSessionCounter;
    get GetLastRequestTime(): number;
    ReStartSession(): Promise<void>;
    StoreSessionReInitializingDataOnLocalStorage(): Promise<void>;
    RestoreSessionReInitializingDataFromLocalStorage(key: string): string;
    StartSession(): Promise<boolean>;
    private PrepareAuthenticationUrl;
    private ExecuteInitialRequest;
    private GetTaskTree;
    private UpdateRequestInfo;
    private BuildXMLForMainProgramDataView;
    Execute_1(sendingInstruction: CommandsProcessorBase_SendingInstruction, sessionStage: CommandsProcessorBase_SessionStage, res: IResultValue): Promise<void>;
    private DispatchRequest;
    clearLocalStorage(): void;
    private HandleErrorResponse;
    private ExecuteRequest;
    GetContent(requestedURL: string, useCache: boolean, requestContent?: string): Promise<string>;
    ClientActivated(): void;
    private BuildUrlSuffix;
    SendMonitorOnly(): Promise<void>;
    private BuildMonitorMessage;
    RegisterDelegates(): void;
    ComputeAndLogRequestInfo(contentLength: number, roundTrip: number, isLoggingResponse: boolean): void;
    static set ShouldScrambleAndUnscrambleMessages(value: boolean);
    static get ShouldScrambleAndUnscrambleMessages(): boolean;
    parseLogLevel(strLogLevel: string): Logger_LogLevels;
    PrepareRequest(serializeTasks: boolean): Promise<string>;
    ProcessResponse(response: string, currMgdID: number, openingTaskDetails: OpeningTaskDetails, res: IResultValue): Promise<void>;
    ProcessRecovery(): Promise<void>;
}
