import { List, StringBuilder } from "@magic-xpa/mscorelib";
import { IMGDataTable, ITask, MgFormBase } from "@magic-xpa/gui";
import { MGData } from "./MGData";
import { TaskBase } from "./TaskBase";
import { IClientCommand } from "../commands/IClientCommand";
import { CommandsTable } from "../CommandsTable";
import { Expression } from "../exp/Expression";
export interface IMGDataCollection extends IMGDataTable {
    currMgdID: number;
    StartupMgData: MGData;
    getMGData(idx: number): MGData;
    getTaskIdById(taskId: string): string;
    getSize(): number;
    getMGData(idx: number): MGData;
    startTasksIteration(): void;
    getNextTask(): ITask;
    GetTopMostForms(): List<MgFormBase>;
    getCurrMGData(): MGData;
    GetMGDataForStartupProgram(): MGData;
    getTriggeredTasks(triggeringTask: TaskBase): List<TaskBase>;
    getAvailableIdx(): number;
    addMGData(mgd: MGData, idx: number, isStartup: boolean): void;
    buildXML(message: StringBuilder, serializeTasks: boolean): void;
    processRecovery(): void;
    execRequestWithSubformRecordCycle(cmdsToServer: CommandsTable, cmdToServer: IClientCommand, exp: Expression): Promise<void>;
}
