import { HandlersTable } from "../rt/HandlersTable";
import { ICommandsTable } from "../ICommandsTable";
import { Task } from "./Task";
import { OpeningTaskDetails } from "./TaskBase";
import { XmlParser } from "@magic-xpa/utils";
import { List, StringBuilder } from "@magic-xpa/mscorelib";
import { TaskDefinitionId } from "@magic-xpa/gui";
import { EventHandler } from "../event/EventHandler";
export declare class MGData {
    private _expHandlers;
    private _id;
    private _parent;
    private _mprgTab;
    private _tasksTab;
    private _timerHandlers;
    private _timersStarted;
    private forceModal;
    CmdsToClient: ICommandsTable;
    CmdsToServer: ICommandsTable;
    IsModal: boolean;
    IsAborting: boolean;
    get ForceModal(): boolean;
    constructor(toClient: ICommandsTable, toServer: ICommandsTable, id: number, parent: MGData, isModal: boolean);
    constructor(toClient: ICommandsTable, toServer: ICommandsTable, id: number, parent: MGData, isModal: boolean, forceModal: boolean);
    private constructor_0;
    private constructor_1;
    GetId(): number;
    AlreadyMovedToFirstControl(): boolean;
    StartTimers(): void;
    fillData(openingTaskDetails: OpeningTaskDetails, parser: XmlParser): Promise<void>;
    private initInnerObjects;
    private insertDataView;
    addTask(newTask: Task): void;
    removeTask(task: Task): void;
    getTasksCount(): number;
    getTask(taskId: string): Task;
    getTask(idx: number): Task;
    private getTask_0;
    private getTask_1;
    buildXML(message: StringBuilder, serializeTasks: boolean): Promise<void>;
    getFirstTask(): Task;
    getMainProg(ctlIdx: number): Task;
    getNextMainProg(ctlIdx: number): Task;
    clientTransactionCacheExists(): boolean;
    serverTransactionCacheExists(): boolean;
    getTaskByTaskDefinitionID(taskDefinitionID: TaskDefinitionId): Task;
    getTimerHandlers(): HandlersTable;
    addTimerHandler(handler: EventHandler): void;
    removeTimerHandler(task: Task): void;
    removeExpressionHandler(task: Task): void;
    getExpHandlers(): HandlersTable;
    addExpHandler(handler: EventHandler, idx: number): void;
    changeTimers(oldTimers: List<number>, newTimers: List<number>): void;
    private fillEventsQueue;
    private initEvents;
    isMainWindow(): boolean;
    getParentMGdata(): MGData;
    abort(): void;
    copyUnframedCmds(): void;
    getValidAncestor(): MGData;
    getMaxCtlIdx(): number;
    fillGlobalParams(parser: XmlParser): void;
}
