import { List, StringBuilder } from "@magic-xpa/mscorelib";
import { ITask, MgFormBase } from "@magic-xpa/gui";
import { MGData } from "./MGData";
import { Task } from "./Task";
import { IMGDataCollection } from "./IMGDataCollection";
import { CommandsTable } from "../CommandsTable";
import { IClientCommand } from "../commands/IClientCommand";
import { Expression } from "../exp/Expression";
export declare class MGDataCollection implements IMGDataCollection {
    private static _instance;
    private _mgDataTab;
    private _iteratorMgdIdx;
    private _iteratorTaskIdx;
    currMgdID: number;
    StartupMgData: MGData;
    private _lastRouteSentToServer;
    constructor();
    GetTaskByID(id: string): ITask;
    static get Instance(): MGDataCollection;
    addMGData(mgd: MGData, idx: number, isStartup: boolean): Promise<void>;
    getMGData(idx: number): MGData;
    getAvailableIdx(): number;
    getMgDataIdx(mgd: MGData): number;
    deleteMGDataTree(index: number): void;
    getCurrMGData(): MGData;
    GetMainProgByCtlIdx(contextIDOrCtlIdx: any, ctlIdx?: number): Task;
    private GetMainProgByCtlIdx_0;
    private GetMainProgByCtlIdx_1;
    startTasksIteration(): void;
    getNextTask(): ITask;
    buildXML(message: StringBuilder, serializeTasks: boolean): Promise<void>;
    getSize(): number;
    processRecovery(): Promise<void>;
    getTriggeredTasks(triggeringTask: Task): List<Task>;
    GetTasks(p: (obj: Task) => boolean): List<Task>;
    getTaskIdById(taskId: string): string;
    GetTopMostForms(): List<MgFormBase>;
    GetMGDataForStartupProgram(): MGData;
    execRequestWithSubformRecordCycle(cmdsToServer: CommandsTable, cmdToServer: IClientCommand, exp: Expression): Promise<void>;
    cleanDoSubformPrefixSuffix(): void;
    execAllSubformRecordCycle(): Promise<void>;
}
