import { TaskServiceBase } from './TaskServiceBase';
import { DataviewManagerBase } from '../data/DataviewManagerBase';
import { ReturnResult } from '../util/ReturnResult';
import { Task } from './Task';
export declare class RemoteTaskService extends TaskServiceBase {
    constructor();
    GetTaskTag(defaultValue: string): string;
    GetDataviewManagerForVirtuals(task: Task): DataviewManagerBase;
    PrepareTask(task: Task): ReturnResult;
    GetEventTaskId(originalTaskId: string): string;
    ShouldEvaluatePropertyLocally(propId: number): boolean;
    InitTaskPrefixExecutedFlag(task: Task): void;
    RemoveRecomputes(parentTask: Task): void;
    GetOwnerTransactionTask(task: Task): Task;
    static PreparePropMainDisplay(task: Task): Promise<ReturnResult>;
}
