import { List, RefParam, StringBuilder } from '@magic-xpa/mscorelib';
import { StorageAttribute, UniqueTskSort, XmlParser } from '@magic-xpa/utils';
import { FieldDef, ITask, MgControlBase, MgFormBase, TaskDefinitionId } from '@magic-xpa/gui';
import { Event } from '../event/Event';
import { DvCache } from '../data/DvCache';
import { MGData } from './MGData';
import { CommandsProcessorBase } from '../CommandsProcessorBase';
import { TaskServiceBase } from './TaskServiceBase';
import { ArgumentsList } from '../rt/ArgumentsList';
import { TaskTransactionManager } from '../data/TaskTransactionManager';
import { SortCollection } from './sort/SortCollection';
import { MgControl } from '../gui/MgControl';
import { ReturnResult } from '../util/ReturnResult';
import { DataviewHeaders } from '../rt/DataviewHeaders';
import { Transaction } from '../rt/Transaction';
import { TasksTable } from './TasksTable';
import { HandlersTable } from '../rt/HandlersTable';
import { ExpTable } from '../exp/ExpTable';
import { UserEventsTable } from '../event/UserEventsTable';
import { FormsTable } from '../gui/FormsTable';
import { Field } from '../data/Field';
import { Expression } from '../exp/Expression';
import { OpeningTaskDetails, TaskBase, UserRange } from './TaskBase';
export declare enum Task_Flow {
    NONE = 0,
    STEP = 1,
    FAST = 2
}
export declare enum Task_Direction {
    BACK = -1,
    NONE = 0,
    FORE = 1
}
export declare class Task extends TaskBase {
    private _dvCache;
    private _mgData;
    private _aborting;
    private _bExecEndTask;
    private _isStarted;
    private _evalOldValues;
    private _inRecordSuffix;
    private _cancelWasRaised;
    private _counter;
    private _currStartProgLevel;
    private _destinationSubform;
    private _enableZoomHandler;
    private _firstRecordCycle;
    private _originalTaskMode;
    private _inCreateLine;
    InSelect: boolean;
    InStartProcess: boolean;
    private _isDestinationCall;
    private _knownToServer;
    private _loopStack;
    private allowRemoteCmdExecution;
    DelayCommandExecution: boolean;
    private _parentTask;
    get ParentTask(): TaskBase;
    ContextTask: Task;
    private _triggeringTask;
    PathParentTask: Task;
    private _preventControlChange;
    private _preventRecordSuffix;
    private _taskPath;
    private _tryingToCommit;
    set TryingToCommit(value: boolean);
    get TryingToCommit(): boolean;
    private _useLoopStack;
    private _inProcessingTopMostEndTaskSaved;
    InHandleActCancel: boolean;
    RuntimeSorts: SortCollection;
    VewFirst: number;
    dataViewContent: string;
    PerformParentRecordPrefix: boolean;
    ModeAsParent: boolean;
    TaskTransactionManager: TaskTransactionManager;
    ExecuteClientSubformRefresh: boolean;
    InCommonHandlerBeforeRP: boolean;
    private _taskService;
    get TaskService(): TaskServiceBase;
    static get CommandsProcessor(): CommandsProcessorBase;
    private hasLocate;
    private taskDefinitionId;
    ArgumentsList: ArgumentsList;
    get LogicalStudioParentTask(): Task;
    get KnownToServer(): boolean;
    ConfirmUpdateNo: boolean;
    DataSynced: boolean;
    UniqueSort: UniqueTskSort;
    set Transaction(value: Transaction);
    get Transaction(): Transaction;
    RefreshOnVars: number[];
    DvPosDescriptor: List<string[]>;
    SubTasks: TasksTable;
    ExpTab: ExpTable;
    UserEvtTab: UserEventsTable;
    DataviewHeadersTable: DataviewHeaders;
    HandlersTab: HandlersTable;
    _forms: FormsTable;
    Name: string;
    PublicName: string;
    TaskSuffixExecuted: boolean;
    get TaskDefinitionId(): TaskDefinitionId;
    RetrunValueExp: number;
    SubformControl: MgControl;
    static StartProgLevel: number;
    private static _idleTimerStarted;
    static get IsBlockingBatch(): boolean;
    constructor();
    constructor(parent: Task);
    private constructor_0;
    Init(): void;
    private constructor_1;
    static CreateTask(): TaskBase;
    isAborting(): boolean;
    private buildTaskPath;
    fillData(mgd: MGData, openingTaskDetails: OpeningTaskDetails): Promise<void>;
    HandlePreviouslyActiveTaskId(): void;
    HandleTriggerTask(): void;
    FillTaskTables(taskTablesData: string): void;
    FillTaskTables(): void;
    private FillTaskTables_0;
    fillAttributes(): void;
    setAttribute(attribute: string, valueStr: string): boolean;
    initInnerObjects(foundTagName: string, parentForm: MgFormBase): Promise<boolean>;
    RecomputeFillData(parser: XmlParser): void;
    private FillTaskTables_1;
    private addExpHandlersToMGData;
    SetRefreshOnVars(variables: string): void;
    setDataSynced(synced: boolean): void;
    getField(fldName: string): Field;
    getExpById(id: number): Expression;
    getExpObjectById(id: number): any;
    GetExpressionStorage(expId: number): any;
    CalculateExpression(expId: number, resType: StorageAttribute, length: number): Promise<string>;
    insertRecordTable(invalidate: boolean, parser: XmlParser): Promise<void>;
    getHandlersTab(): HandlersTable;
    buildXML(message: StringBuilder): Promise<void>;
    buildXMLForRngs(message: StringBuilder, UserRanges: List<UserRange>, locate: boolean): void;
    buildXMLForSorts(message: StringBuilder): void;
    getUserEvent(idx: number): Event;
    private SetMoveToFirstControl;
    Start(moveToFirstControl: boolean, callByDestSubForm: boolean): Promise<ITask>;
    private InitializeExecution;
    private InitializeForm;
    private StartSubTasks;
    private EnableActions;
    ShowError(text: string): Promise<void>;
    EndTaskOnError(result: ReturnResult, displayError: boolean): Promise<boolean>;
    private Setup;
    doFirstRecordCycle(): Promise<void>;
    private CheckAndSetSubForm;
    IsRoute(): boolean;
    stop(): Promise<void>;
    abort(): void;
    hasSubTasks(): boolean;
    getTaskDepth(byParentOrder: boolean): number;
    private getTaskDepth_;
    GetTaskAncestor(generation: number): ITask;
    private getTaskAncestor_;
    GetTaskDepth(): number;
    pathContains(task: TaskBase): boolean;
    SetContextTask(context: TaskBase): void;
    GetContextTask(): ITask;
    getTriggeringTask(): Task;
    setLastParkedCtrl(ctrl: MgControlBase): void;
    queryTaskPath(): StringBuilder;
    ctl_itm_2_parent_vee(itm: number): Field;
    GetControlIDFromVarItem(item: number): number;
    GetControlFromControlID(controlID: number, parent: RefParam<number>): MgControl;
    ctl_itm_4_parent_vee(parent: number, vee: number): number;
    getIndOfParentInTaskTree(parent: number, taskTree: Task[]): number;
    getFieldByName(fldName: string): Field;
    private getFieldByName_;
    getIndexOfFieldByName(fldName: string): number;
    pathToRoot(path: Task[], byParentOrder: boolean): void;
    private shouldBeRefreshed;
    CheckRefreshSubTasks(): Promise<boolean>;
    private GetSubTasks;
    GetSubformsToRefresh(): Promise<List<Task>>;
    ShouldRefreshSubformTask(subTask: Task): Promise<boolean>;
    SetModeAsParent(parentMode: string): Promise<void>;
    doSubformRecPrefixSuffix(): Promise<void>;
    CleanDoSubformPrefixSuffix(): void;
    mustConfirmInDeleteMode(): boolean;
    addSubTask(subTask: Task): void;
    removeSubTask(subTask: Task): void;
    setTransactionFailed(val: boolean): void;
    transactionFailed(level: string): boolean;
    setAfterRetry(val: string): void;
    getAfterRetry(): boolean;
    getAfterRetry(recovery: string): boolean;
    private getAfterRetry_0;
    private getAfterRetry_1;
    getExecEndTask(): boolean;
    resetExecEndTask(): void;
    setExecEndTask(): void;
    evalEndCond(mode: string): Promise<boolean>;
    setTryingToStop(val: boolean): void;
    getInRecordSuffix(): boolean;
    setInRecordSuffix(bValue: boolean): boolean;
    setEvalOldValues(bFlag: boolean): boolean;
    getEvalOldValues(): boolean;
    endTask(reversibleExit: boolean, onlyDescs: boolean, dueToVerifyError: boolean, subformDestination?: boolean): Promise<boolean>;
    private endTask_1;
    private SetServerSideTaskSuffix;
    private CheckIfClientOperationExistsInSubformTasks;
    private CheckIfPendingTransactions;
    private HandleTransactionInfo;
    Exit(reversibleExit: boolean, subformDestination: boolean): Promise<void>;
    private handleFinallyEndTask;
    handleTaskSuffix(withSubTasks: boolean): Promise<boolean>;
    setInCreateLine(inCreateLine: boolean): void;
    getInCreateLine(): boolean;
    handleEventOnSlaveTasks(internalEvtCode: number): Promise<Task>;
    enableRecordActions(): Promise<void>;
    isStarted(): boolean;
    getSubTasks(): TasksTable;
    refreshesOn(fldId: number): boolean;
    private AbortTransaction;
    setPreventRecordSuffix(val: boolean): void;
    getPreventRecordSuffix(): boolean;
    setPreventControlChange(val: boolean): void;
    getPreventControlChange(): boolean;
    resetKnownToServer(): void;
    evaluateDescriptor(): number;
    setDescriptor(newDesc: string): void;
    getTaskCache(): DvCache;
    prepareCache(ignoreCurr: boolean): Promise<boolean>;
    testAndSet(ignoreCurr: boolean): Promise<boolean>;
    private changeDv;
    setOriginalTaskMode(originalTaskMode: string): void;
    getOriginalTaskMode(): string;
    isCached(): Promise<boolean>;
    private locatePutInCache;
    HasLoacte(): boolean;
    private setRemoteTransaction;
    setTransOwnerTask(): void;
    getLoopCounter(): number;
    enterLoop(): void;
    leaveLoop(): void;
    popLoopCounter(): number;
    increaseLoopCounter(): void;
    getLoopStackSize(): number;
    setUseLoopStack(val: boolean): void;
    getDataviewHeaders(): DataviewHeaders;
    isFirstRecordCycle(Value_?: boolean): any;
    private isFirstRecordCycle_0;
    private isFirstRecordCycle_1;
    getPublicName(): string;
    isAllowEvents(): Promise<boolean>;
    getExternalTaskId(): string;
    isTransactionOwner(): boolean;
    isTransactionOnLevel(level: string): boolean;
    isProgram(): boolean;
    enableModes(): Promise<void>;
    setEnableZoomHandler(): void;
    getEnableZoomHandler(): boolean;
    isDestinationSubform(): boolean;
    setDestinationSubform(destinationSubform: boolean): void;
    getIsDestinationCall(): boolean;
    setIsDestinationCall(isDestinationCall: boolean): void;
    setCancelWasRaised(val: boolean): void;
    cancelWasRaised(): boolean;
    enableCreateActs(val: boolean): void;
    setCreateDeleteActsEnableState(): Promise<void>;
    setEmptyDataview(emptyDataview: boolean): void;
    getName(): string;
    emptyDataviewOpen(subformRefresh: boolean): Promise<void>;
    emptyDataviewClose(): void;
    SubformRefresh(subformTask: TaskBase, explicitSubformRefresh: boolean): Promise<void>;
    ExecuteNestedRS(lastTask: Task): Promise<boolean>;
    execSubformRecSuffix(newTask: Task): Promise<number>;
    getCounter(): number;
    increaseCounter(): void;
    setCounter(cnt: number): void;
    isCurrentStartProgLevel(): boolean;
    static isMainProgramField(fieldStr: string): boolean;
    getTaskInfo(): string;
    toString(): string;
    ConstructMgForm(alreadySetParentForm: RefParam<boolean>): MgFormBase;
    getMgdID(): number;
    getMGData(): MGData;
    RefreshDisplay(): Promise<void>;
    getFieldDisplayValue(fieldDef: FieldDef, value: RefParam<string>, isNull: RefParam<boolean>): void;
    UpdateFieldValueAndStartRecompute(fieldDef: FieldDef, value: string, isNull: boolean): Promise<void>;
    ShouldNonInteractiveChildBeModal(): boolean;
    private ShouldChildBeModal;
    getParent(): TaskBase;
    isDescendentOf(chkTask: TaskBase): boolean;
    GetSubformModalParentTask(): MgControl;
    ShouldEvaluatePropertyLocally(propId: number): boolean;
    EnsureValidForm(): void;
    ComputeMainDisplay(): Promise<void>;
    PrepareTaskForm(): Promise<ReturnResult>;
    FormIsLegal(): boolean;
    GetRealMainDisplayIndexOnDepth(mainDspIdx: number): number;
    GetRealMainDisplayIndexOnCurrentTask(mainDspIdx: number): number;
    GetAncestorTaskByTaskDefinitionId(findTaskDefinitionId: TaskDefinitionId): Task;
    SetDataControlValuesReference(controlId: number, dcValuesId: number): void;
    DisplayMessageToStatusBar(text: string): void;
    isTableWithAbsolutesScrollbar(): boolean;
    GetTaskDetails(): string;
    static ProcessTaskURL(): Promise<void>;
    private static getReflist;
    static StartProgram(callByDestSubForm: boolean, moveToFirstControl: boolean): Promise<Task>;
    static ExecuteComponentMainPrograms(callByDestSubForm: boolean, moveToFirstControl: boolean): Promise<Task>;
    private static ExecuteMainProgram;
    static OpenForms(callByDestSubForm: boolean): Promise<void>;
    static DoFirstRecordCycle(): Promise<void>;
    private static MoveToFirstControls;
}
