import { List, RefParam, StringBuilder } from '@magic-xpa/mscorelib';
import { XmlParser } from '@magic-xpa/utils';
import { GuiTaskBase } from '@magic-xpa/gui';
import { TaskServiceBase } from './TaskServiceBase';
import { Event } from '../event/Event';
import { Expression } from '../exp/Expression';
import { MGData } from './MGData';
import { DataviewManager } from '../data/DataviewManager';
import { Sort } from './sort/Sort';
import { DvCache } from '../data/DvCache';
import { MgControl } from '../gui/MgControl';
import { Field } from '../data/Field';
import { Transaction } from '../rt/Transaction';
export declare enum Task_SubformExecModeEnum {
    NO_SUBFORM = -1,
    SET_FOCUS = 0,
    FIRST_TIME = 1,
    REFRESH = 2
}
export declare abstract class TaskBase extends GuiTaskBase {
    IsTryingToStop: boolean;
    DoSubformPrefixSuffix: boolean;
    IsAfterRetryBeforeBuildXML: boolean;
    TaskSuffixExecuted: boolean;
    DataviewManager: DataviewManager;
    IsOffline: boolean;
    ResetRange: boolean;
    UserRngs: List<UserRange>;
    ResetLocate: boolean;
    UserLocs: List<UserRange>;
    ResetSort: boolean;
    UserSorts: List<Sort>;
    PreviouslyActiveTaskId: string;
    protected _transactionFailed: boolean;
    InEndTask: boolean;
    InCtrlPrefix: boolean;
    RetainFocus: boolean;
    SubformExecMode: Task_SubformExecModeEnum;
    TransactionErrorHandlingsRetry: Transaction;
    ClosingFormUI: boolean;
    AfterFirstRecordPrefix: boolean;
    static ShouldNonInteractiveBeModal(): boolean;
    abstract isDescendentOf(chkTask: TaskBase): boolean;
    abstract get TaskService(): TaskServiceBase;
    abstract getUserEvent(idx: number): Event;
    abstract getExpById(id: number): Expression;
    abstract setInRecordSuffix(bValue: boolean): boolean;
    abstract getMGData(): MGData;
    abstract ctl_itm_4_parent_vee(parent: number, vee: number): number;
    abstract getAfterRetry(): boolean;
    abstract getAfterRetry(recovery: string): boolean;
    abstract setAfterRetry(val: string): void;
    abstract setTransactionFailed(val: boolean): void;
    abstract getOriginalTaskMode(): string;
    abstract setOriginalTaskMode(originalTaskMode: string): void;
    abstract setTryingToStop(val: boolean): void;
    abstract resetExecEndTask(): void;
    abstract getTriggeringTask(): TaskBase;
    isCached(): Promise<boolean>;
    abstract getLoopCounter(): number;
    abstract getCounter(): number;
    abstract buildXMLForRngs(message: StringBuilder, UserRanges: List<UserRange>, locate: boolean): void;
    abstract buildXMLForSorts(message: StringBuilder): void;
    abstract getTaskCache(): DvCache;
    abstract isTableWithAbsolutesScrollbar(): boolean;
    prepareCache(ignoreCurr: boolean): Promise<boolean>;
    testAndSet(ignoreCurr: boolean): Promise<boolean>;
    abstract setPreventRecordSuffix(val: boolean): void;
    abstract transactionFailed(level: string): boolean;
    abstract HasLoacte(): boolean;
    abstract isTransactionOwner(): boolean;
    abstract getParent(): TaskBase;
    abstract getMgdID(): number;
    SubformRefresh(subformTask: TaskBase, explicitSubformRefresh: boolean): Promise<void>;
    abstract setExecEndTask(): void;
    stop(): Promise<void>;
    abstract abort(): void;
    abstract enableCreateActs(val: boolean): void;
    abstract cancelWasRaised(): boolean;
    abstract setCancelWasRaised(val: boolean): void;
    abstract pathContains(task: TaskBase): boolean;
    abstract RecomputeFillData(parser: XmlParser): void;
    abstract get ParentTask(): TaskBase;
    abstract ShouldNonInteractiveChildBeModal(): boolean;
    abstract setTransOwnerTask(): void;
    abstract setDestinationSubform(destinationSubform: boolean): void;
    abstract setIsDestinationCall(isDestinationCall: boolean): void;
    abstract GetRealMainDisplayIndexOnDepth(mainDspIdx: number): number;
    abstract getTaskDepth(byParentOrder: boolean): number;
    abstract setEvalOldValues(bFlag: boolean): boolean;
    abstract GetControlIDFromVarItem(item: number): number;
    abstract GetControlFromControlID(controlID: number, parent: RefParam<number>): MgControl;
    abstract pathToRoot(path: TaskBase[], byParentOrder: boolean): void;
    abstract isFirstRecordCycle(Value_?: boolean): any;
    abstract ctl_itm_2_parent_vee(itm: number): Field;
    abstract queryTaskPath(): StringBuilder;
    abstract getFieldByName(fldName: string): Field;
    abstract getIndexOfFieldByName(fldName: string): number;
    abstract isProgram(): boolean;
    abstract getPublicName(): string;
    abstract getExternalTaskId(): string;
    abstract set Transaction(value: Transaction);
    abstract get Transaction(): Transaction;
    fillData(mgd: MGData, openingTaskDetails: OpeningTaskDetails): Promise<void>;
    buildXML(message: StringBuilder): Promise<void>;
}
export declare class UserRange {
    veeIdx: number;
    min: string;
    max: string;
    nullMax: boolean;
    nullMin: boolean;
    discardMax: boolean;
    discardMin: boolean;
}
export declare class OpeningTaskDetails {
    CallingTask: TaskBase;
    PathParentTask: TaskBase;
    constructor();
    constructor(callingTask: TaskBase, pathParentTask: TaskBase);
    private constructor_0;
    private constructor_1;
}
