import { DataviewManagerBase } from "../data/DataviewManagerBase";
import { ReturnResult } from "../util/ReturnResult";
import { Task } from "./Task";
export declare abstract class TaskServiceBase {
    abstract GetTaskTag(defaultValue: string): string;
    static CreateFirstRecord(task: Task): void;
    abstract GetDataviewManagerForVirtuals(task: Task): DataviewManagerBase;
    PrepareTask(task: Task): ReturnResult;
    static PreparePropOpenTaskWindow(task: Task): Promise<void>;
    abstract GetEventTaskId(originalTaskId: string): string;
    abstract ShouldEvaluatePropertyLocally(propId: number): boolean;
    abstract InitTaskPrefixExecutedFlag(task: Task): void;
    static Exit(task: Task, reversibleExit: boolean, subformDestination: boolean): Promise<void>;
    abstract RemoveRecomputes(parentTask: Task): void;
    GetOwnerTransactionTask(task: Task): Task;
}
