import { Dictionary, List } from '@magic-xpa/mscorelib';
import { XmlParser } from '@magic-xpa/utils';
import { IMirrorXML } from './IMirrorXML';
export declare class PrmMap<TValue extends IMirrorXML> {
    values: Dictionary<TValue>;
    protected getvalue(s: string): TValue;
    setValue(s: string, v: TValue): void;
    remove(s: string): void;
    constructor();
}
export declare class MirrorPrmMap<TValue extends IMirrorXML> extends PrmMap<TValue> {
    protected changes: List<string>;
    protected mirroredID: string;
    private type;
    constructor(type: new () => TValue);
    private new;
    setValue(s: string, v: TValue, addToChanges?: boolean): void;
    private setValue_0;
    private setValue_1;
    remove(s: string): void;
    mirrorAllToXML(): string;
    CheckIfSystemReservedParam(key: any): boolean;
    mirrorToXML(): string;
    fillData(parser: XmlParser): void;
    RestoreParams(xml: string): void;
    mirrorFromXML(foundTagName: string, xmlParser: XmlParser): boolean;
    fillDataEntry(xmlParser: XmlParser): void;
}
