import { List } from '@magic-xpa/mscorelib';
import { GuiInteractive } from './gui/low/GuiInteractive';
import { GuiMgControl } from './gui/GuiMgControl';
import { CommandType } from './GuiEnums';
import { GuiCommandQueue } from './gui/low/GuiCommandQueue';
import { GuiCommand } from './gui/low/GuiCommand';
import { GuiConstants } from "./GuiConstants";
export class Commands {
    static SetResolveCallback(resolveCallback) {
        this.resolveCallback = resolveCallback;
    }
    static ResolvePromise(result) {
        this.resolveCallback(result);
    }
    static async messageBox(title, msg, style) {
        let guiInteractive = new GuiInteractive();
        let returnValue;
        await new Promise((resolve) => {
            this.SetResolveCallback(resolve);
            guiInteractive.messageBox(title, msg, style);
        }).then((res) => { returnValue = res; });
        return returnValue;
    }
    static setTitle(topMostForm, title) {
        let guiInteractive = new GuiInteractive();
        guiInteractive.setTitle(topMostForm, title);
    }
    static setGetSuggestedValueOfChoiceControlOnTagData(ctrl, line, retSuggestedValue) {
        let guiInteractive = new GuiInteractive();
        guiInteractive.setGetSuggestedValueOfChoiceControlOnTagData(ctrl, line, retSuggestedValue);
    }
    static getValue(obj, line) {
        let guiInteractive = new GuiInteractive();
        return guiInteractive.getValue(obj, line);
    }
    static getTopIndex(tablecontrol) {
        let guiInteractive = new GuiInteractive();
        return guiInteractive.getTopIndex(tablecontrol);
    }
    static getIsRowEditing(tablecontrol, rowIndex, isLineMode) {
        let guiInteractive = new GuiInteractive();
        return guiInteractive.getIsRowEditing(tablecontrol, rowIndex, isLineMode);
    }
    static setEditText(control, line, text) {
        let guiInteractive = new GuiInteractive();
        return guiInteractive.setEditText(control, line, text);
    }
    static insertEditText(control, line, startPosition, textToInsert) {
        let guiInteractive = new GuiInteractive();
        return guiInteractive.insertEditText(control, line, startPosition, textToInsert);
    }
    static caretPosGet(control, line) {
        let guiInteractive = new GuiInteractive();
        return guiInteractive.caretPosGet(control, line);
    }
    static addRefreshPage(navigateToRootRoute, initialUrl) {
        let guiInteractive = new GuiInteractive();
        guiInteractive.RefreshPage(navigateToRootRoute, initialUrl);
    }
    static getRowsInPage(control) {
        let guiInteractive = new GuiInteractive();
        let rowsInPage = guiInteractive.getRowsInPage(control);
        return (rowsInPage === 0 ? 1 : rowsInPage);
    }
    static getMaxRowsInPaginatedTable(control) {
        let guiInteractive = new GuiInteractive();
        let maxRows = guiInteractive.getMaxRowsInPaginatedTable(control);
        return (maxRows);
    }
    static getLastRoute() {
        let guiInteractive = new GuiInteractive();
        return guiInteractive.getLastRoute();
    }
    static addBoolWithLine(commandType, obj, line, bool) {
        let guiCommand = new GuiCommand(obj, commandType);
        guiCommand.Bool1 = bool;
        guiCommand.line = line;
        GuiCommandQueue.getInstance().addCommand(guiCommand);
    }
    static addNoParameters(commandType, obj) {
        let guiCommand = new GuiCommand(obj, commandType);
        GuiCommandQueue.getInstance().addCommand(guiCommand);
    }
    static addWithNumber(commandType, obj, num) {
        let guiCommand = new GuiCommand(obj, commandType);
        guiCommand.number = num;
        GuiCommandQueue.getInstance().addCommand(guiCommand);
    }
    static addValueWithLine(commandType, obj, line, value) {
        let guiCommand = new GuiCommand(obj, commandType);
        guiCommand.value = value;
        guiCommand.line = line;
        if (commandType === CommandType.SET_VALUE) {
            if (obj instanceof GuiMgControl && obj.isChoiceControl()) {
                if (value < 0)
                    if (obj.isComboBox())
                        guiCommand.value = GuiConstants.DEFAULT_LIST_VALUE;
                    else
                        guiCommand.value = '';
            }
        }
        GuiCommandQueue.getInstance().addCommand(guiCommand);
    }
    static addOperationWithLine(commandType, obj, line, operation, value) {
        let guiCommand = new GuiCommand(obj, commandType);
        guiCommand.obj1 = value;
        guiCommand.line = line;
        guiCommand.Operation = operation;
        GuiCommandQueue.getInstance().addCommand(guiCommand);
    }
    static addOpensubform(commandType, obj, calledTaskTag, subformControlName, formName, inputControls, routerPath, routerParams, inDefaultRouterOutlet) {
        let guiCommand = new GuiCommand(obj, commandType);
        guiCommand.str = calledTaskTag;
        guiCommand.obj1 = subformControlName;
        guiCommand.userDropFormat = formName;
        guiCommand.fileName = inputControls;
        guiCommand.Bool1 = inDefaultRouterOutlet;
        guiCommand.contextID = routerPath;
        guiCommand.params = routerParams;
        GuiCommandQueue.getInstance().addCommand(guiCommand);
    }
    static addClosesubform(commandType, obj, calledTaskTag, subformControlName, formName) {
        let guiCommand = new GuiCommand(obj, commandType);
        guiCommand.str = calledTaskTag;
        guiCommand.obj1 = subformControlName;
        guiCommand.userDropFormat = formName;
        GuiCommandQueue.getInstance().addCommand(guiCommand);
    }
    static addOpenForm(obj, formName, handlerTaskTag, calledTaskTag, inputControls, isDialog) {
        let guiCommand = new GuiCommand(obj, CommandType.OPEN_FORM);
        guiCommand.TaskTag = handlerTaskTag;
        guiCommand.str = formName;
        guiCommand.stringList = new List();
        guiCommand.stringList.push(calledTaskTag);
        guiCommand.stringList.push(inputControls);
        guiCommand.Bool1 = isDialog;
        GuiCommandQueue.getInstance().addCommand(guiCommand);
    }
    static addCloseForm(obj, handlerTaskTag, calledTaskTag) {
        let guiCommand = new GuiCommand(obj, CommandType.CLOSE_FORM);
        guiCommand.TaskTag = handlerTaskTag;
        guiCommand.str = calledTaskTag;
        GuiCommandQueue.getInstance().addCommand(guiCommand);
    }
    static addCallJS(form, formName, name, args) {
        let guiInteractive = new GuiInteractive();
        return guiInteractive.ExecuteCallJS(form, formName, name, args);
    }
    static addIsLoggedIn(setBool) {
        let guiCommand = new GuiCommand(null, CommandType.SET_IS_LOGGED_IN);
        guiCommand.Bool1 = setBool;
        GuiCommandQueue.getInstance().addCommand(guiCommand);
    }
    static addShowSpinner(show) {
        let guiCommand = new GuiCommand(null, CommandType.SHOW_SPINNER);
        guiCommand.Bool1 = show;
        GuiCommandQueue.getInstance().addCommand(guiCommand);
    }
    static addGlobalCommand(commandType) {
        let guiCommand = new GuiCommand(null, commandType);
        GuiCommandQueue.getInstance().addCommand(guiCommand);
    }
    static addShowHTMLError(commandType, error) {
        let guiCommand = new GuiCommand(null, commandType);
        guiCommand.str = error;
        GuiCommandQueue.getInstance().addCommand(guiCommand);
    }
    static beginInvoke() {
        GuiCommandQueue.getInstance().beginInvoke();
    }
    static invoke() {
        GuiCommandQueue.getInstance().invoke();
    }
    constructor() {
    }
}
Commands.resolveCallback = null;
//# sourceMappingURL=data:application/json;base64,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