import { Debug, NString, StringBuilder } from "@magic-xpa/mscorelib";
import { OSEnvironment } from "@magic-xpa/utils";
export class Events {
    static OnFocus(ctrl, line, isProduceClick, onMultiMark) {
        Debug.Assert(Events.FocusEvent !== null);
        Events.FocusEvent(ctrl, line, isProduceClick, onMultiMark);
    }
    static OnFocusOnNonMagicControl(ctrl) {
        Debug.Assert(Events.FocusOnNonMagicControlEvent !== null);
        Events.FocusOnNonMagicControlEvent(ctrl);
    }
    static OnMouseDown(guiMgForm, guiMgCtrl, dotNetArgs, leftClickWasPressed, line, onMultiMark, canProduceClick) {
        Debug.Assert(Events.MouseDownEvent !== null);
        Events.MouseDownEvent(guiMgForm, guiMgCtrl, dotNetArgs, leftClickWasPressed, line, onMultiMark, canProduceClick);
    }
    static OnNonParkableLastParkedCtrl(ctrl) {
        if (Events.NonParkableLastParkedCtrlEvent !== null) {
            Events.NonParkableLastParkedCtrlEvent(ctrl);
        }
    }
    static OnTableReorder(ctrl, tabOrderList) {
        if (Events.TableReorderEvent !== null) {
            Events.TableReorderEvent(ctrl, tabOrderList);
        }
    }
    static OnMouseUp(ctrl, line) {
        if (Events.MouseUpEvent !== null) {
            Events.MouseUpEvent(ctrl, line);
        }
    }
    static OnComboDroppingDown(ctrl, line) {
        Debug.Assert(Events.ComboDroppingDownEvent !== null);
        Events.ComboDroppingDownEvent(ctrl, line);
    }
    static OnSelection(val, ctrl, line, produceClick) {
        Debug.Assert(Events.SelectionEvent !== null);
        Events.SelectionEvent(val, ctrl, line, produceClick);
    }
    static OnDblClick(ctrl, line) {
        Debug.Assert(Events.DblClickEvent !== null);
        Events.DblClickEvent(ctrl, line);
    }
    static OnKeyDown(form, guiMgCtrlOrCtrl, modifier, keyCode, startOrSuggestedValue, endOrComboIsDropDown, textOrHandled, isActChar, suggestedValue, comboIsDropDownOrHandled, handled) {
        if (arguments.length === 11)
            Events.OnKeyDown_0(form, guiMgCtrlOrCtrl, modifier, keyCode, startOrSuggestedValue, endOrComboIsDropDown, textOrHandled, isActChar, suggestedValue, comboIsDropDownOrHandled, handled);
        else if (arguments.length === 10)
            Events.OnKeyDown_1(form, guiMgCtrlOrCtrl, modifier, keyCode, startOrSuggestedValue, endOrComboIsDropDown, textOrHandled, isActChar, suggestedValue, comboIsDropDownOrHandled);
        else
            Events.OnKeyDown_2(form, guiMgCtrlOrCtrl, modifier, keyCode, startOrSuggestedValue, endOrComboIsDropDown, textOrHandled);
    }
    static OnKeyDown_0(form, guiMgCtrl, modifier, keyCode, start, end, text, isActChar, suggestedValue, comboIsDropDown, handled) {
        Debug.Assert(Events.KeyDownEvent !== null);
        Events.KeyDownEvent(form, guiMgCtrl, modifier, keyCode, start, end, text, isActChar, suggestedValue, comboIsDropDown, handled);
    }
    static OnMultiMarkHit(ctrl, row, modifier) {
        Debug.Assert(Events.MultimarkHitEvent !== null);
        Events.MultimarkHitEvent(ctrl, row, modifier);
    }
    static OnKeyDown_1(form, ctrl, modifier, keyCode, start, end, text, isActChar, suggestedValue, handled) {
        Debug.Assert(Events.KeyDownEvent !== null);
        return Events.KeyDownEvent(form, ctrl, modifier, keyCode, start, end, text, isActChar, suggestedValue, false, handled);
    }
    static OnKeyDown_2(form, ctrl, modifier, keyCode, suggestedValue, comboIsDropDown, handled) {
        Debug.Assert(Events.KeyDownEvent !== null);
        return Events.KeyDownEvent(form, ctrl, modifier, keyCode, 0, 0, null, false, suggestedValue, comboIsDropDown, handled);
    }
    static OnFormClose(form) {
        Debug.Assert(Events.CloseFormEvent !== null);
        return Events.CloseFormEvent(form);
    }
    static OnDispose(form) {
        Debug.Assert(Events.DisposeEvent !== null);
        Events.DisposeEvent(form);
    }
    static OnTimer(mgTimer) {
        Debug.Assert(Events.TimerEvent !== null);
        Events.TimerEvent(mgTimer);
    }
    static OnTableResize(ctrl, newRowsInPage) {
        if (Events.TableResizeEvent !== null) {
            Events.TableResizeEvent(ctrl, newRowsInPage);
        }
    }
    static OnGetRowsData(ctrl, desiredTopIndex, sendAll, lastFocusedVal) {
        if (Events.GetRowsDataEvent !== null) {
            Events.GetRowsDataEvent(ctrl, desiredTopIndex, sendAll, lastFocusedVal);
        }
    }
    static OnColumnClick(columnCtrl, direction, columnHeader) {
        Debug.Assert(Events.ColumnClickEvent !== null);
        Events.ColumnClickEvent(columnCtrl, direction, columnHeader);
    }
    static RefreshTables() {
        if (Events.RefreshTablesEvent !== null) {
            Events.RefreshTablesEvent();
        }
    }
    static OnCloseHelp(activeForm) {
        if (Events.HelpCloseEvent !== null) {
            Events.HelpCloseEvent(activeForm);
        }
    }
    static IsBatchRunningInMainContext() {
        let retValue = false;
        if (Events.IsBatchRunningInMainContextEvent !== null) {
            retValue = Events.IsBatchRunningInMainContextEvent();
        }
        return retValue;
    }
    static Translate(fromString) {
        Debug.Assert(Events.TranslateEvent !== null);
        return (fromString !== null && fromString.length > 0) ? Events.TranslateEvent(fromString) : fromString;
    }
    static OnPrintPreviewStart(contextID, ioPtr, copies, enablePDlg, hWnd) {
        if (Events.PrintPreviewStartEvent !== null) {
            Events.PrintPreviewStartEvent(contextID, ioPtr, copies, enablePDlg, hWnd);
        }
    }
    static OnPrintPreviewSetCursor(printPreviewData) {
        if (Events.PrintPreviewSetCursorEvent !== null) {
            Events.PrintPreviewSetCursorEvent(printPreviewData);
        }
    }
    static InvokeUDP(contextId) {
        let ret = 0;
        if (Events.InvokeUDPEvent !== null) {
            ret = Events.InvokeUDPEvent(contextId);
        }
        return ret;
    }
    static OnPrintPreviewUpdate(prnPrevData) {
        if (Events.PrintPreviewUpdateEvent !== null) {
            Events.PrintPreviewUpdateEvent(prnPrevData);
        }
    }
    static OnCreateRichWindow(contextID, ctrlPtr, prmPtr, style, dwExStyle) {
        if (Events.CreateRichWindowEvent !== null) {
            Events.CreateRichWindowEvent(contextID, ctrlPtr, prmPtr, style, dwExStyle);
        }
    }
    static OnCreateGuiWindow(exStyle, className, windowName, style, x, y, width, height, hwndParent, hMenu, hInstance, lParam) {
        let retValue = 0;
        if (Events.CreateGuiWindowEvent !== null) {
            retValue = Events.CreateGuiWindowEvent(exStyle, className, windowName, style, x, y, width, height, hwndParent, hMenu, hInstance, lParam);
        }
        return retValue;
    }
    static OnDestroyGuiWindow(hWndPtr) {
        if (Events.DestroyGuiWindowEvent !== null) {
            Events.DestroyGuiWindowEvent(hWndPtr);
        }
    }
    static OnPrintPreviewClose(printPreviewDataPtr) {
        if (Events.PrintPreviewCloseEvent !== null) {
            Events.PrintPreviewCloseEvent(printPreviewDataPtr);
        }
    }
    static OnShowPrintDialog(gpd) {
        let retValue = 0;
        if (Events.ShowPrintDialogEvent !== null) {
            retValue = Events.ShowPrintDialogEvent(gpd);
        }
        return retValue;
    }
    static DisplaySessionStatistics() {
        if (Events.DisplaySessionStatisticsEvent !== null) {
            Events.DisplaySessionStatisticsEvent();
        }
    }
    static ShouldBlockMouseEvents(ctrl) {
        return Events.ShouldBlockMouseEventsEvent !== null && Events.ShouldBlockMouseEventsEvent(ctrl);
    }
    static PeekEndOfWork() {
        return Events.PeekEndOfWorkEvent !== null && Events.PeekEndOfWorkEvent();
    }
    static GetEventTime() {
        return (Events.GetEventTimeEvent !== null) ? Events.GetEventTimeEvent() : 0;
    }
    static OnScrollTable(guiMgObject, line, rowsToScroll, isPageScroll, isTableScroll, isRaisedByMouseWheel) {
        let handled = false;
        if (Events.ScrollTableEvent !== null) {
            handled = Events.ScrollTableEvent(guiMgObject, line, rowsToScroll, isPageScroll, isTableScroll, isRaisedByMouseWheel);
        }
        return handled;
    }
    static GetDropUserFormats() {
        Debug.Assert(Events.GetDropUserFormatsEvent !== null);
        return Events.GetDropUserFormatsEvent();
    }
    static GetContextID(guiMgForm) {
        let contextID = -1;
        Debug.Assert(guiMgForm !== null);
        if (Events.GetContextIDEvent !== null) {
            contextID = Events.GetContextIDEvent(guiMgForm);
        }
        return contextID;
    }
    static SetModal(mgForm, on) {
        if (Events.SetModalEvent !== null) {
            Events.SetModalEvent(mgForm, on);
        }
    }
    static OnShowForm(guiMgForm) {
        if (Events.ShowFormEvent !== null) {
            Events.ShowFormEvent(guiMgForm);
        }
    }
    static OnFormActivate(guiMgForm) {
        if (Events.OnFormActivateEvent !== null) {
            Events.OnFormActivateEvent(guiMgForm);
        }
    }
    static OnNCActivate(guiMgForm) {
        if (Events.OnNCActivateEvent !== null) {
            Events.OnNCActivateEvent(guiMgForm);
        }
    }
    static HandleKeyUpMessage(guiMgForm, keyCode) {
        if (Events.HandleKeyUpMessageEvent !== null) {
            Events.HandleKeyUpMessageEvent(guiMgForm, keyCode);
        }
    }
    static IsLogonRTL() {
        let isRTL = false;
        if (Events.OnIsLogonRTLEvent !== null) {
            isRTL = Events.OnIsLogonRTLEvent();
        }
        return isRTL;
    }
    static IsSpecialEngLogon() {
        let isEngLogon = false;
        if (Events.OnIsSpecialEngLogonEvent !== null) {
            isEngLogon = Events.OnIsSpecialEngLogonEvent();
        }
        return isEngLogon;
    }
    static IsSpecialIgnoreButtonFormat() {
        let isIgnoreButtonFormat = false;
        if (Events.OnIsSpecialIgnoreButtonFormatEvent !== null) {
            isIgnoreButtonFormat = Events.OnIsSpecialIgnoreButtonFormatEvent();
        }
        return isIgnoreButtonFormat;
    }
    static GetMainProgram(contextID, ctlIdx) {
        Debug.Assert(Events.GetMainProgramEvent !== null);
        return Events.GetMainProgramEvent(contextID, ctlIdx);
    }
    static TranslateLogicalName(fromString) {
        Debug.Assert(Events.TranslateLogicalNameEvent !== null);
        return Events.TranslateLogicalNameEvent(fromString);
    }
    static GetMessageString(msgId) {
        Debug.Assert(Events.GetMessageStringEvent !== null);
        let fromString = Events.GetMessageStringEvent(msgId);
        let text = Events.Translate(fromString);
        if (text !== null && text.endsWith(":")) {
            let str;
            str = new StringBuilder(text);
            str.Insert(text.length, " ");
            text = str.ToString();
        }
        return text;
    }
    static OnCtrlFocus(iTask, ctrl) {
        if (Events.CtrlFocusEvent !== null) {
            Events.CtrlFocusEvent(iTask, ctrl);
        }
    }
    static GetRuntimeContext(contextID) {
        Debug.Assert(Events.GetRuntimeContextEvent !== null);
        return Events.GetRuntimeContextEvent(contextID);
    }
    static SaveLastClickedCtrlName(guiMgControl, controlName) {
        if (Events.SaveLastClickedCtrlEvent !== null) {
            Events.SaveLastClickedCtrlEvent(controlName);
        }
    }
    static SaveLastClickInfo(guiMgForm, controlName, x, y, offsetX, offsetY, lastClickCoordinatesAreInPixels) {
        if (Events.SaveLastClickInfoEvent !== null) {
            Events.SaveLastClickInfoEvent(controlName, x, y, offsetX, offsetY, lastClickCoordinatesAreInPixels);
        }
    }
    static WriteErrorToLog(msg) {
        Debug.Assert(Events.WriteErrorToLogEvent !== null);
        Events.WriteErrorToLogEvent(msg);
    }
    static WriteExceptionToLog(msgOrEx) {
        if (arguments.length === 1 && (msgOrEx === null || msgOrEx.constructor === String)) {
            Events.WriteExceptionToLog_0(msgOrEx);
            return;
        }
        Events.WriteExceptionToLog_1(msgOrEx);
    }
    static WriteExceptionToLog_0(msg) {
        Debug.Assert(Events.WriteErrorToLogEvent !== null);
        Events.WriteErrorToLogEvent(msg);
    }
    static WriteExceptionToLog_1(ex) {
        Events.WriteExceptionToLog(NString.Format("{0} : {1}{2}{3}{4}", [
            ex.GetType(), OSEnvironment.EolSeq, ex.StackTrace, OSEnvironment.EolSeq, ex.Message
        ]));
    }
    static WriteWarningToLog(msgOrEx) {
        if (arguments.length === 1 && (msgOrEx === null || msgOrEx.constructor === String)) {
            Events.WriteWarningToLog_0(msgOrEx);
            return;
        }
        Events.WriteWarningToLog_1(msgOrEx);
    }
    static WriteWarningToLog_0(msg) {
        Debug.Assert(Events.WriteWarningToLogEvent !== null);
        Events.WriteWarningToLogEvent(msg);
    }
    static WriteWarningToLog_1(ex) {
        Events.WriteWarningToLog(ex.GetType() + " : " + OSEnvironment.EolSeq + ex.StackTrace + OSEnvironment.EolSeq + ex.Message);
    }
    static ShouldLog(logLevel) {
        Debug.Assert(Events.ShouldLogEvent !== null);
        return Events.ShouldLogEvent(logLevel);
    }
    static WriteGuiToLog(msg) {
        Debug.Assert(Events.WriteGuiToLogEvent !== null);
        Events.WriteGuiToLogEvent("GUI: " + msg);
    }
    static WriteDevToLog(msg) {
        Debug.Assert(Events.WriteDevToLogEvent !== null);
        Events.WriteDevToLogEvent(msg);
    }
    static OnClear(ctrl) {
        if (Events.ClearEvent !== null) {
            Events.ClearEvent(ctrl);
        }
    }
    static OnUndo(ctrl) {
        if (Events.UndoEvent !== null) {
            Events.UndoEvent(ctrl);
        }
    }
    static AddEnterAsKeyEvent() {
        return Events.ShouldAddEnterAsKeyEvent !== null && Events.ShouldAddEnterAsKeyEvent();
    }
    static ShowSessionStatisticsForm() {
        if (Events.ShowSessionStatisticsEvent !== null) {
            Events.ShowSessionStatisticsEvent();
        }
    }
    static OnCopyData(guiMgForm, copyData) {
        if (Events.CopyDataEvent !== null) {
            Events.CopyDataEvent(guiMgForm, copyData);
        }
    }
    constructor() {
    }
}
Events.NonParkableLastParkedCtrlEvent = null;
Events.IsBatchRunningInMainContextEvent = null;
Events.TranslateEvent = null;
Events.PrintPreviewStartEvent = null;
Events.PrintPreviewSetCursorEvent = null;
Events.InvokeUDPEvent = null;
Events.PrintPreviewUpdateEvent = null;
Events.CreateRichWindowEvent = null;
Events.CreateGuiWindowEvent = null;
Events.DestroyGuiWindowEvent = null;
Events.PrintPreviewCloseEvent = null;
Events.ShowPrintDialogEvent = null;
Events.SetModalEvent = null;
Events.CtrlFocusEvent = null;
Events.GetRuntimeContextEvent = null;
Events.SaveLastClickedCtrlEvent = null;
Events.SaveLastClickInfoEvent = null;
Events.WriteErrorToLogEvent = null;
Events.WriteExceptionToLogEvent = null;
Events.WriteWarningToLogEvent = null;
Events.ShouldLogEvent = null;
Events.WriteGuiToLogEvent = null;
Events.WriteDevToLogEvent = null;
Events.ClearEvent = null;
Events.UndoEvent = null;
Events.ShouldAddEnterAsKeyEvent = null;
Events.ShowSessionStatisticsEvent = null;
Events.CopyDataEvent = null;
Events.FocusEvent = null;
Events.FocusOnNonMagicControlEvent = null;
Events.MouseDownEvent = null;
Events.TableReorderEvent = null;
Events.MouseUpEvent = null;
Events.ComboDroppingDownEvent = null;
Events.SelectionEvent = null;
Events.DblClickEvent = null;
Events.KeyDownEvent = null;
Events.MultimarkHitEvent = null;
Events.CloseFormEvent = null;
Events.DisposeEvent = null;
Events.TimerEvent = null;
Events.TableResizeEvent = null;
Events.GetRowsDataEvent = null;
Events.EnableCutCopyEvent = null;
Events.EnablePasteEvent = null;
Events.ColumnClickEvent = null;
Events.RefreshTablesEvent = null;
Events.HelpCloseEvent = null;
Events.DisplaySessionStatisticsEvent = null;
Events.ShouldBlockMouseEventsEvent = null;
Events.PeekEndOfWorkEvent = null;
Events.GetEventTimeEvent = null;
Events.ScrollTableEvent = null;
Events.GetDropUserFormatsEvent = null;
Events.GetContextIDEvent = null;
Events.ShowFormEvent = null;
Events.OnFormActivateEvent = null;
Events.OnNCActivateEvent = null;
Events.HandleKeyUpMessageEvent = null;
Events.OnIsLogonRTLEvent = null;
Events.OnIsSpecialEngLogonEvent = null;
Events.OnIsSpecialIgnoreButtonFormatEvent = null;
Events.GetMainProgramEvent = null;
Events.TranslateLogicalNameEvent = null;
Events.GetMessageStringEvent = null;
//# sourceMappingURL=data:application/json;base64,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