import { Debug } from '@magic-xpa/mscorelib';
import { InternalInterface, MgControlType } from '@magic-xpa/utils';
import { Events } from './Events';
import { Manager } from './Manager';
import { MgFormBase } from './management/gui/MgFormBase';
import { PropInterface } from './management/gui/PropInterface';
export class EventsProcessor {
    constructor() {
        this.RegisterHandlers();
        this.RegisterSubclassHandlers();
    }
    RegisterHandlers() {
        Events.KeyDownEvent = this.processKeyDown.bind(this);
        Events.MouseDownEvent = this.processMouseDown;
        Events.DblClickEvent = this.processDblClick;
        Events.CloseFormEvent = this.processFormClose;
        Events.ColumnClickEvent = this.ProcessColumnClick;
    }
    processKeyDown(guiMgForm, guiMgCtrl, modifier, keyCode, start, end, text, isActChar, suggestedValue, handled) {
        let eventHandled = handled;
        let mgControlBase = guiMgCtrl;
        let mgFormBase = guiMgForm;
        Manager.EventsManager.AddKeyboardEvent(mgFormBase, mgControlBase, modifier, keyCode, start, end, text, isActChar, suggestedValue, InternalInterface.MG_ACT_CTRL_KEYDOWN);
        return eventHandled;
    }
    processFormClose(guiMgForm) {
        let clrHandledEvent = false;
        let mgFormBase = guiMgForm;
        if (MgFormBase.ShouldPutActOnFormClose())
            Manager.EventsManager.addGuiTriggeredEventTaskAndCodeAndRaisedBy(mgFormBase.getTask(), InternalInterface.MG_ACT_HIT);
        Manager.EventsManager.addGuiTriggeredEventWithTaskAndCode(mgFormBase.getTask(), InternalInterface.MG_ACT_CLOSE);
        return clrHandledEvent;
    }
    processMouseDown(guiMgForm, guiMgCtrl, dotNetArgs, leftClickWasPressed, line, onMultiMark, canProduceClick) {
        let mgControl = guiMgCtrl;
        if (mgControl === null) {
            Debug.Assert(guiMgForm !== null);
            Manager.EventsManager.addGuiTriggeredEventWithTaskAndCodeAndOnMultiMark(guiMgForm.getTask(), InternalInterface.MG_ACT_HIT);
        }
        else {
            if (mgControl.isSubform()) {
                mgControl.OnSubformClick();
            }
            else {
                if (mgControl.RaiseControlHitOnMouseDown(leftClickWasPressed)) {
                    Manager.EventsManager.addGuiTriggeredEventWithCtrlAndCodeAndLine(mgControl, InternalInterface.MG_ACT_CTRL_HIT, line);
                }
                if (leftClickWasPressed && canProduceClick) {
                    if (mgControl.Type !== MgControlType.CTRL_TYPE_BUTTON && mgControl.Type !== MgControlType.CTRL_TYPE_CHECKBOX) {
                        Manager.EventsManager.addGuiTriggeredEventWithCtrlAndCodeAndLine(mgControl, InternalInterface.MG_ACT_WEB_CLICK, line);
                    }
                }
            }
        }
    }
    processDblClick(guiMgCtrl, line) {
        let mgControl = guiMgCtrl;
        if (!mgControl.GetComputedBooleanProperty(PropInterface.PROP_TYPE_ENABLED, true, line))
            return;
        Manager.EventsManager.addGuiTriggeredEventWithCtrlAndCodeAndLine(mgControl, InternalInterface.MG_ACT_WEB_ON_DBLICK, line);
    }
    ProcessColumnClick(guiColumnCtrl, direction, columnHeader) {
        let mgColumnControl = guiColumnCtrl;
        Manager.EventsManager.AddColumnClickEvent(mgColumnControl, direction, columnHeader);
    }
}
//# sourceMappingURL=data:application/json;base64,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