import { Commands } from "./Commands";
import { Events } from "./Events";
import { CommandType } from "./GuiEnums";
import { GuiControlPropertyAdapter } from "./management/gui/GuiControlPropertyAdapter";
export class FocusManager {
    static async SetFocus(ctrlOrItask, lineOrCtrl, line, activateForm) {
        if (ctrlOrItask instanceof GuiControlPropertyAdapter) {
            await FocusManager.SetFocus_0(ctrlOrItask, lineOrCtrl);
            return;
        }
        await FocusManager.SetFocus_1(ctrlOrItask, lineOrCtrl, line, activateForm);
    }
    static async SetFocus_0(ctrl, line) {
        await FocusManager.SetFocus(ctrl.getForm().getTask(), ctrl, line, true);
    }
    static async SetFocus_1(itask, ctrl, line, activateForm) {
        let task = itask;
        if (task.isAborting())
            return;
        Events.OnCtrlFocus(itask, ctrl);
        if (ctrl !== null) {
            if (!await ctrl.isParkable(true))
                return;
            Commands.addBoolWithLine(CommandType.SET_FOCUS, ctrl, (line >= 0) ? line : ctrl.getDisplayLine(false), activateForm);
        }
        else {
            let formObject = task.IsSubForm
                ? task.getForm().getSubFormCtrl()
                : task.getForm();
            Commands.addBoolWithLine(CommandType.SET_FOCUS, formObject, 0, activateForm);
        }
    }
}
//# sourceMappingURL=data:application/json;base64,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