import { UtilImeJpn, UtilStrByteMode } from "@magic-xpa/utils";
import { Commands } from "./Commands";
import { CommandType, HtmlProperties } from "./GuiEnums";
import { Events } from "./Events";
import { PropInterface } from "./management/gui/PropInterface";
import { GuiEnvironment } from "./GuiEnvironment";
export class Manager {
    static SetCurrentContextID(contextID) {
        Manager._currentContextID = contextID;
    }
    static GetCurrentContextID() {
        return Manager._currentContextID;
    }
    static Init() {
        return;
    }
    static Abort(form) {
        if (form.getSubFormCtrl() === null && form.Opened) {
            if (form.isDialog()) {
                this.IsOverlayOpen = false;
                let topMostFrameForm = form.getTopMostFrameForm();
                if (topMostFrameForm !== null)
                    topMostFrameForm.UpdateModalFormsCount(form, false);
            }
            Commands.addCloseForm(form, "0", form.getTask().getTaskTag());
            Commands.beginInvoke();
        }
    }
    static GetCtrlVal(ctrl) {
        return Commands.getValue(ctrl, ctrl.getDisplayLine(true));
    }
    static async SetReadOnlyControl(ctrl, isReadOnly) {
        if (ctrl.isTextControl() || ctrl.IsRepeatable || ctrl.isComboBox() || ctrl.isListBox() || ctrl.isCheckBox() || ctrl.isRadio()) {
            if (UtilStrByteMode.isLocaleDefLangDBCS()) {
                if (await ctrl.getForm().getTask().checkProp(PropInterface.PROP_TYPE_ALLOW_LOCATE_IN_QUERY, false))
                    return;
            }
            Commands.addOperationWithLine(CommandType.SET_PROPERTY, ctrl, ctrl.getDisplayLine(false), HtmlProperties.ReadOnly, isReadOnly);
            Commands.beginInvoke();
        }
    }
    static OpenForm(mgForm) {
        if (!mgForm.Opened && (mgForm.getTask().IsInteractive || mgForm.getTask().isOpenWin())) {
            if (!mgForm.isSubForm()) {
                if (mgForm.isDialog()) {
                    this.IsOverlayOpen = true;
                    let topMostFrameForm = mgForm.getTopMostFrameForm();
                    if (topMostFrameForm !== null)
                        topMostFrameForm.UpdateModalFormsCount(mgForm, true);
                }
            }
            mgForm.Opened = true;
            Commands.beginInvoke();
        }
    }
    static async DoFirstRefreshTable(mgForm) {
        if (mgForm !== null && !mgForm.ignoreFirstRefreshTable) {
            mgForm.ignoreFirstRefreshTable = true;
            await mgForm.firstTableRefresh();
        }
    }
    static CleanMessagePane(task) {
        task.WriteToMessagePane(Manager.GetCurrentRuntimeContext().DefaultStatusMsg);
    }
    static GetMessage(msg) {
        if (msg === null)
            msg = "";
        else if (msg.length > 0) {
            let idxOfCarriage = msg.indexOf("\r");
            if (idxOfCarriage !== -1)
                msg = msg.substr(0, idxOfCarriage);
            let idxOfNewLine = msg.indexOf("\n");
            if (idxOfNewLine !== -1)
                msg = msg.substr(0, idxOfNewLine);
        }
        return msg;
    }
    static GetCurrentRuntimeContext() {
        return Events.GetRuntimeContext(Manager.GetCurrentContextID());
    }
    static GetSpecialValNewPolicy() {
        return GuiEnvironment.Environment.GetSpecialValNewPolicy();
    }
}
Manager.IsOverlayOpen = false;
Manager._currentContextID = '\0';
Manager.DefaultProtocol = null;
Manager.DefaultServerName = null;
Manager.UtilImeJpn = (UtilStrByteMode.isLocaleDefLangJPN() ? new UtilImeJpn() : null);
Manager.EventsManager = null;
//# sourceMappingURL=data:application/json;base64,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