export class UIBridge {
    constructor() {
        this.getInteractiveCallback = null;
        this.executeCommandsCallback = null;
    }
    static getInstance() {
        if (!UIBridge.instance) {
            UIBridge.instance = new UIBridge();
        }
        return UIBridge.instance;
    }
    ExecuteInteractiveCommand(command) {
        if (this.getInteractiveCallback != null)
            return this.getInteractiveCallback(command);
        return "";
    }
    executeCommands(commands) {
        if (this.executeCommandsCallback != null && commands != null) {
            this.executeCommandsCallback(commands);
        }
    }
    registerInteractiveCallback(getIntractiveCallback) {
        this.getInteractiveCallback = getIntractiveCallback;
    }
    registerExecuteCommandsCallback(executeCommandsCallback) {
        this.executeCommandsCallback = executeCommandsCallback;
    }
    saveData(data) {
        console.log(data);
    }
}
//# sourceMappingURL=data:application/json;base64,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