import { CtrlButtonTypeGui, MgControlType } from "@magic-xpa/utils";
import { Debug, Int32 } from "@magic-xpa/mscorelib";
import { ControlBase } from "./ControlBase";
export class GuiMgControl extends ControlBase {
    constructor() {
        super(...arguments);
        this._type = MgControlType.CTRL_TYPE_NONE;
        this.ButtonStyle = CtrlButtonTypeGui.None;
        this.IsRepeatable = false;
        this.Layer = 0;
        this.Name = null;
        this.GuiMgForm = null;
    }
    set Type(value) {
        if (this._type === MgControlType.CTRL_TYPE_NONE) {
            this._type = value;
        }
        else {
            Debug.Assert(false);
        }
    }
    get Type() {
        return this._type;
    }
    get IsTableChild() {
        let parent = ((this.getParent() instanceof GuiMgControl) ? this.getParent() : null);
        let parentIsTable = parent !== null && parent.isTableControl();
        return parentIsTable && !this.isColumnControl();
    }
    get IsTableHeaderChild() {
        return !this.IsRepeatable && this.IsTableChild;
    }
    getName(line) {
        let result;
        if (this.IsRepeatable) {
            if (line > Int32.MinValue) {
                result = this.Name + "_" + line;
            }
            else {
                result = this.Name + "_0";
            }
        }
        else {
            result = this.Name;
        }
        return result;
    }
    get UniqueName() {
        return this.Name;
    }
    isStatic() {
        return this._type === MgControlType.CTRL_TYPE_LABEL || this._type === MgControlType.CTRL_TYPE_GROUP || this._type === MgControlType.CTRL_TYPE_TABLE ||
            this._type === MgControlType.CTRL_TYPE_COLUMN || this._type === MgControlType.CTRL_TYPE_STATUS_BAR || this._type === MgControlType.CTRL_TYPE_SB_IMAGE ||
            this._type === MgControlType.CTRL_TYPE_SB_LABEL || this._type === MgControlType.CTRL_TYPE_LINE;
    }
    isTableControl() {
        return this._type === MgControlType.CTRL_TYPE_TABLE;
    }
    isTabControl() {
        return this._type === MgControlType.CTRL_TYPE_TAB;
    }
    isTextControl() {
        return this._type === MgControlType.CTRL_TYPE_TEXT;
    }
    isImageControl() {
        return this._type === MgControlType.CTRL_TYPE_IMAGE;
    }
    isSubform() {
        return this._type === MgControlType.CTRL_TYPE_SUBFORM;
    }
    isRadio() {
        return this._type === MgControlType.CTRL_TYPE_RADIO;
    }
    isComboBox() {
        return this._type === MgControlType.CTRL_TYPE_COMBO;
    }
    isListBox() {
        return this._type === MgControlType.CTRL_TYPE_LIST;
    }
    isButton() {
        return this._type === MgControlType.CTRL_TYPE_BUTTON;
    }
    isLabel() {
        return this._type === MgControlType.CTRL_TYPE_LABEL;
    }
    isGroup() {
        return this._type === MgControlType.CTRL_TYPE_GROUP;
    }
    isSelectionCtrl() {
        return this._type === MgControlType.CTRL_TYPE_COMBO || this._type === MgControlType.CTRL_TYPE_LIST;
    }
    isCheckBox() {
        return this._type === MgControlType.CTRL_TYPE_CHECKBOX;
    }
    isColumnControl() {
        return this._type === MgControlType.CTRL_TYPE_COLUMN;
    }
    isChoiceControl() {
        let val = false;
        switch (this._type) {
            case MgControlType.CTRL_TYPE_TAB:
            case MgControlType.CTRL_TYPE_COMBO:
            case MgControlType.CTRL_TYPE_LIST:
            case MgControlType.CTRL_TYPE_RADIO:
                val = true;
                break;
        }
        return val;
    }
    IsImageButton() {
        let result = false;
        if (this.isButton()) {
            result = (this.ButtonStyle === CtrlButtonTypeGui.Image);
        }
        return result;
    }
    IsHyperTextButton() {
        let result = false;
        if (this.isButton()) {
            result = (this.ButtonStyle === CtrlButtonTypeGui.Hypertext);
        }
        return result;
    }
}
//# sourceMappingURL=data:application/json;base64,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