import { Modifiers } from "../GuiEnums";
import { StringBuilder } from "@magic-xpa/mscorelib";
import { GuiConstants } from "../GuiConstants";
export class KeyboardItem {
    constructor(cKeyCodeOrActionId_, cModifierOrKeyCode_, modifier_, states_) {
        this._keyCode = 0;
        this._modifier = Modifiers.MODIFIER_NONE;
        this._states = 0;
        this._actionId = 0;
        if (arguments.length === 2)
            this.constructor_1(cKeyCodeOrActionId_, cModifierOrKeyCode_);
        else
            this.constructor_2(cKeyCodeOrActionId_, cModifierOrKeyCode_, modifier_, states_);
    }
    constructor_1(cKeyCode, cModifier) {
        this._keyCode = cKeyCode;
        this._modifier = cModifier;
    }
    constructor_2(actionId_, keyCode_, modifier_, states_) {
        this._actionId = actionId_;
        this._keyCode = keyCode_;
        this._modifier = modifier_;
        this._states = states_;
    }
    getKeyCode() {
        return this._keyCode;
    }
    getModifier() {
        return this._modifier;
    }
    getStates() {
        return this._states;
    }
    equals(kbdItm) {
        return this === kbdItm || (kbdItm !== null && this._keyCode === kbdItm._keyCode && this._modifier === kbdItm._modifier);
    }
    getAction() {
        return this._actionId;
    }
    setAction(actionId) {
        this._actionId = actionId;
    }
    ToString() {
        let buffer = new StringBuilder();
        let counter = 0;
        switch (this._modifier) {
            case Modifiers.MODIFIER_ALT:
                buffer.Append("Alt+");
                break;
            case Modifiers.MODIFIER_CTRL:
                buffer.Append("Ctrl+");
                break;
            case Modifiers.MODIFIER_SHIFT:
                buffer.Append("Shift+");
                break;
            case Modifiers.MODIFIER_SHIFT_CTRL:
                buffer.Append("Shift+Ctrl+");
                break;
            case Modifiers.MODIFIER_ALT_CTRL:
                buffer.Append("Alt+Ctrl+");
                break;
            case Modifiers.MODIFIER_ALT_SHIFT:
                buffer.Append("Shift+Alt+");
                break;
            case Modifiers.MODIFIER_NONE:
            default:
                break;
        }
        switch (this._keyCode) {
            case GuiConstants.KEY_SPACE:
                buffer.Append("Space");
                break;
            case GuiConstants.KEY_PG_UP:
                buffer.Append("PgUp");
                break;
            case GuiConstants.KEY_PG_DOWN:
                buffer.Append("PgDn");
                break;
            case GuiConstants.KEY_END:
                buffer.Append("End");
                break;
            case GuiConstants.KEY_HOME:
                buffer.Append("Home");
                break;
            case GuiConstants.KEY_LEFT:
                buffer.Append("Left");
                break;
            case GuiConstants.KEY_UP:
                buffer.Append("Up");
                break;
            case GuiConstants.KEY_RIGHT:
                buffer.Append("Rght");
                break;
            case GuiConstants.KEY_DOWN:
                buffer.Append("Down");
                break;
            case GuiConstants.KEY_TAB:
                buffer.Append("Tab");
                break;
            case GuiConstants.KEY_INSERT:
                buffer.Append("Ins");
                break;
            case GuiConstants.KEY_DELETE:
                buffer.Append("Del");
                break;
            case GuiConstants.KEY_RETURN:
                buffer.Append("Ent");
                break;
            case GuiConstants.KEY_ESC:
                buffer.Append("Esc");
                break;
            case GuiConstants.KEY_BACKSPACE:
                buffer.Append("Back");
                break;
            default:
                if (this._keyCode >= GuiConstants.KEY_F1 && this._keyCode <= GuiConstants.KEY_F12) {
                    counter = this._keyCode - GuiConstants.KEY_F1 + 1;
                    buffer.Append("F" + counter);
                }
                else if (this._keyCode >= GuiConstants.KEY_0 && this._keyCode <= GuiConstants.KEY_9) {
                    counter = this._keyCode - GuiConstants.KEY_0;
                    buffer.Append(counter);
                }
                else if (this._keyCode >= GuiConstants.KEY_A && this._keyCode <= GuiConstants.KEY_Z) {
                    counter = this._keyCode - GuiConstants.KEY_A + ('A').charCodeAt(0);
                    buffer.Append(String.fromCharCode(counter));
                }
                else
                    buffer.Append("? (" + this._keyCode + ")");
                break;
        }
        return buffer.ToString();
    }
}
//# sourceMappingURL=data:application/json;base64,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