import { UIBridge } from "../../UIBridge";
export class GuiCommandQueue {
    constructor() {
        this._commandsQueue = null;
        this._executingGuiCommands = false;
        this.init();
    }
    static getInstance() {
        if (GuiCommandQueue._instance === null)
            GuiCommandQueue._instance = new GuiCommandQueue();
        return GuiCommandQueue._instance;
    }
    init() {
        this._commandsQueue = new Array();
    }
    addCommand(guiCommand) {
        this.put(guiCommand);
    }
    put(guiCommand) {
        this._commandsQueue.push(guiCommand);
    }
    beginInvoke() {
        this.invoke();
    }
    invoke() {
        if (!this._executingGuiCommands) {
            this._executingGuiCommands = true;
            UIBridge.getInstance().executeCommands(this._commandsQueue);
            this._commandsQueue.length = 0;
            this._executingGuiCommands = false;
        }
    }
}
GuiCommandQueue._instance = null;
//# sourceMappingURL=data:application/json;base64,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