import { MgValue } from '../MgValue';
import { GuiMgForm } from '../GuiMgForm';
import { Events } from '../../Events';
import { UIBridge } from '../../UIBridge';
import { ControlBase } from '../ControlBase';
import { GuiCommandQueue } from './GuiCommandQueue';
export var InteractiveCommandType;
(function (InteractiveCommandType) {
    InteractiveCommandType[InteractiveCommandType["GET_VALUE"] = 0] = "GET_VALUE";
    InteractiveCommandType[InteractiveCommandType["GET_TOP_INDEX"] = 1] = "GET_TOP_INDEX";
    InteractiveCommandType[InteractiveCommandType["MESSAGE_BOX"] = 2] = "MESSAGE_BOX";
    InteractiveCommandType[InteractiveCommandType["SET_TITLE"] = 3] = "SET_TITLE";
    InteractiveCommandType[InteractiveCommandType["SET_EDIT_TEXT"] = 4] = "SET_EDIT_TEXT";
    InteractiveCommandType[InteractiveCommandType["INSERT_EDIT_TEXT"] = 5] = "INSERT_EDIT_TEXT";
    InteractiveCommandType[InteractiveCommandType["GET_CARET_POS"] = 6] = "GET_CARET_POS";
    InteractiveCommandType[InteractiveCommandType["REFRESH_PAGE"] = 7] = "REFRESH_PAGE";
    InteractiveCommandType[InteractiveCommandType["GET_ROWS_IN_PAGE"] = 8] = "GET_ROWS_IN_PAGE";
    InteractiveCommandType[InteractiveCommandType["SET_GET_SUGGESTED_VALUE_FOR_CHOICE_CONTROL_ON_TAGDATA"] = 9] = "SET_GET_SUGGESTED_VALUE_FOR_CHOICE_CONTROL_ON_TAGDATA";
    InteractiveCommandType[InteractiveCommandType["GET_IS_ROW_EDITING"] = 10] = "GET_IS_ROW_EDITING";
    InteractiveCommandType[InteractiveCommandType["GET_MAX_ROWS_IN_PAGINATED_TABLE"] = 11] = "GET_MAX_ROWS_IN_PAGINATED_TABLE";
    InteractiveCommandType[InteractiveCommandType["CALL_JS"] = 12] = "CALL_JS";
    InteractiveCommandType[InteractiveCommandType["GET_LAST_ROUTE"] = 13] = "GET_LAST_ROUTE";
})(InteractiveCommandType || (InteractiveCommandType = {}));
export class GuiInteractiveBase {
    constructor() {
        this._commandType = 0;
        this.TaskTag = null;
        this.controlName = null;
        this._str = String.fromCharCode(0);
        this._intVal1 = 0;
        this._line = 0;
        this._obj1 = null;
        this._parameters = null;
        this._boolVal = false;
        this._obj2 = null;
        this._mgValue = null;
        this.resultString = String.fromCharCode(0);
    }
    setGetSuggestedValueOfChoiceControlOnTagData(ctrl, line, retSuggestedValue) {
        this._commandType = InteractiveCommandType.SET_GET_SUGGESTED_VALUE_FOR_CHOICE_CONTROL_ON_TAGDATA;
        this._obj2 = ctrl;
        this._line = line;
        this._boolVal = retSuggestedValue;
        this.Invoke();
    }
    getValue(obj, line) {
        this._commandType = InteractiveCommandType.GET_VALUE;
        this._obj2 = obj;
        this._line = line;
        this._mgValue = new MgValue();
        this.Invoke();
        return this._mgValue.obj;
    }
    getTopIndex(tablecontrol) {
        this._commandType = InteractiveCommandType.GET_TOP_INDEX;
        this._obj2 = tablecontrol;
        this.Invoke();
        return this._intVal1;
    }
    getIsRowEditing(tablecontrol, line, isLineMode) {
        this._commandType = InteractiveCommandType.GET_IS_ROW_EDITING;
        this._obj2 = tablecontrol;
        this._intVal1 = line;
        this._boolVal = isLineMode;
        this.Invoke();
        return this._boolVal;
    }
    messageBox(title, msg, style) {
        this._commandType = InteractiveCommandType.MESSAGE_BOX;
        this._mgValue = new MgValue();
        this._mgValue.title = title;
        this._mgValue.str = ((msg === null) ? '' : msg);
        this._mgValue.style = style;
        Events.RefreshTables();
        this.Invoke();
        return this._mgValue.number;
    }
    setTitle(topMostForm, title) {
        this._commandType = InteractiveCommandType.SET_TITLE;
        this._mgValue = new MgValue();
        this._obj2 = topMostForm;
        this._mgValue.title = ((title === null) ? '' : title);
        this.Invoke();
    }
    setEditText(control, line, text) {
        this._commandType = InteractiveCommandType.SET_EDIT_TEXT;
        this._obj2 = control;
        this._line = line;
        this._mgValue = new MgValue();
        this._mgValue.str = text;
        this.Invoke();
        return this._mgValue.boolVal;
    }
    insertEditText(control, line, startPosition, textToInsert) {
        this._commandType = InteractiveCommandType.INSERT_EDIT_TEXT;
        this._obj2 = control;
        this._line = line;
        this._mgValue = new MgValue();
        this._mgValue.str = textToInsert;
        this._intVal1 = startPosition;
        this.Invoke();
        return this._mgValue.boolVal;
    }
    caretPosGet(control, line) {
        this._commandType = InteractiveCommandType.GET_CARET_POS;
        this._obj2 = control;
        this._line = line;
        this._mgValue = new MgValue();
        this.Invoke();
        return this._mgValue.number;
    }
    RefreshPage(navigateToRootRoute, initialUrl) {
        this._commandType = InteractiveCommandType.REFRESH_PAGE;
        this._boolVal = navigateToRootRoute;
        this._obj1 = initialUrl;
        this.Invoke();
        return;
    }
    getRowsInPage(control) {
        this._commandType = InteractiveCommandType.GET_ROWS_IN_PAGE;
        this._obj2 = control;
        this.Invoke();
        return this._intVal1;
    }
    getMaxRowsInPaginatedTable(control) {
        this._commandType = InteractiveCommandType.GET_MAX_ROWS_IN_PAGINATED_TABLE;
        this._obj2 = control;
        this.Invoke();
        return this._intVal1;
    }
    getLastRoute() {
        this._commandType = InteractiveCommandType.GET_LAST_ROUTE;
        this.Invoke();
        return this.resultString;
    }
    ExecuteCallJS(form, formName, functionName, args) {
        this._commandType = InteractiveCommandType.CALL_JS;
        this._obj2 = form;
        this.controlName = formName;
        this._str = functionName;
        this.arguments = args;
        this.Invoke();
        return this.resultString;
    }
    Invoke() {
        GuiCommandQueue.getInstance().invoke();
        if (this._obj2 instanceof ControlBase) {
            let controlBase = this._obj2;
            this.TaskTag = controlBase.TaskTag;
            this.controlName = controlBase.UniqueName;
        }
        else if (this._obj2 instanceof GuiMgForm) {
            let guiMgForm = this._obj2;
            this.TaskTag = guiMgForm.TaskTag;
        }
        else
            this.TaskTag = '0';
        UIBridge.getInstance().ExecuteInteractiveCommand(this);
    }
    onGetRowsInPage() {
    }
}
export class GuiInteractive extends GuiInteractiveBase {
}
//# sourceMappingURL=data:application/json;base64,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