import { XmlParser } from "@magic-xpa/utils";
import { Manager } from "../Manager";
import { NString } from "@magic-xpa/mscorelib";
export class RuntimeContextBase {
    constructor() {
        this._insertMode = false;
        this._lastCoordinates = new Array(4);
        this.ContextID = '\0';
        this.Parser = null;
        this.FrameForm = null;
        this.LastClickedCtrlName = null;
        this.RemovedContextFromServer = false;
        this.RemovingContextFromServer = false;
        this.CurrentClickedCtrl = null;
        this.CurrentClickedRadio = null;
        this.DefaultStatusMsg = null;
        this.LastClickCoordinatesAreInPixels = false;
    }
    Init(contextID) {
        this.ContextID = contextID;
        this.LastClickedCtrlName = "";
        this._insertMode = true;
        Manager.SetCurrentContextID(contextID);
        this.Parser = new XmlParser();
    }
    SaveLastClickInfo(controlName, clientX, clientY, offsetX, offsetY, isInPixels) {
        this._lastCoordinates[0] = offsetX;
        this._lastCoordinates[1] = offsetY;
        this._lastCoordinates[2] = clientX;
        this._lastCoordinates[3] = clientY;
        this.LastClickCoordinatesAreInPixels = isInPixels;
        this.LastClickedCtrlName = "";
        if (!NString.IsNullOrEmpty(controlName)) {
            this.LastClickedCtrlName = controlName;
        }
    }
    ToggleInsertMode() {
        this._insertMode = !this._insertMode;
    }
}
RuntimeContextBase.noContextId = null;
RuntimeContextBase.Instance = new RuntimeContextBase();
//# sourceMappingURL=data:application/json;base64,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