import { GuiConstants } from "../../GuiConstants";
import { StorageAttribute, StrUtil } from "@magic-xpa/utils";
import { NUM_TYPE } from "./NUM_TYPE";
import { ApplicationException, NString } from "@magic-xpa/mscorelib";
import { VectorType } from "./VectorType";
export const EMPTY_DCREF = -2;
export const NOT_FOUND = GuiConstants.DEFAULT_VALUE_INT;
export class DcValues {
    get HasReferences() {
        return this._refCount > 0;
    }
    constructor(empty) {
        this._id = 0;
        this._type = StorageAttribute.NONE;
        this._refCount = 0;
        this._nullFlags = null;
        this._isNumericType = false;
        this._numVals = null;
        this._linkVals = null;
        this._dispVals = null;
        if (empty) {
            this._id = EMPTY_DCREF;
        }
        this._isNumericType = false;
    }
    GetAttr() {
        return this._type;
    }
    setType(type) {
        this._type = type;
        if (this._type === StorageAttribute.MEMO)
            this._type = StorageAttribute.ALPHA;
        if (this._type === StorageAttribute.NUMERIC || this._type === StorageAttribute.DATE ||
            this._type === StorageAttribute.TIME) {
            this._isNumericType = true;
        }
    }
    SetID(newId) {
        this._id = newId;
    }
    SetDisplayValues(displayValues) {
        if (displayValues !== null)
            this._dispVals = displayValues.slice();
        else
            this._dispVals = null;
    }
    SetLinkValues(linkValues) {
        if (linkValues !== null)
            this._linkVals = linkValues.slice();
        else
            this._linkVals = null;
        this.setNumericVals();
    }
    setNullFlags(nullFlags) {
        if (nullFlags !== null)
            this._nullFlags = nullFlags.slice();
        else
            this._nullFlags = null;
    }
    setNumericVals() {
        if (this._isNumericType && this._linkVals !== null) {
            this._numVals = new Array(this._linkVals.length);
            for (let i = 0; i < this._linkVals.length; i = i + 1) {
                this._numVals[i] = new NUM_TYPE(this._linkVals[i]);
            }
        }
        else {
            this._numVals = null;
        }
    }
    getId() {
        return this._id;
    }
    getDispVals() {
        return this._dispVals;
    }
    GetLinkVals() {
        return this._linkVals;
    }
    getIndexOf(mgVal, isVectorValue, isNull, extraVals, extraNums, splitCommaSeperatedVals) {
        let result = NOT_FOUND;
        let tmpMgVal;
        let ctrlNumVal;
        let trimmedVal;
        let vals = null;
        let nums = null;
        let offset = 0;
        let firstFitMatchIdx;
        let firstFitMatchLength = -1;
        let minLength = -1;
        let compStr = "";
        let indice = null;
        let values = null;
        if (isNull) {
            let i = 0;
            indice = [
                NOT_FOUND
            ];
            for (i = 0; this._nullFlags !== null && i < this._nullFlags.length; i++) {
                if (this._nullFlags[i]) {
                    indice[0] = i;
                    break;
                }
            }
            return indice;
        }
        if (!isVectorValue) {
            if (splitCommaSeperatedVals) {
                values = mgVal.split(',');
            }
            else {
                values = [
                    mgVal
                ];
            }
        }
        else {
            let vectorType = new VectorType(mgVal);
            values = vectorType.GetCellValues();
        }
        indice = new Array(values.length);
        for (let iCtr = 0; iCtr < values.length; iCtr = iCtr + 1) {
            result = NOT_FOUND;
            firstFitMatchIdx = NOT_FOUND;
            tmpMgVal = values[iCtr];
            if (this._isNumericType || extraNums !== null) {
                ctrlNumVal = new NUM_TYPE(tmpMgVal);
                trimmedVal = tmpMgVal;
            }
            else {
                ctrlNumVal = null;
                trimmedVal = StrUtil.rtrim(tmpMgVal);
            }
            for (let i = 0; i < 2 && result === NOT_FOUND; i++) {
                switch (i) {
                    case 0:
                        vals = extraVals;
                        nums = extraNums;
                        offset = 0;
                        break;
                    case 1:
                    default:
                        if (this._isNumericType || nums != null)
                            offset = (nums == null ? 0 : nums.length);
                        else
                            offset = (vals == null ? 0 : vals.length);
                        vals = this._linkVals;
                        nums = this._numVals;
                        break;
                }
                if (vals != null) {
                    for (let j = 0; j < vals.length && result === NOT_FOUND; j++) {
                        if (this._isNumericType || nums != null) {
                            if (NUM_TYPE.num_cmp(ctrlNumVal, nums[j]) === 0 || tmpMgVal === vals[j] ||
                                tmpMgVal === vals[j]) {
                                result = j + offset;
                                break;
                            }
                        }
                        else {
                            if (vals[j] === tmpMgVal || trimmedVal.length > 0 && StrUtil.rtrim(vals[j]) === trimmedVal) {
                                result = j + offset;
                                break;
                            }
                            if (trimmedVal.length === 0 && StrUtil.rtrim(vals[j]).length === 0) {
                                result = j + offset;
                                break;
                            }
                            if (result === NOT_FOUND && trimmedVal.length > 0) {
                                minLength = Math.min(trimmedVal.length, vals[j].length);
                                compStr = trimmedVal.substr(0, minLength);
                                if (compStr.length > 0 && vals[j].startsWith(compStr)) {
                                    if (minLength > firstFitMatchLength) {
                                        firstFitMatchIdx = j + offset;
                                        firstFitMatchLength = minLength;
                                    }
                                }
                            }
                        }
                    }
                }
            }
            if (result === NOT_FOUND)
                result = firstFitMatchIdx;
            indice[iCtr] = result;
        }
        return indice;
    }
    getLinkValue(idx) {
        let lnkVal = null;
        if (this._linkVals !== null) {
            lnkVal = this._linkVals[idx];
        }
        return lnkVal;
    }
    isNull(idx) {
        if (this._nullFlags == null)
            return false;
        return this._nullFlags[idx];
    }
    AddReference() {
        this._refCount++;
    }
    RemoveReference() {
        this._refCount--;
        if (this._refCount < 0) {
            throw new ApplicationException("in dcVals.decrease() references count is less than zero");
        }
    }
    ToString() {
        return NString.Format("{{DCValues 0x{0:X8}, {1} refs}}", this._id, this._refCount);
    }
}
//# sourceMappingURL=data:application/json;base64,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