import { DcValues } from './DcValues';
import { List, NNumber, NumberStyles, StringBuilder } from '@magic-xpa/mscorelib';
import { Base64, StorageAttribute } from '@magic-xpa/utils';
import { RecordUtils } from './RecordUtils';
import { GuiEnvironment } from '../../GuiEnvironment';
export class DcValuesBuilderBase {
    CreateDcValues() {
        return new DcValues(false);
    }
    SetId(dcValues, newId) {
        dcValues.SetID(newId);
    }
    SetType(dcValues, type) {
        dcValues.setType(type);
    }
    SetDisplayValues(dcValues, displayValues) {
        dcValues.SetDisplayValues(displayValues);
    }
    SetLinkValues(dcValues, linkValues) {
        dcValues.SetLinkValues(linkValues);
    }
    SetNullFlags(dcValues, nullFlagsStringOrNullFlags) {
        if (arguments.length === 2 && (dcValues === null || dcValues instanceof DcValues) && (nullFlagsStringOrNullFlags === null || nullFlagsStringOrNullFlags.constructor === String)) {
            this.SetNullFlags_0(dcValues, nullFlagsStringOrNullFlags);
            return;
        }
        this.SetNullFlags_1(dcValues, nullFlagsStringOrNullFlags);
    }
    SetNullFlags_0(dcValues, nullFlagsString) {
        let nullFlags = this.ParseNullFlags(nullFlagsString);
        dcValues.setNullFlags(nullFlags);
    }
    SetNullFlags_1(dcValues, nullFlags) {
        dcValues.setNullFlags(nullFlags);
    }
    ParseValues(valueStr, dataType, useHex) {
        let snumber;
        let tmpValue = null;
        let buffer = new List();
        let len;
        let nextIdx;
        let endIdx;
        let suffixBuf = null;
        switch (dataType) {
            case StorageAttribute.NUMERIC:
            case StorageAttribute.DATE:
            case StorageAttribute.TIME:
                if (useHex)
                    len = GuiEnvironment.Environment.GetSignificantNumSize() * 2;
                else
                    len = Math.floor((GuiEnvironment.Environment.GetSignificantNumSize() + 2) / 3) * 4;
                break;
            case StorageAttribute.BOOLEAN:
                len = 1;
                break;
            default:
                len = 0;
                break;
        }
        nextIdx = 0;
        while (nextIdx < valueStr.length) {
            if (dataType === StorageAttribute.ALPHA || dataType === StorageAttribute.UNICODE ||
                dataType === StorageAttribute.BLOB || dataType === StorageAttribute.BLOB_VECTOR) {
                snumber = valueStr.substr(nextIdx, 4);
                len = NNumber.Parse(snumber, NumberStyles.HexNumber);
                nextIdx += 4;
            }
            if (len >= 0x8000) {
                suffixBuf = new StringBuilder();
                len -= 0x8000;
                nextIdx += RecordUtils.getSpannedField(valueStr, len, nextIdx, dataType, suffixBuf, useHex);
                buffer.push(suffixBuf.ToString());
            }
            else {
                endIdx = nextIdx + len;
                if (useHex)
                    tmpValue = valueStr.substr(nextIdx, (endIdx) - (nextIdx));
                else
                    tmpValue = Base64.decodeToHex(valueStr.substr(nextIdx, (endIdx) - (nextIdx)));
                buffer.push(tmpValue);
                nextIdx = endIdx;
            }
        }
        return buffer.ToArray();
    }
    ParseNullFlags(nullFlagsString) {
        let array = new Array(nullFlagsString.length);
        for (let i = 0; i < nullFlagsString.length; i = i + 1) {
            array[i] = (nullFlagsString.charAt(i) !== '0');
        }
        return array;
    }
    constructor() {
    }
}
//# sourceMappingURL=data:application/json;base64,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