import { List } from '@magic-xpa/mscorelib';
import { XMLConstants } from '@magic-xpa/utils';
import { Manager } from '../../Manager';
import { Events } from '../../Events';
export class FieldsTable {
    constructor() {
        this._fields = null;
        this._fields = new List();
    }
    getField(idxOrFldName) {
        if ((idxOrFldName === null || idxOrFldName.constructor === Number)) {
            return this.getField_0(idxOrFldName);
        }
        return this.getField_1(idxOrFldName);
    }
    getField_0(idx) {
        let fld = null;
        if (idx >= 0 && idx < this._fields.length)
            fld = this._fields.get_Item(idx);
        return fld;
    }
    getSize() {
        return this._fields.length;
    }
    fillData(parser, dataview) {
        while (this.initInnerObjects(parser.getNextTag(), dataview)) {
        }
    }
    initInnerObjects(foundTagName, dataview) {
        if (foundTagName === null)
            return false;
        let parser = Manager.GetCurrentRuntimeContext().Parser;
        if (foundTagName === XMLConstants.MG_TAG_FLDH) {
            let field = this.initField(parser, dataview);
            this._fields.push(field);
        }
        else if (foundTagName === XMLConstants.MG_TAG_DVHEADER)
            parser.setCurrIndex(parser.getXMLdata().indexOf(XMLConstants.TAG_CLOSE, parser.getCurrIndex()) +
                1);
        else if (foundTagName === "/" + XMLConstants.MG_TAG_DVHEADER) {
            parser.setCurrIndex2EndOfTag();
            return false;
        }
        else {
            Events.WriteExceptionToLog("There is no such tag in FieldsTable. Insert else if to FieldsTable.initInnerObjects for " + foundTagName);
            return false;
        }
        return true;
    }
    getField_1(fldName) {
        return this._fields.find((field) => (field.getVarName() === fldName));
    }
}
//# sourceMappingURL=data:application/json;base64,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