import { Dictionary, List, RefParam } from "@magic-xpa/mscorelib";
import { DcValues, EMPTY_DCREF } from "./DcValues";
import { Events } from "../../Events";
import { StorageAttribute } from "@magic-xpa/utils";
import { PIC } from "../gui/PIC";
import { DisplayConvertor } from "../gui/DisplayConvertor";
import { Commands } from "../../Commands";
import { CommandType } from "../../GuiEnums";
export class GuiDataViewBase {
    constructor() {
        this._dcValsCollection = new Dictionary();
        this._emptyDataview = false;
        this._fieldsTab = null;
        this._task = null;
        this._emptyChoice = new DcValues(true);
        this._emptyChoiceForVectors = new DcValues(true);
    }
    getField(id) {
        if (this._fieldsTab != null)
            return this._fieldsTab.getField(id);
        Events.WriteExceptionToLog("in DataView.getFieldDef(int): There is no fieldsTab object");
        return null;
    }
    isEmptyDataview() {
        return this._emptyDataview;
    }
    setEmptyDataview(emptyDataview) {
        this._emptyDataview = emptyDataview;
        Commands.addBoolWithLine(CommandType.SET_EMPTY_DATAVIEW, this._task.getForm(), 0, emptyDataview);
    }
    getTask() {
        return this._task;
    }
    getDcValues(dcId) {
        if (dcId === EMPTY_DCREF)
            return this.getEmptyChoice();
        let dcValues;
        let dcv = new RefParam(dcValues);
        this._dcValsCollection.TryGetValue(dcId.toString(), dcv);
        return dcv.value;
    }
    getEmptyChoice() {
        return this._emptyChoice;
    }
    getEmptyChoiceForVectors() {
        return this._emptyChoiceForVectors;
    }
    GetFieldsTab() {
        return this._fieldsTab;
    }
    GetRouteParams() {
        let params = new List();
        for (let i = 0; i < this._fieldsTab.getSize(); i++) {
            let field = this._fieldsTab.getField(i);
            let val;
            if (field.IsExposedRouteParam && !field.isNull()) {
                switch (field.getType()) {
                    case StorageAttribute.ALPHA:
                    case StorageAttribute.UNICODE:
                        {
                            val = field.getDispValue();
                            if (field.isNull())
                                val = field.getNullDisplay();
                            params.push(val.trim());
                        }
                        break;
                    case StorageAttribute.BOOLEAN:
                        {
                            if (field.isNull())
                                params.push(false);
                            else
                                params.push(field.getDispValue().charAt(0) === '1' ? true : false);
                        }
                        break;
                    case StorageAttribute.NUMERIC: {
                        val = field.getDispValue();
                        if (field.isNull())
                            val = field.getNullDisplay();
                        let pic = new PIC(field.getPicture(), field.getType(), this.getTask().getCompIdx());
                        val = DisplayConvertor.Instance.mg2disp(val, "", pic, true, 0, false);
                        params.push(val);
                        break;
                    }
                }
            }
        }
        return (params.length > 0) ? params : null;
    }
}
//# sourceMappingURL=data:application/json;base64,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