import { FieldDef } from "./FieldDef";
import { List, NString } from "@magic-xpa/mscorelib";
import { GuiConstants } from "../../GuiConstants";
export class GuiFieldBase extends FieldDef {
    constructor(id) {
        super(id);
        this.ControlToFocus = null;
        this._controls = null;
        this._dataview = null;
    }
    getTask() {
        return this._dataview.getTask();
    }
    async updateDisplayWithValue(displayValue, isNull) {
        let ctrl = null;
        let ctrlValue = null;
        let defaultValue = GuiConstants.DEFAULT_VALUE_INT.toString();
        if (this._controls !== null) {
            let firstControlValue = null;
            let foundControlValue = false;
            let savedControlToFocus = this.ControlToFocus;
            for (let i = 0; i < this._controls.length; i = i + 1) {
                ctrl = this._controls.get_Item(i);
                if (!ctrl.getForm().inRefreshDisplay()) {
                    ctrl.resetPrevVal();
                    await ctrl.SetAndRefreshDisplayValue(displayValue, isNull);
                    if (!ctrl.isRadio())
                        if (ctrlValue === null || ctrl.Value !== null && !(ctrl.Value === defaultValue) && ctrl === savedControlToFocus)
                            ctrlValue = ctrl;
                        else {
                            if (firstControlValue === null)
                                firstControlValue = ctrl;
                            if (ctrl.Value !== null && !(ctrl.Value === defaultValue)) {
                                if (!foundControlValue) {
                                    firstControlValue = ctrl;
                                    foundControlValue = true;
                                }
                                if (ctrl === savedControlToFocus)
                                    ctrlValue = ctrl;
                                else if (ctrlValue === null)
                                    ctrlValue = firstControlValue;
                            }
                        }
                }
            }
            if (ctrlValue !== null) {
                this.ControlToFocus = ctrlValue;
                if (this._controls.length > 1) {
                    ctrlValue.resetPrevVal();
                    await ctrlValue.SetAndRefreshDisplayValue(displayValue, isNull);
                }
            }
        }
    }
    SetControl(ctrl) {
        if (this._controls === null)
            this._controls = new List();
        if (!this._controls.Contains(ctrl)) {
            this._controls.push(ctrl);
            if (this._controls.length === 1)
                this.ControlToFocus = ctrl;
        }
    }
    RemoveControl(ctrl) {
        this._controls.Remove(ctrl);
    }
    GetRadioCtrls() {
        let list = new List();
        if (this._controls !== null) {
            for (let i = 0; i < this._controls.length; i = i + 1) {
                let ctrl = this._controls[i];
                if (ctrl.isRadio())
                    list.push(ctrl);
            }
        }
        return list;
    }
    toString() {
        return NString.Format("(Field {0}-{1}) in task {2}", this._id, this._varName, this.getTask());
    }
}
//# sourceMappingURL=data:application/json;base64,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