import { Int32, NNumber, NString, NumberStyles, StringBuilder } from '@magic-xpa/mscorelib';
import { Constants, PICInterface, Randomizer, StorageAttribute, UtilStrByteMode } from '@magic-xpa/utils';
import { PIC } from '../gui/PIC';
import { Events } from '../../Events';
import { GuiEnvironment } from '../../GuiEnvironment';
export class NUM_TYPE {
    set Data(value) {
        this._data = value;
    }
    get Data() {
        return this._data;
    }
    constructor(recordHexStrOrByteValOrDecStrOrNumFrom, offsetOrPic, lengthOrCompIdx) {
        this.COMMACHAR = ',';
        this.DECIMALCHAR = '.';
        this.SIGNIFICANT_NUM_SIZE = 0;
        this._data = new Int8Array(NUM_TYPE.NUM_SIZE);
        if (arguments.length === 0) {
            this.constructor_0();
            return;
        }
        if (arguments.length === 1 && (recordHexStrOrByteValOrDecStrOrNumFrom === null || recordHexStrOrByteValOrDecStrOrNumFrom.constructor === String)) {
            this.constructor_1(recordHexStrOrByteValOrDecStrOrNumFrom);
            return;
        }
        if (arguments.length === 3 && (recordHexStrOrByteValOrDecStrOrNumFrom === null || recordHexStrOrByteValOrDecStrOrNumFrom instanceof Int8Array) && (offsetOrPic === null || offsetOrPic.constructor === Number) && (lengthOrCompIdx === null || lengthOrCompIdx.constructor === Number)) {
            this.constructor_2(recordHexStrOrByteValOrDecStrOrNumFrom, offsetOrPic, lengthOrCompIdx);
            return;
        }
        if (arguments.length === 1 && (recordHexStrOrByteValOrDecStrOrNumFrom === null || recordHexStrOrByteValOrDecStrOrNumFrom instanceof Int8Array)) {
            this.constructor_3(recordHexStrOrByteValOrDecStrOrNumFrom);
            return;
        }
        if (arguments.length === 3 && (recordHexStrOrByteValOrDecStrOrNumFrom === null || recordHexStrOrByteValOrDecStrOrNumFrom.constructor === String) && (offsetOrPic === null || offsetOrPic instanceof PIC) && (lengthOrCompIdx === null || lengthOrCompIdx.constructor === Number)) {
            this.constructor_4(recordHexStrOrByteValOrDecStrOrNumFrom, offsetOrPic, lengthOrCompIdx);
            return;
        }
        this.constructor_5(recordHexStrOrByteValOrDecStrOrNumFrom);
    }
    constructor_0() {
        this.initConst();
        this.NUM_ZERO();
    }
    constructor_1(recordHexStr) {
        let i = 0;
        let twoDigits;
        this.initConst();
        try {
            for (i = 0; i < this.SIGNIFICANT_NUM_SIZE; i = i + 1) {
                twoDigits = recordHexStr.substr(i * 2, 2);
                this._data[i] = NUM_TYPE.toSByte(NNumber.Parse(twoDigits, NumberStyles.HexNumber));
            }
        }
        catch (ex) {
            Events.WriteWarningToLog(ex);
            this.NUM_ZERO();
        }
    }
    constructor_2(byteVal, offset, length) {
        this.constructor_0();
        for (let i = 0; i < length; i = i + 1) {
            this._data[i] = byteVal[i + offset];
        }
    }
    constructor_3(byteVal) {
        this.constructor_2(byteVal, 0, byteVal.length);
    }
    constructor_4(decStr, pic, compIdx) {
        this.constructor_0();
        this.from_a(decStr, pic, compIdx);
    }
    constructor_5(numFrom) {
        this.initConst();
        this._data = new Int8Array(numFrom._data.length);
        for (let _ai = 0; _ai < this._data.length; ++_ai)
            this._data[_ai] = numFrom._data[_ai];
    }
    toDisplayValue(pic) {
        return this.to_a(pic);
    }
    initConst() {
        let env = GuiEnvironment.Environment;
        this.DECIMALCHAR = env.GetDecimal();
        this.COMMACHAR = env.GetThousands();
        this.SIGNIFICANT_NUM_SIZE = env.GetSignificantNumSize();
    }
    toXMLrecord() {
        let hexStr = new StringBuilder(this.SIGNIFICANT_NUM_SIZE * 2);
        let num;
        if (this.NUM_IS_LONG())
            num = 5;
        else
            num = this.SIGNIFICANT_NUM_SIZE;
        for (let i = 0; i < this.SIGNIFICANT_NUM_SIZE; i++) {
            if (i < num)
                hexStr.Append(('0' + (this._data[i] & 0xFF).toString(16)).slice(-2));
            else
                hexStr.Append("00");
        }
        return hexStr.ToString().toUpperCase();
    }
    from_a(Alpha, pic, compIdx) {
        let i;
        let idx;
        let dec;
        let decs;
        let digit;
        let len;
        let no_pic;
        let Pos;
        let SType;
        let SPart;
        let Signed;
        let buf;
        let mask = "";
        let c;
        let NgtvPrmt;
        let Scan = "";
        let Pbuf = "";
        let is_negative;
        let negStr;
        let negPref;
        let posPref;
        let negSuff;
        let posSuff;
        let specialValNewPolicy = GuiEnvironment.Environment.GetSpecialValNewPolicy();
        no_pic = (pic == null);
        len = 0;
        SType = false;
        SPart = false;
        if (!no_pic) {
            mask = pic.getMask();
            if (!specialValNewPolicy)
                if (Alpha.length > pic.getMaskSize())
                    Alpha = Alpha.substr(0, pic.getMaskSize());
            NgtvPrmt = pic.isNegative();
            if (NgtvPrmt) {
                negPref = pic.getNegPref_();
                posPref = pic.getPosPref_();
                negSuff = pic.getNegSuff_();
                posSuff = pic.getPosSuff_();
                if (negPref.length === posPref.length) {
                    if (negPref.length === 0 || negPref === posPref)
                        SPart = false;
                    else
                        SPart = true;
                }
                else
                    SPart = true;
                if (SPart)
                    negStr = negPref;
                else
                    negStr = negSuff;
                if (negStr.length === 0)
                    SType = true;
                else
                    SType = false;
                if (SType)
                    Scan = (SPart ? posPref : posSuff);
                else
                    Scan = (SPart ? negPref : negSuff);
                len = Scan.length;
            }
        }
        else {
            pic = new PIC("", StorageAttribute.NUMERIC, compIdx);
            NgtvPrmt = false;
        }
        dec = false;
        decs = 0;
        digit = 0;
        Signed = 0;
        for (idx = 0; idx < Alpha.length;) {
            if (no_pic || (specialValNewPolicy && idx >= pic.getMaskSize()) || mask[idx] === String.fromCharCode(PICInterface.PIC_N)) {
                c = Alpha[idx];
                if (specialValNewPolicy) {
                    if (dec && decs === pic.getDec()) {
                        break;
                    }
                }
                if (UtilStrByteMode.isDigit(c)) {
                    digit++;
                    Pbuf += c;
                    if (dec)
                        decs++;
                }
                else if (c === this.DECIMALCHAR) {
                    Pbuf += this.DECIMALCHAR;
                    dec = true;
                }
                else if (c !== this.COMMACHAR) {
                    if (NgtvPrmt && Signed === 0) {
                        Signed = 1;
                        for (i = idx, Pos = 0; i <= Alpha.length && Pos < len; i++) {
                            if (no_pic || mask[i] === String.fromCharCode(PICInterface.PIC_N)) {
                                c = Alpha[i];
                                if (c !== Scan[Pos]) {
                                    if (c === '-' && !SType)
                                        break;
                                    if (c === '+' && SType)
                                        break;
                                    Signed = -1;
                                    break;
                                }
                                Pos++;
                            }
                        }
                        if (Pos > 0 && Pos < len)
                            Signed = -1;
                    }
                    else {
                        if (idx === 0) {
                            if (pic.getNegPref_().length > 0)
                                if (Alpha.startsWith(pic.getNegPref_())) {
                                    idx += pic.getNegPref_().length;
                                    continue;
                                }
                            if (pic.getPosPref_().length > 0)
                                if (Alpha.startsWith(pic.getPosPref_())) {
                                    idx += pic.getPosPref_().length;
                                    continue;
                                }
                        }
                        else {
                            if (pic.getNegSuff_().length > 0)
                                if (Alpha.endsWith(pic.getNegSuff_())) {
                                    idx += pic.getNegSuff_().length;
                                    continue;
                                }
                            if (pic.getPosSuff_().length > 0)
                                if (Alpha.endsWith(pic.getPosSuff_())) {
                                    idx += pic.getPosSuff_().length;
                                    continue;
                                }
                        }
                    }
                }
            }
            idx++;
        }
        if (Signed === 0 && SType)
            Signed = 1;
        is_negative = (Signed === 1 && !SType) || (Signed !== 1 && SType);
        if (decs > 0 || digit > 9) {
            buf = (is_negative ? '-' : ' ') + Pbuf;
            this.num_4_a_std(buf);
        }
        else
            this.NUM_4_LONG((is_negative ? -1 : 1) * this.a_2_long(Pbuf));
    }
    num_4_a_std(str) {
        let digstr = "";
        let diglen = 0;
        let wholes = 0;
        let decs = 0;
        let isDec = false;
        let isminus = false;
        let pos;
        for (pos = 0; pos < str.length; pos++) {
            let c = str.charAt(pos);
            if (UtilStrByteMode.isDigit(c)) {
                if (diglen > 0 || c !== '0') {
                    diglen++;
                    digstr = digstr + c;
                    if (!isDec)
                        wholes++;
                }
                else if (isDec)
                    decs = decs + 1;
            }
            else if (c === this.DECIMALCHAR)
                isDec = true;
            else if (c === '-')
                isminus = true;
        }
        this.NUM_ZERO();
        if (diglen === 0)
            return;
        if (((wholes + decs) & 1) > 0) {
            this._data[1] = NUM_TYPE.toSByte(digstr.charCodeAt(0) - '0'.charCodeAt(0));
            pos = 1;
        }
        else
            pos = 0;
        let numptr = 1 + pos;
        diglen = Math.min(diglen, (this.SIGNIFICANT_NUM_SIZE - 1) * 2 - pos);
        while (pos < diglen) {
            let digit1 = NUM_TYPE.toSByte((digstr.charCodeAt(pos++) - '0'.charCodeAt(0)));
            let digit2 = NUM_TYPE.toSByte(((pos < diglen)
                ? (digstr.charCodeAt(pos++) - '0'.charCodeAt(0))
                : '\0'.charCodeAt(0)));
            this._data[numptr++] = NUM_TYPE.toSByte(NUM_TYPE.toUByte(digit1) * 10 + NUM_TYPE.toUByte(digit2));
        }
        if (wholes > 0)
            this._data[0] = NUM_TYPE.toSByte(NUM_TYPE.EXP_BIAS + ((wholes + 1) >> 1));
        else
            this._data[0] = NUM_TYPE.toSByte(NUM_TYPE.EXP_BIAS - (decs >> 1));
        if (isminus)
            this._data[0] |= NUM_TYPE.SIGN_MASK;
    }
    NUM_4_LONG(longVal) {
        let hexStr;
        this.NUM_ZERO();
        if (longVal !== 0) {
            if (longVal < 0)
                longVal = (0xFFFFFFFF + longVal + 1);
            hexStr = longVal.toString(16);
            if (longVal > 0)
                hexStr = NUM_TYPE.INT_ZERO_HEX.substr(hexStr.length) + hexStr;
            this._data[1] = NUM_TYPE.toSByte(parseInt(hexStr.substr(6, (8) - (6)), 16));
            this._data[2] = NUM_TYPE.toSByte(parseInt(hexStr.substr(4, (6) - (4)), 16));
            this._data[3] = NUM_TYPE.toSByte(parseInt(hexStr.substr(2, (4) - (2)), 16));
            this._data[4] = NUM_TYPE.toSByte(parseInt(hexStr.substr(0, (2) - (0)), 16));
        }
    }
    a_2_long(str) {
        let n = 0;
        for (let pos = 0; pos < str.length; pos++) {
            if (UtilStrByteMode.isDigit(str.charAt(pos))) {
                n = n * 10;
                n = n + str.charCodeAt(pos) - '0'.charCodeAt(0);
            }
        }
        return n;
    }
    to_a(pic) {
        return this.to_a_pic(pic);
    }
    to_a_pic(pic) {
        let buf = new Array(128);
        let remains;
        let sign_n;
        let pref_len;
        let suff_len;
        let pref_str;
        let suff_str;
        let str_pos;
        let str_len;
        let out_pos;
        let out_buf;
        let tmp_out_buf;
        let pad;
        let left;
        let pfill;
        let mask_chars;
        let len;
        let res;
        let i;
        let isOut;
        let outVal;
        len = pic.getMaskSize();
        sign_n = (pic.isNegative() && this.num_is_neg() ? false : true);
        pref_len = (sign_n ? pic.getPosPref_().length : pic.getNegPref_().length);
        suff_len = (sign_n ? pic.getPosSuff_().length : pic.getNegSuff_().length);
        left = pic.isLeft();
        pfill = pic.padFill();
        mask_chars = pic.getMaskChars();
        outVal = NString.ToCharArray(pic.getMask().substr(0, len));
        out_buf = ((left || (mask_chars > 0)) ? buf : outVal);
        if (left) {
            for (i = 0; i < out_buf.length; i++)
                out_buf[i] = '0'.toLowerCase();
        }
        isOut = ((left || (mask_chars > 0)) ? false : true);
        str_pos = pref_len;
        str_len = len - pref_len - suff_len;
        tmp_out_buf = out_buf.slice(str_pos, out_buf.length);
        if (this.NUM_IS_LONG())
            remains = this.num_l_2_str(this.NUM_LONG(), tmp_out_buf, str_len, pic);
        else
            remains = this.to_str(tmp_out_buf, str_len, pic);
        for (i = str_pos; i < out_buf.length; i++)
            out_buf[i] = tmp_out_buf[i - str_pos];
        tmp_out_buf = null;
        if (remains < mask_chars) {
            res = new Array(len);
            for (i = 0; i < len; i++)
                res[i] = (remains === NUM_TYPE.ZERO_FILL ? pic.getZeroPad() : '*');
            return NString.FromChars(res);
        }
        if (mask_chars > 0) {
            remains -= mask_chars;
            str_pos += mask_chars;
            str_len -= mask_chars;
        }
        if (pfill) {
            pad = pic.getPad();
            if (left) {
                for (i = 0; i < remains; i++)
                    out_buf[str_pos + str_len + i] = pad;
                str_pos += remains;
            }
            else {
                for (i = 0; i < remains; i++)
                    out_buf[str_pos + i] = pad;
            }
        }
        else {
            pad = ' ';
            str_pos += remains;
            str_len -= remains;
        }
        if (suff_len > 0) {
            suff_str = sign_n ? pic.getPosSuff_() : pic.getNegSuff_();
            if (suff_len === 1)
                out_buf[str_pos + str_len] = suff_str[0];
            else {
                for (i = 0; i < suff_len; i++)
                    out_buf[str_pos + str_len + i] = suff_str[i];
            }
            str_len += suff_len;
        }
        if (pref_len > 0) {
            str_pos -= pref_len;
            str_len += pref_len;
            pref_str = sign_n ? pic.getPosPref_() : pic.getNegPref_();
            if (pref_len === 1)
                out_buf[str_pos] = pref_str[0];
            else
                for (i = 0; i < pref_len; i++)
                    out_buf[str_pos + i] = pref_str[i];
        }
        if (!pfill) {
            let outBufLen = out_buf.length;
            if (left) {
                for (i = 0; i < remains && (str_pos + str_len + i < outBufLen); i++)
                    out_buf[str_pos + str_len + i] = pad;
            }
            else {
                str_pos -= remains;
                for (i = 0; i < remains && (str_pos + i < outBufLen); i++)
                    out_buf[str_pos + i] = pad;
            }
        }
        if (isOut)
            return NString.FromChars(out_buf);
        if (mask_chars === 0) {
            if (str_pos + len > out_buf.length)
                len = out_buf.length - str_pos;
            return NString.FromChars(out_buf, str_pos, len);
        }
        for (out_pos = 0; out_pos < len && str_pos < out_buf.length; out_pos++)
            if (outVal[out_pos] === String.fromCharCode(PICInterface.PIC_N))
                outVal[out_pos] = out_buf[str_pos++];
        return NString.FromChars(outVal);
    }
    num_l_2_str(num, str, len, pic) {
        let commas;
        let digits;
        let i;
        let decs;
        let j;
        if (num < 0)
            num = -num;
        commas = pic.withComa();
        decs = Math.min(pic.getDec(), len - 1);
        if (decs > 0)
            len -= (decs + 1);
        i = len;
        if (num === 0 && !pic.decInFirstPos()) {
            if (pic.zeroFill())
                return (NUM_TYPE.ZERO_FILL);
            if (len === 0)
                return (NUM_TYPE.NO_ROOM);
            if (i > str.length)
                i = str.length;
            str[--i] = '0';
        }
        if (decs > 0) {
            str[len] = this.DECIMALCHAR;
            for (j = 0; j < decs; j++)
                str[len + 1 + j] = '0';
        }
        digits = 0;
        for (; num > 0; num = Math.floor(num / 10)) {
            i--;
            if (commas) {
                if (digits === 3) {
                    if (i < 0)
                        return (NUM_TYPE.NO_ROOM);
                    digits = 0;
                    str[i--] = this.COMMACHAR;
                }
                digits++;
            }
            if (i < 0)
                return (NUM_TYPE.NO_ROOM);
            str[i] = ((num % 10).toString());
        }
        return i;
    }
    to_str(str, len, pic) {
        let tmp;
        let commas;
        let digits;
        let decpos;
        let last;
        let first;
        let j;
        let i;
        let decs;
        let num_char;
        commas = pic.withComa();
        decs = pic.getDec();
        if (decs >= len)
            decs = len - 1;
        tmp = new NUM_TYPE(this);
        tmp.round(decs);
        if (tmp.NUM_IS_LONG())
            return tmp.num_l_2_str(tmp.NUM_LONG(), str, len, pic);
        if (pic.zeroFill() && tmp._data[0] === 0)
            return (NUM_TYPE.ZERO_FILL);
        i = len - 1;
        digits = 0;
        decpos = ((tmp._data[0] & ~NUM_TYPE.SIGN_MASK) - NUM_TYPE.EXP_BIAS + 1) * 2;
        last = decpos - 1 + decs;
        first = decpos - 1;
        if (first > 2)
            first = (tmp._data[1] < 10) ? 3 : 2;
        for (j = last; j >= first; j--) {
            if (i < 0)
                return (NUM_TYPE.NO_ROOM);
            if (commas && (j < decpos)) {
                if (digits === 3) {
                    digits = 0;
                    str[i--] = this.COMMACHAR;
                }
                digits++;
            }
            if (i < 0)
                return (NUM_TYPE.NO_ROOM);
            if ((j < 2) || (j >= this.SIGNIFICANT_NUM_SIZE * 2))
                str[i--] = '0';
            else {
                if (i < 0)
                    return (NUM_TYPE.NO_ROOM);
                num_char = tmp._data[j >> 1];
                str[i--] = (((j & 1) !== 0) ? (num_char % 10) : (Math.floor(num_char / 10))).toString();
            }
            if (j === decpos) {
                if (i < 0)
                    return (NUM_TYPE.NO_ROOM);
                str[i--] = this.DECIMALCHAR;
                if (i < 0 && pic.decInFirstPos())
                    return (0);
            }
        }
        return (i + 1);
    }
    static add(num1, num2) {
        let sign1;
        let sign2;
        let l;
        let l1;
        let l2;
        let SIGNIFICANT_NUM_SIZE;
        if (num1 === null || num2 === null)
            return null;
        SIGNIFICANT_NUM_SIZE = GuiEnvironment.Environment.GetSignificantNumSize();
        let tmpres = new NUM_TYPE();
        let res = new NUM_TYPE();
        let operData = new OperData();
        if (num1.NUM_IS_LONG()) {
            if (num2.NUM_IS_LONG()) {
                l = l1 = num1.NUM_LONG();
                if (l < 0)
                    l = -l;
                if (l < 0x40000000) {
                    l = l2 = num2.NUM_LONG();
                    if (l < 0)
                        l = -l;
                    if (l < 0x40000000) {
                        l1 += l2;
                        res.NUM_4_LONG(l1);
                        return res;
                    }
                }
                num2.num_4_std_long();
            }
            num1.num_4_std_long();
        }
        else if (num2.NUM_IS_LONG())
            num2.num_4_std_long();
        sign1 = NUM_TYPE.toSByte(num1._data[0] & NUM_TYPE.SIGN_MASK);
        operData.NUM_Exp1_ = NUM_TYPE.toSByte(num1._data[0] & ~NUM_TYPE.SIGN_MASK);
        sign2 = NUM_TYPE.toSByte(num2._data[0] & NUM_TYPE.SIGN_MASK);
        operData.NUM_Exp2_ = NUM_TYPE.toSByte(num2._data[0] & ~NUM_TYPE.SIGN_MASK);
        operData.NUM_Diff_ = (operData.NUM_Exp1_ - operData.NUM_Exp2_);
        let cmpval = operData.NUM_Diff_;
        if (cmpval === 0) {
            cmpval = NUM_TYPE.toUByte(num1._data[1]) - NUM_TYPE.toUByte(num2._data[1]);
            if (cmpval === 0)
                cmpval = NUM_TYPE.memcmp(num1, 2, num2, 2, SIGNIFICANT_NUM_SIZE - 2);
        }
        if (cmpval >= 0) {
            if (sign1 === sign2)
                tmpres = NUM_TYPE.add_pos(num1, num2, operData);
            else
                tmpres = NUM_TYPE.sub_pos(num1, num2, operData);
            if (tmpres._data[0] !== 0)
                tmpres._data[0] = NUM_TYPE.toSByte(tmpres._data[0] | sign1);
        }
        else {
            let exp = operData.NUM_Exp1_;
            operData.NUM_Exp1_ = operData.NUM_Exp2_;
            operData.NUM_Exp2_ = exp;
            operData.NUM_Diff_ = -operData.NUM_Diff_;
            if (sign1 === sign2)
                tmpres = NUM_TYPE.add_pos(num2, num1, operData);
            else
                tmpres = NUM_TYPE.sub_pos(num2, num1, operData);
            if (tmpres._data[0] !== 0)
                tmpres._data[0] |= sign2;
        }
        return tmpres;
    }
    static sub(num1, num2) {
        if (num1 === null || num2 === null)
            return null;
        let tmpres = new NUM_TYPE();
        let res = new NUM_TYPE();
        let operData = new OperData();
        if (num1.NUM_IS_LONG()) {
            if (num2.NUM_IS_LONG()) {
                let l;
                let l1 = l = num1.NUM_LONG();
                if (l < 0)
                    l = -l;
                if (l < 0x40000000) {
                    let l2 = l = num2.NUM_LONG();
                    if (l < 0)
                        l = -l;
                    if (l < 0x40000000) {
                        l1 -= l2;
                        res.NUM_4_LONG(l1);
                        return res;
                    }
                }
                num2.num_4_std_long();
            }
            num1.num_4_std_long();
        }
        else if (num2.NUM_IS_LONG())
            num2.num_4_std_long();
        let sign1 = NUM_TYPE.toSByte(num1._data[0] & NUM_TYPE.SIGN_MASK);
        operData.NUM_Exp1_ = NUM_TYPE.toSByte(num1._data[0] & ~NUM_TYPE.SIGN_MASK);
        let sign2 = NUM_TYPE.toSByte(num2._data[0] & NUM_TYPE.SIGN_MASK);
        operData.NUM_Exp2_ = NUM_TYPE.toSByte(num2._data[0] & ~NUM_TYPE.SIGN_MASK);
        operData.NUM_Diff_ = (operData.NUM_Exp1_ - operData.NUM_Exp2_);
        let cmpval = operData.NUM_Diff_;
        if (cmpval === 0) {
            cmpval = NUM_TYPE.toUByte(num1._data[1]) - NUM_TYPE.toUByte(num2._data[1]);
            if (cmpval === 0)
                cmpval = NUM_TYPE.memcmp(num1, 2, num2, 2, GuiEnvironment.Environment.GetSignificantNumSize() - 2);
        }
        if (cmpval >= 0) {
            if (sign1 === sign2)
                tmpres = NUM_TYPE.sub_pos(num1, num2, operData);
            else
                tmpres = NUM_TYPE.add_pos(num1, num2, operData);
        }
        else {
            let exp = operData.NUM_Exp1_;
            operData.NUM_Exp1_ = operData.NUM_Exp2_;
            operData.NUM_Exp2_ = exp;
            operData.NUM_Diff_ = -operData.NUM_Diff_;
            if (sign1 === sign2) {
                tmpres = NUM_TYPE.sub_pos(num2, num1, operData);
                sign1 ^= (NUM_TYPE.SIGN_MASK);
            }
            else
                tmpres = NUM_TYPE.add_pos(num2, num1, operData);
        }
        if (tmpres._data[0] !== 0)
            tmpres._data[0] |= sign1;
        return tmpres;
    }
    static mul(num1, num2) {
        let fullres = new Int8Array(38);
        let pwr;
        let len1;
        let len2;
        let pos1;
        let pos2;
        let pos;
        let digit1;
        let prod;
        let carry;
        let l;
        let l1;
        let l2;
        let SIGNIFICANT_NUM_SIZE;
        if (num1 === null || num2 === null)
            return null;
        SIGNIFICANT_NUM_SIZE = GuiEnvironment.Environment.GetSignificantNumSize();
        let res = new NUM_TYPE();
        let operData = new OperData();
        let i;
        let tmpByte;
        if (num1.NUM_IS_LONG()) {
            if (num2.NUM_IS_LONG()) {
                l = l1 = num1.NUM_LONG();
                if (l < 0)
                    l = -l;
                if (l < 0xB000) {
                    l = l2 = num2.NUM_LONG();
                    if (l < 0)
                        l = -l;
                    if (l < 0xB000) {
                        l1 = l1 * l2;
                        res.NUM_4_LONG(l1);
                        return res;
                    }
                }
                num2.num_4_std_long();
            }
            num1.num_4_std_long();
        }
        else if (num2.NUM_IS_LONG())
            num2.num_4_std_long();
        operData.NUM_Exp1_ = NUM_TYPE.toSByte(num1._data[0] & ~NUM_TYPE.SIGN_MASK);
        operData.NUM_Exp2_ = NUM_TYPE.toSByte(num2._data[0] & ~NUM_TYPE.SIGN_MASK);
        if (operData.NUM_Exp1_ === 0 || operData.NUM_Exp2_ === 0) {
            res.NUM_ZERO();
            return res;
        }
        for (len1 = SIGNIFICANT_NUM_SIZE - 1; num1._data[len1] === 0; len1--) {
        }
        for (len2 = SIGNIFICANT_NUM_SIZE - 1; num2._data[len2] === 0; len2--) {
        }
        for (i = 0; i < (NUM_TYPE.NUM_SIZE - 1) * 2; i++)
            fullres[i] = 0;
        pos = 0;
        for (pos1 = len1; pos1 > 0; pos1--) {
            pos = pos1 + len2 - 1;
            digit1 = num1._data[pos1];
            carry = 0;
            for (pos2 = len2; pos2 > 0; pos2--) {
                prod = NUM_TYPE.toUByte(digit1) * NUM_TYPE.toUByte(num2._data[pos2]) + carry;
                carry = Math.floor(prod / 100);
                fullres[pos] = NUM_TYPE.toSByte(NUM_TYPE.toUByte(fullres[pos]) + prod % 100);
                tmpByte = fullres[pos];
                pos--;
                if (NUM_TYPE.toUByte(tmpByte) >= 100) {
                    fullres[pos + 1] = NUM_TYPE.toSByte(NUM_TYPE.toUByte(fullres[pos + 1]) - 100);
                    carry++;
                }
            }
            fullres[pos] = NUM_TYPE.toSByte(carry);
        }
        pwr = NUM_TYPE.toUByte(operData.NUM_Exp1_) - NUM_TYPE.EXP_BIAS + (NUM_TYPE.toUByte(operData.NUM_Exp2_) - NUM_TYPE.EXP_BIAS);
        if (fullres[0] === 0) {
            pos++;
            pwr--;
        }
        if ((num1._data[0] & NUM_TYPE.SIGN_MASK) === (num2._data[0] & NUM_TYPE.SIGN_MASK))
            res._data[0] = 0;
        else
            res._data[0] = NUM_TYPE.SIGN_MASK;
        res._data[0] |= NUM_TYPE.toSByte(pwr + NUM_TYPE.EXP_BIAS);
        for (i = 0; i < SIGNIFICANT_NUM_SIZE - 1; i++)
            res._data[1 + i] = fullres[pos + i];
        return res;
    }
    static mod(num1, num2) {
        if (num1 === null || num2 === null)
            return null;
        let res = new NUM_TYPE();
        if (num2.num_is_zero()) {
            res.NUM_ZERO();
            return res;
        }
        if (num1.NUM_IS_LONG())
            num1.num_4_std_long();
        if (num2.NUM_IS_LONG())
            num2.num_4_std_long();
        res = NUM_TYPE.div(num1, num2);
        res.num_trunc(0);
        res = NUM_TYPE.mul(res, num2);
        res = NUM_TYPE.sub(num1, res);
        return res;
    }
    static div(num1, num2) {
        let dividend = new Int8Array((NUM_TYPE.NUM_SIZE - 1) * 2);
        let divisor = new Int8Array(NUM_TYPE.NUM_SIZE);
        let pwr;
        let len1;
        let len2;
        let pos1;
        let pos2;
        let pos;
        let quot;
        let prod;
        let carry;
        let SIGNIFICANT_NUM_SIZE;
        if (num1 === null || num2 === null)
            return null;
        SIGNIFICANT_NUM_SIZE = GuiEnvironment.Environment.GetSignificantNumSize();
        let res = new NUM_TYPE();
        let operData = new OperData();
        let i;
        let tmpByte;
        if (num1.NUM_IS_LONG())
            num1.num_4_std_long();
        if (num2.NUM_IS_LONG())
            num2.num_4_std_long();
        operData.NUM_Exp1_ = NUM_TYPE.toSByte(num1._data[0] & ~NUM_TYPE.SIGN_MASK);
        operData.NUM_Exp2_ = NUM_TYPE.toSByte(num2._data[0] & ~NUM_TYPE.SIGN_MASK);
        if (operData.NUM_Exp1_ === 0 || operData.NUM_Exp2_ === 0) {
            res.NUM_ZERO();
            return res;
        }
        for (len1 = SIGNIFICANT_NUM_SIZE - 1; num1._data[len1] === 0; len1--) {
        }
        for (len2 = SIGNIFICANT_NUM_SIZE - 1; num2._data[len2] === 0; len2--) {
        }
        pos = (NUM_TYPE.memcmp(num1, 1, num2, 1, len2) < 0) ? 0 : 1;
        for (i = 0; i < (NUM_TYPE.NUM_SIZE - 1) * 2; i++)
            dividend[i] = 0;
        for (i = 0; i < len1; i++)
            dividend[pos + i] = num1._data[1 + i];
        for (i = 0; i < len2; i++)
            divisor[1 + i] = num2._data[1 + i];
        res.NUM_SET_ZERO();
        pwr = NUM_TYPE.toUByte(operData.NUM_Exp1_) - NUM_TYPE.toUByte(operData.NUM_Exp2_) + pos;
        res._data[0] = NUM_TYPE.toSByte(pwr + NUM_TYPE.EXP_BIAS);
        if ((num1._data[0] & NUM_TYPE.SIGN_MASK) !== (num2._data[0] & NUM_TYPE.SIGN_MASK))
            res._data[0] |= NUM_TYPE.SIGN_MASK;
        quot = Math.floor(100 / (NUM_TYPE.toUByte(divisor[1]) + 1));
        if (quot > 1) {
            carry = 0;
            for (pos2 = len2; pos2 > 0; pos2--) {
                prod = quot * NUM_TYPE.toUByte(divisor[pos2]) + carry;
                carry = Math.floor(prod / 100);
                divisor[pos2] = NUM_TYPE.toSByte(prod % 100);
            }
            carry = 0;
            for (pos1 = len1 + pos - 1; pos1 >= 0; pos1--) {
                prod = quot * NUM_TYPE.toUByte(dividend[pos1]) + carry;
                carry = Math.floor(prod / 100);
                dividend[pos1] = NUM_TYPE.toSByte(prod % 100);
            }
        }
        for (pos1 = 1; pos1 < SIGNIFICANT_NUM_SIZE; pos1++) {
            quot = NUM_TYPE.toUByte(dividend[pos1 - 1]) * 100 + Math.floor(NUM_TYPE.toUByte(dividend[pos1]) / NUM_TYPE.toUByte(divisor[1]));
            if (quot >= 100)
                quot = 99;
            if (quot !== 0) {
                pos = pos1 + len2 - 1;
                carry = 0;
                for (pos2 = len2; pos2 > 0; pos2--) {
                    prod = quot * NUM_TYPE.toUByte(divisor[pos2]) + carry;
                    carry = Math.floor(prod / 100);
                    dividend[pos] = NUM_TYPE.toSByte(NUM_TYPE.toUByte(dividend[pos]) - prod % 100);
                    tmpByte = dividend[pos];
                    pos--;
                    if (tmpByte < 0) {
                        dividend[pos + 1] = NUM_TYPE.toSByte(NUM_TYPE.toUByte(dividend[pos + 1]) + 100);
                        carry++;
                    }
                }
                dividend[pos] = NUM_TYPE.toSByte(NUM_TYPE.toUByte(dividend[pos]) - carry);
                while (dividend[pos] < 0) {
                    quot--;
                    pos = pos1 + len2 - 1;
                    for (pos2 = len2; pos2 > 0; pos2--) {
                        dividend[pos] = NUM_TYPE.toSByte(NUM_TYPE.toUByte(dividend[pos]) + NUM_TYPE.toUByte(divisor[pos2]));
                        tmpByte = dividend[pos];
                        pos--;
                        if (NUM_TYPE.toUByte(tmpByte) >= 100) {
                            dividend[pos + 1] = NUM_TYPE.toSByte(NUM_TYPE.toUByte(dividend[pos + 1]) - 100);
                            dividend[pos] = NUM_TYPE.toSByte(NUM_TYPE.toUByte(dividend[pos]) + 1);
                        }
                    }
                }
            }
            res._data[pos1] = NUM_TYPE.toSByte(quot);
        }
        return res;
    }
    static num_cmp(num1, num2) {
        let sign1;
        let sign2;
        let cmpval;
        let l1;
        let l2;
        let tmp;
        let SIGNIFICANT_NUM_SIZE;
        if (num1 == null || num2 == null)
            return Int32.MinValue;
        SIGNIFICANT_NUM_SIZE = GuiEnvironment.Environment.GetSignificantNumSize();
        if (num1.NUM_IS_LONG()) {
            if (num2.NUM_IS_LONG()) {
                l1 = num1.NUM_LONG();
                l2 = num2.NUM_LONG();
                if (l1 >= 0 && l2 >= 0) {
                    tmp = l1 - l2;
                    if (tmp === 0)
                        return (0);
                    if (tmp > 0)
                        return (1);
                    return (-1);
                }
                num2.num_4_std_long();
            }
            num1.num_4_std_long();
        }
        else if (num2.NUM_IS_LONG())
            num2.num_4_std_long();
        sign1 = NUM_TYPE.toSByte(num1._data[0] & NUM_TYPE.SIGN_MASK);
        sign2 = NUM_TYPE.toSByte(num2._data[0] & NUM_TYPE.SIGN_MASK);
        cmpval = (sign1 === sign2)
            ? NUM_TYPE.memcmp(num1, 0, num2, 0, SIGNIFICANT_NUM_SIZE)
            : 1;
        if (sign1 !== 0)
            cmpval = -cmpval;
        return (cmpval);
    }
    static numHexStrIsLong(numHexStr) {
        return numHexStr.substr(0, 2) === "FF";
    }
    NUM_ZERO() {
        this.setZero(true);
    }
    NUM_SET_ZERO() {
        this.setZero(false);
    }
    num_is_neg() {
        if (this.NUM_IS_LONG())
            return ((this._data[4] & 0x80) !== 0);
        return ((this._data[0] & NUM_TYPE.SIGN_MASK) !== 0);
    }
    num_is_zero() {
        if (this.NUM_IS_LONG())
            return (this.NUM_LONG() === 0);
        return (this._data[0] === 0);
    }
    num_neg() {
        let l;
        if (this.NUM_IS_LONG()) {
            l = -this.NUM_LONG();
            this.NUM_4_LONG(l);
            return;
        }
        if (this._data[0] !== 0)
            this._data[0] ^= NUM_TYPE.SIGN_MASK;
    }
    NUM_IS_LONG() {
        return this._data[0] === NUM_TYPE.NUM_LONG_TYPE;
    }
    NUM_LONG() {
        if (this._data[1] === 0 && this._data[2] === 0 && this._data[3] === 0 && this._data[4] === -128)
            return Int32.MinValue;
        let dataview = new DataView(this._data.buffer);
        return dataview.getInt32(1, true);
    }
    round(decs) {
        let addval;
        if (this.NUM_IS_LONG())
            return;
        addval = new NUM_TYPE();
        addval._data[0] = NUM_TYPE.toSByte((this._data[0] & NUM_TYPE.SIGN_MASK) | (NUM_TYPE.EXP_BIAS - (decs >> 1)));
        addval._data[1] = NUM_TYPE.toSByte((decs & 1) !== 0 ? 5 : 50);
        let temp = NUM_TYPE.add(this, addval);
        this._data = new Int8Array(temp._data.length);
        this._data = temp._data;
        this.num_trunc(decs);
    }
    dbRound(whole) {
        let addval;
        let pwr;
        let num_diff;
        let i;
        if (this.NUM_IS_LONG())
            return;
        addval = new NUM_TYPE();
        addval._data[0] = NUM_TYPE.toSByte((this._data[0] & NUM_TYPE.SIGN_MASK) | (NUM_TYPE.EXP_BIAS + ((whole + 1) >> 1)));
        addval._data[1] = NUM_TYPE.toSByte(((whole & 1) !== 0) ? 5 : 50);
        let temp = NUM_TYPE.add(this, addval);
        this._data = new Int8Array(temp._data.length);
        for (let _ai = 0; _ai < this._data.length; ++_ai)
            this._data[_ai] = temp._data[_ai];
        pwr = (this._data[0] & ~NUM_TYPE.SIGN_MASK) - NUM_TYPE.EXP_BIAS;
        if ((num_diff = pwr - ((whole + 1) >> 1)) >= 0) {
            if ((whole & 1) !== 0) {
                this._data[1 + num_diff] = NUM_TYPE.toSByte(this._data[1 + num_diff] - this._data[1 + num_diff] % 10);
                num_diff++;
            }
            for (i = 0; i < this.SIGNIFICANT_NUM_SIZE - (1 + num_diff); i++)
                this._data[1 + num_diff + i] = 0;
        }
        else
            this.NUM_SET_ZERO();
    }
    num_trunc(decs) {
        let pwr;
        let num_diff;
        let i;
        if (this.NUM_IS_LONG())
            return;
        pwr = (this._data[0] & ~NUM_TYPE.SIGN_MASK) - NUM_TYPE.EXP_BIAS;
        if ((num_diff = this.SIGNIFICANT_NUM_SIZE - 1 - pwr - ((decs + 1) >> 1)) < 0)
            return;
        if ((num_diff < this.SIGNIFICANT_NUM_SIZE - 1) && ((decs & 1) !== 0)) {
            this._data[this.SIGNIFICANT_NUM_SIZE - 1 - num_diff] =
                NUM_TYPE.toSByte(this._data[this.SIGNIFICANT_NUM_SIZE - 1 - num_diff] - this._data[this.SIGNIFICANT_NUM_SIZE - 1 - num_diff] % 10);
            if (this._data[this.SIGNIFICANT_NUM_SIZE - 1 - num_diff] === 0)
                num_diff++;
        }
        if (num_diff >= this.SIGNIFICANT_NUM_SIZE - 1) {
            this.NUM_ZERO();
            return;
        }
        for (i = 0; i < num_diff; i++)
            this._data[this.SIGNIFICANT_NUM_SIZE - num_diff + i] = 0;
    }
    num_4_std_long() {
        let slong;
        slong = this.NUM_LONG();
        if (slong >= 0)
            this.num_4_ulong(slong);
        else {
            this.num_4_ulong(-slong);
            this._data[0] |= NUM_TYPE.SIGN_MASK;
        }
    }
    num_4_ulong(data) {
        let pwr;
        let pos;
        let i;
        this.NUM_SET_ZERO();
        pos = pwr = 5;
        while (data > 0) {
            this._data[pos--] = NUM_TYPE.toSByte(data % 100);
            data = Math.floor(data / 100);
        }
        if (pos < pwr) {
            if (pos > 0) {
                for (i = 0; i < pwr - pos; i++)
                    this._data[1 + i] = this._data[1 + pos + i];
                for (i = 0; i < pos; i++)
                    this._data[pwr - pos + 1 + i] = 0;
            }
            this._data[0] = NUM_TYPE.toSByte(pwr - pos + NUM_TYPE.EXP_BIAS);
        }
    }
    NUM_2_LONG() {
        if (this.NUM_IS_LONG())
            return this.NUM_LONG();
        else
            return this.num_2_long();
    }
    NUM_2_ULONG() {
        if (this.NUM_IS_LONG())
            return this.NUM_LONG();
        else
            return this.num_2_ulong();
    }
    num_2_long() {
        let slong;
        let sign;
        sign = this._data[0] & NUM_TYPE.SIGN_MASK;
        this._data[0] &= NUM_TYPE.toSByte(~NUM_TYPE.SIGN_MASK);
        if (sign !== 0) {
            if (NUM_TYPE.memcmp(this, 0, NUM_TYPE.MinLONG(), 0, this.SIGNIFICANT_NUM_SIZE) > 0)
                return 0;
        }
        else {
            if (NUM_TYPE.memcmp(this, 0, NUM_TYPE.MaxLONG(), 0, this.SIGNIFICANT_NUM_SIZE) > 0)
                return 0;
        }
        slong = this.num_2_ulong();
        if (sign !== 0) {
            slong = -slong;
            this._data[0] |= NUM_TYPE.toSByte(sign);
        }
        return (slong);
    }
    num_2_ulong() {
        let val;
        let pwr;
        let pos;
        let last;
        pwr = this._data[0] - NUM_TYPE.EXP_BIAS;
        if (pwr > 5)
            return (0);
        last = (pwr === 5);
        if (last)
            pwr = 4;
        val = 0;
        for (pos = 1; pos <= pwr; pos++)
            val = val * 100 + NUM_TYPE.toUByte(this._data[pos]);
        if (last)
            if (val <= Math.floor((0xFFFFFFFF - NUM_TYPE.toUByte(this._data[5])) / 100))
                val = val * 100 + NUM_TYPE.toUByte(this._data[5]);
            else
                val = 0;
        return (val);
    }
    static add_pos(num1, num2, operData) {
        let len1;
        let len2;
        let len;
        let pos;
        let num1ptr;
        let resptr;
        let i;
        let SIGNIFICANT_NUM_SIZE;
        if (num1 == null || num2 == null)
            return null;
        SIGNIFICANT_NUM_SIZE = GuiEnvironment.Environment.GetSignificantNumSize();
        let res = new NUM_TYPE();
        if (operData.NUM_Exp2_ === 0 || (operData.NUM_Diff_ >= SIGNIFICANT_NUM_SIZE - 1)) {
            res = new NUM_TYPE(num1);
            res._data[0] = operData.NUM_Exp1_;
            return res;
        }
        len1 = 1;
        for (i = SIGNIFICANT_NUM_SIZE - 2; i > 0; i -= 2) {
            if (num1.SHRT_IS_ZERO(i))
                continue;
            else {
                len1 = i + 1;
                break;
            }
        }
        if (num1._data[len1] === 0)
            len1--;
        len2 = 1;
        for (i = SIGNIFICANT_NUM_SIZE - 2; i > 0; i -= 2) {
            if (num2.SHRT_IS_ZERO(i))
                continue;
            else {
                len2 = i + 1;
                break;
            }
        }
        if (num2._data[len2] === 0)
            len2--;
        if ((len = Math.max(len1, len2 + operData.NUM_Diff_)) > SIGNIFICANT_NUM_SIZE - 1)
            len = SIGNIFICANT_NUM_SIZE - 1;
        res.NUM_SET_ZERO();
        num1ptr = operData.NUM_Diff_;
        resptr = operData.NUM_Diff_;
        for (pos = len - operData.NUM_Diff_; pos > 0; pos--) {
            res._data[resptr + pos] =
                NUM_TYPE.toSByte(NUM_TYPE.toUByte(res._data[resptr + pos]) + NUM_TYPE.toUByte(num1._data[num1ptr + pos]) + NUM_TYPE.toUByte(num2._data[pos]));
            if (NUM_TYPE.toUByte(res._data[resptr + pos]) >= 100) {
                res._data[resptr + pos] = NUM_TYPE.toSByte(NUM_TYPE.toUByte(res._data[resptr + pos]) - 100);
                res._data[resptr + pos - 1] = 1;
            }
        }
        for (pos = operData.NUM_Diff_; pos > 0; pos--) {
            res._data[pos] = NUM_TYPE.toSByte(NUM_TYPE.toUByte(res._data[pos]) + NUM_TYPE.toUByte(num1._data[pos]));
            if (NUM_TYPE.toUByte(res._data[pos]) >= 100) {
                res._data[pos] = NUM_TYPE.toSByte(NUM_TYPE.toUByte(res._data[pos]) - 100);
                res._data[pos - 1] = 1;
            }
        }
        if (res._data[0] !== 0) {
            for (pos = Math.min(len, SIGNIFICANT_NUM_SIZE - 2); pos >= 0; pos--)
                res._data[pos + 1] = res._data[pos];
            operData.NUM_Exp1_++;
        }
        res._data[0] = operData.NUM_Exp1_;
        return res;
    }
    static sub_pos(num1, num2, operData) {
        let len1;
        let len2;
        let len;
        let pos;
        let num1ptr;
        let resptr;
        let i;
        let SIGNIFICANT_NUM_SIZE;
        if (num1 == null || num2 == null)
            return null;
        SIGNIFICANT_NUM_SIZE = GuiEnvironment.Environment.GetSignificantNumSize();
        let res = new NUM_TYPE();
        let j;
        if (operData.NUM_Exp2_ === 0 || (operData.NUM_Diff_ >= SIGNIFICANT_NUM_SIZE - 1)) {
            res = new NUM_TYPE(num1);
            res._data[0] = operData.NUM_Exp1_;
            return res;
        }
        len1 = 1;
        for (i = SIGNIFICANT_NUM_SIZE - 2; i > 0; i -= 2) {
            if (num1.SHRT_IS_ZERO(i))
                continue;
            else {
                len1 = i + 1;
                break;
            }
        }
        if (num1._data[len1] === 0)
            len1--;
        len2 = 1;
        for (i = SIGNIFICANT_NUM_SIZE - 2; i > 0; i -= 2) {
            if (num2.SHRT_IS_ZERO(i))
                continue;
            else {
                len2 = i + 1;
                break;
            }
        }
        if (num2._data[len2] === 0)
            len2--;
        if ((len = Math.max(len1, len2 + operData.NUM_Diff_)) > SIGNIFICANT_NUM_SIZE - 1)
            len = SIGNIFICANT_NUM_SIZE - 1;
        res.NUM_SET_ZERO();
        num1ptr = operData.NUM_Diff_;
        resptr = operData.NUM_Diff_;
        for (pos = len - operData.NUM_Diff_; pos > 0; pos--) {
            res._data[resptr + pos] = NUM_TYPE.toSByte(NUM_TYPE.toUByte(res._data[resptr + pos]) + NUM_TYPE.toUByte(num1._data[num1ptr + pos]) - NUM_TYPE.toUByte(num2._data[pos]));
            if (res._data[resptr + pos] < 0) {
                res._data[resptr + pos] = NUM_TYPE.toSByte(NUM_TYPE.toUByte(res._data[resptr + pos]) + 100);
                res._data[resptr + pos - 1] = NUM_TYPE.toSByte(0xFF);
            }
        }
        for (pos = operData.NUM_Diff_; pos > 0; pos--) {
            res._data[pos] = NUM_TYPE.toSByte(NUM_TYPE.toUByte(res._data[pos]) + NUM_TYPE.toUByte(num1._data[pos]));
            if (res._data[pos] < 0) {
                res._data[pos] = NUM_TYPE.toSByte(NUM_TYPE.toUByte(res._data[pos]) + 100);
                res._data[pos - 1] = NUM_TYPE.toSByte(0xFF);
            }
        }
        while ((++pos <= len) && res._data[pos] === 0) {
        }
        if (pos <= len) {
            operData.NUM_Diff_ = pos - 1;
            if (operData.NUM_Diff_ > 0) {
                for (j = 0; j < len - operData.NUM_Diff_; j++)
                    res._data[1 + j] = res._data[pos + j];
                for (j = 0; j < operData.NUM_Diff_; j++)
                    res._data[len - operData.NUM_Diff_ + 1 + j] = 0;
            }
            res._data[0] = NUM_TYPE.toSByte(NUM_TYPE.toUByte(operData.NUM_Exp1_) - operData.NUM_Diff_);
        }
        return res;
    }
    num_fix(wholes) {
        let pwr;
        let num_diff;
        if (this.NUM_IS_LONG())
            this.num_4_std_long();
        pwr = (this._data[0] & ~NUM_TYPE.SIGN_MASK) - NUM_TYPE.EXP_BIAS;
        if ((num_diff = pwr - ((wholes + 1) >> 1)) < 0)
            return;
        if (num_diff < this.SIGNIFICANT_NUM_SIZE - 1) {
            if ((wholes & 1) === 1)
                this._data[1 + num_diff] = NUM_TYPE.toSByte(this._data[1 + num_diff] % 10);
            while ((num_diff < this.SIGNIFICANT_NUM_SIZE - 1) && this._data[1 + num_diff] === 0)
                num_diff++;
        }
        if (num_diff >= this.SIGNIFICANT_NUM_SIZE - 1) {
            this.NUM_ZERO();
            return;
        }
        if (num_diff > 0) {
            let i;
            for (i = 0; i < this.SIGNIFICANT_NUM_SIZE - 1 - num_diff; i++)
                this._data[1 + i] = this._data[1 + num_diff + i];
            for (i = 0; i < num_diff; i++)
                this._data[this.SIGNIFICANT_NUM_SIZE - num_diff + i] = 0;
            this._data[0] = NUM_TYPE.toSByte(this._data[0] - NUM_TYPE.toSByte(num_diff));
        }
    }
    SHRT_IS_ZERO(pos) {
        return this._data[pos] === 0 && this._data[pos + 1] === 0;
    }
    setZero(asLong) {
        let i;
        for (i = 0; i < NUM_TYPE.NUM_SIZE; i++)
            this._data[i] = 0;
        if (asLong)
            this._data[0] = NUM_TYPE.NUM_LONG_TYPE;
    }
    static memcmp(num1, pos1, num2, pos2, len) {
        let i = 0;
        while (i < len && num1._data[pos1] === num2._data[pos2] && pos1 < NUM_TYPE.NUM_SIZE && pos2 < NUM_TYPE.NUM_SIZE) {
            i++;
            pos1++;
            pos2++;
        }
        if (i === len)
            return 0;
        else if (this.toUByte(num1._data[pos1]) < this.toUByte(num2._data[pos2]))
            return -1;
        else
            return 1;
    }
    static toUByte(byteVal) {
        let val = byteVal;
        if (byteVal < 0)
            val = 256 + byteVal;
        return val;
    }
    static toSByte(unsignedVal) {
        let val = 0;
        if (unsignedVal > Constants.SByteMaxValue)
            val = (unsignedVal - 256);
        else
            val = unsignedVal;
        return val;
    }
    static MaxLONG() {
        let nUM_TYPE = new NUM_TYPE();
        nUM_TYPE._data[0] = NUM_TYPE.toSByte(NUM_TYPE.EXP_BIAS + 5);
        nUM_TYPE._data[1] = 21;
        nUM_TYPE._data[2] = 47;
        nUM_TYPE._data[3] = 48;
        nUM_TYPE._data[4] = 36;
        nUM_TYPE._data[5] = 47;
        return nUM_TYPE;
    }
    static MinLONG() {
        let num = new NUM_TYPE();
        num._data[0] = NUM_TYPE.toSByte(NUM_TYPE.EXP_BIAS + 5);
        num._data[1] = 21;
        num._data[2] = 47;
        num._data[3] = 48;
        num._data[4] = 36;
        num._data[5] = 48;
        return num;
    }
    to_double() {
        return this.storage_mg_2_float(8);
    }
    storage_mg_2_float(len) {
        let sign_pos;
        let sign;
        let compnum = new NUM_TYPE();
        let tmpnum = new NUM_TYPE();
        let divnum = new NUM_TYPE();
        let pwr;
        let bits;
        let exp;
        let long1 = 0;
        let long2 = 0;
        let fltOut = 0;
        let cout = new Int8Array([0, 0, 0, 0, 0, 0, 0, 0]);
        let Num2Pwr23_ = new Int8Array([NUM_TYPE.toSByte(NUM_TYPE.EXP_BIAS + 4), 8, 38, 86, 8]);
        let Num2Pwr52_ = new Int8Array([NUM_TYPE.toSByte(NUM_TYPE.EXP_BIAS + 8), 45, 3, 59, 96, 27, 37, 4, 96]);
        let base_Num16Pwrs = [
            new Int8Array([NUM_TYPE.toSByte(NUM_TYPE.EXP_BIAS + 1), 1]),
            new Int8Array([NUM_TYPE.toSByte(NUM_TYPE.EXP_BIAS + 1), 16]),
            new Int8Array([NUM_TYPE.toSByte(NUM_TYPE.EXP_BIAS + 2), 2, 56]),
            new Int8Array([NUM_TYPE.toSByte(NUM_TYPE.EXP_BIAS + 2), 40, 96]),
            new Int8Array([NUM_TYPE.toSByte(NUM_TYPE.EXP_BIAS + 3), 6, 55, 36]),
            new Int8Array([NUM_TYPE.toSByte(NUM_TYPE.EXP_BIAS + 4), 1, 4, 85, 76]),
            new Int8Array([NUM_TYPE.toSByte(NUM_TYPE.EXP_BIAS + 4), 16, 77, 72, 16]),
            new Int8Array([NUM_TYPE.toSByte(NUM_TYPE.EXP_BIAS + 5), 2, 68, 43, 54, 56]),
            new Int8Array([NUM_TYPE.toSByte(NUM_TYPE.EXP_BIAS + 5), 42, 94, 96, 72, 96]),
            new Int8Array([NUM_TYPE.toSByte(NUM_TYPE.EXP_BIAS + 6), 6, 87, 19, 47, 67, 36]),
            new Int8Array([NUM_TYPE.toSByte(NUM_TYPE.EXP_BIAS + 7), 1, 9, 95, 11, 62, 77, 76]),
            new Int8Array([NUM_TYPE.toSByte(NUM_TYPE.EXP_BIAS + 7), 17, 59, 21, 86, 4, 44, 16]),
            new Int8Array([NUM_TYPE.toSByte(NUM_TYPE.EXP_BIAS + 8), 2, 81, 47, 49, 76, 71, 6, 56]),
            new Int8Array([NUM_TYPE.toSByte(NUM_TYPE.EXP_BIAS + 8), 45, 3, 59, 96, 27, 37, 4, 96]),
            new Int8Array([NUM_TYPE.toSByte(NUM_TYPE.EXP_BIAS + 9), 7, 20, 57, 59, 40, 37, 92, 79, 36])
        ];
        let base_Num2Pwrs = [
            new Int8Array([NUM_TYPE.toSByte(NUM_TYPE.EXP_BIAS + 1), 1]),
            new Int8Array([NUM_TYPE.toSByte(NUM_TYPE.EXP_BIAS + 1), 2]),
            new Int8Array([NUM_TYPE.toSByte(NUM_TYPE.EXP_BIAS + 1), 4]),
            new Int8Array([NUM_TYPE.toSByte(NUM_TYPE.EXP_BIAS + 1), 8])
        ];
        if (this.NUM_IS_LONG())
            this.num_4_std_long();
        if (this._data[0] === 0)
            return 0;
        sign = NUM_TYPE.toSByte(this._data[0] & NUM_TYPE.SIGN_MASK);
        this._data[0] = NUM_TYPE.toSByte(this._data[0] & (~NUM_TYPE.SIGN_MASK));
        if (len === 4) {
            bits = 24;
            compnum = new NUM_TYPE(Num2Pwr23_);
        }
        else {
            bits = 53;
            compnum = new NUM_TYPE(Num2Pwr52_);
        }
        pwr = (this._data[0] - NUM_TYPE.EXP_BIAS) << 1;
        if (pwr < 0)
            exp = pwr * 3 + Math.floor((pwr + 1) / 3);
        else
            exp = pwr * 3 + Math.floor((pwr + 2) / 3);
        pwr = bits - exp;
        if (pwr < 0) {
            pwr = -pwr;
            tmpnum = NUM_TYPE.div(this, new NUM_TYPE(base_Num16Pwrs[pwr >> 2]));
            tmpnum = NUM_TYPE.div(tmpnum, new NUM_TYPE(base_Num2Pwrs[pwr & 3]));
        }
        else {
            tmpnum = this;
            while (pwr >= 60) {
                tmpnum = NUM_TYPE.mul(tmpnum, new NUM_TYPE(base_Num16Pwrs[14]));
                pwr -= 56;
            }
            tmpnum = NUM_TYPE.mul(tmpnum, new NUM_TYPE(base_Num16Pwrs[pwr >> 2]));
            tmpnum = NUM_TYPE.mul(tmpnum, new NUM_TYPE(base_Num2Pwrs[pwr & 3]));
        }
        while (NUM_TYPE.num_cmp(tmpnum, compnum) < 0) {
            exp--;
            tmpnum = NUM_TYPE.add(tmpnum, tmpnum);
        }
        if (len === 4) {
            long1 = tmpnum.num_2_ulong();
        }
        else {
            divnum = NUM_TYPE.div(tmpnum, new NUM_TYPE(base_Num16Pwrs[8]));
            divnum.num_trunc(0);
            long1 = divnum.num_2_ulong();
            divnum = NUM_TYPE.mul(divnum, new NUM_TYPE(base_Num16Pwrs[8]));
            divnum = NUM_TYPE.sub(tmpnum, divnum);
            long2 = divnum.num_2_ulong();
        }
        sign_pos = len - 1;
        if (len === 4) {
            exp += 126;
            cout[3] = NUM_TYPE.toSByte(exp >> 1);
            cout[2] = NUM_TYPE.toSByte((this.LO_CHAR(this.HI_SHRT(long1)) & 0x7F) | ((exp & 0x01) << 7));
            cout[1] = NUM_TYPE.toSByte(this.HI_CHAR(this.LO_SHRT(long1)));
            cout[0] = NUM_TYPE.toSByte(this.LO_CHAR(this.LO_SHRT(long1)));
        }
        else {
            exp += 1022;
            cout[7] = NUM_TYPE.toSByte(exp >> 4);
            cout[6] = NUM_TYPE.toSByte((this.LO_CHAR(this.HI_SHRT(long1)) & 0x0F) | ((exp & 0x0F) << 4));
            cout[5] = NUM_TYPE.toSByte(this.HI_CHAR(this.LO_SHRT(long1)));
            cout[4] = NUM_TYPE.toSByte(this.LO_CHAR(this.LO_SHRT(long1)));
            cout[3] = NUM_TYPE.toSByte(this.HI_CHAR(this.HI_SHRT(long2)));
            cout[2] = NUM_TYPE.toSByte(this.LO_CHAR(this.HI_SHRT(long2)));
            cout[1] = NUM_TYPE.toSByte(this.HI_CHAR(this.LO_SHRT(long2)));
            cout[0] = NUM_TYPE.toSByte(this.LO_CHAR(this.LO_SHRT(long2)));
        }
        if (sign !== 0) {
            cout[sign_pos] |= NUM_TYPE.SIGN_MASK;
            this._data[0] |= NUM_TYPE.SIGN_MASK;
        }
        fltOut = this.sbyteArr_2_Double(cout);
        return fltOut;
    }
    LO_CHAR(n) {
        return n & 255;
    }
    HI_CHAR(n) {
        return (n & 65280) >> 8;
    }
    LO_SHRT(n) {
        return (n & 65535);
    }
    HI_SHRT(n) {
        return ((n & -65536) >> 16);
    }
    static MK_SHRT(c1, c2) {
        let strInt = (c1 << 8 | c2).toString();
        return NNumber.Parse(strInt);
    }
    static MK_LONG(s1, s2) {
        let l1 = s1;
        let l2 = s2;
        let strLng = (l1 << 16 | l2).toString();
        return NNumber.Parse(strLng);
    }
    sbyteArr_2_Double(array) {
        let dataview = new DataView(array.buffer);
        return dataview.getFloat64(0, true);
    }
    static double_2_sbyteArray(d) {
        let buffer = new ArrayBuffer(8);
        let dataview = new DataView(buffer);
        dataview.setFloat64(0, d, true);
        return (new Int8Array(dataview.buffer));
    }
    static eval_op_pwr(num1, num2) {
        let d0;
        let d1;
        if (num1 == null || num2 == null)
            return null;
        if (num2.NUM_IS_LONG() && !num2.num_is_neg()) {
            d1 = num2.to_double();
            let result = NUM_TYPE.from_double(1);
            for (let i = 0; i < d1; i++)
                result = this.mul(result, num1);
            return result;
        }
        else {
            d0 = num1.to_double();
            d1 = num2.to_double();
            if (d0 < 0.0 && d1 !== d1)
                d0 = 0.0;
            else if (d0 !== 0.0)
                d0 = Math.pow(d0, d1);
        }
        return NUM_TYPE.from_double(d0);
    }
    static from_double(d0) {
        let array = NUM_TYPE.double_2_sbyteArray(d0);
        return NUM_TYPE.storage_mg_4_float(8, array);
    }
    static storage_mg_4_float(len, inp) {
        let cinp;
        let sign;
        let tmp1;
        let exp;
        let bias;
        let long1;
        let long2;
        cinp = new Array(inp.length);
        for (tmp1 = 0; tmp1 < inp.length; tmp1++)
            cinp[tmp1] = NUM_TYPE.toUByte(inp[tmp1]);
        sign = cinp[len - 1];
        if (len === 4) {
            exp = ((cinp[2] >> 7) | ((cinp[3] & 0x7F) << 1));
            bias = 150;
            long1 = 0;
            long2 = NUM_TYPE.MK_LONG(NUM_TYPE.MK_SHRT(0, cinp[2] | 0x80), NUM_TYPE.MK_SHRT(cinp[1], cinp[0]));
        }
        else {
            exp = (((cinp[7] & 0x7F) << 4) | (cinp[6] >> 4));
            bias = 1075;
            long1 = NUM_TYPE.MK_LONG(NUM_TYPE.MK_SHRT(0, (cinp[6] & 0x0F) | 0x10), NUM_TYPE.MK_SHRT(cinp[5], cinp[4]));
            long2 = NUM_TYPE.MK_LONG(NUM_TYPE.MK_SHRT(cinp[3], cinp[2]), NUM_TYPE.MK_SHRT(cinp[1], cinp[0]));
        }
        return NUM_TYPE.storage_num_4_fld_flt(long1, long2, 18, sign, bias, exp);
    }
    static storage_num_4_fld_flt(long1, long2, dec, sign, bias, expr) {
        let base_Num16Pwrs = [
            new Int8Array([NUM_TYPE.toSByte(NUM_TYPE.EXP_BIAS + 1), 1]),
            new Int8Array([NUM_TYPE.toSByte(NUM_TYPE.EXP_BIAS + 1), 16]),
            new Int8Array([NUM_TYPE.toSByte(NUM_TYPE.EXP_BIAS + 2), 2, 56]),
            new Int8Array([NUM_TYPE.toSByte(NUM_TYPE.EXP_BIAS + 2), 40, 96]),
            new Int8Array([NUM_TYPE.toSByte(NUM_TYPE.EXP_BIAS + 3), 6, 55, 36]),
            new Int8Array([NUM_TYPE.toSByte(NUM_TYPE.EXP_BIAS + 4), 1, 4, 85, 76]),
            new Int8Array([NUM_TYPE.toSByte(NUM_TYPE.EXP_BIAS + 4), 16, 77, 72, 16]),
            new Int8Array([NUM_TYPE.toSByte(NUM_TYPE.EXP_BIAS + 5), 2, 68, 43, 54, 56]),
            new Int8Array([NUM_TYPE.toSByte(NUM_TYPE.EXP_BIAS + 5), 42, 94, 96, 72, 96]),
            new Int8Array([NUM_TYPE.toSByte(NUM_TYPE.EXP_BIAS + 6), 6, 87, 19, 47, 67, 36]),
            new Int8Array([NUM_TYPE.toSByte(NUM_TYPE.EXP_BIAS + 7), 1, 9, 95, 11, 62, 77, 76]),
            new Int8Array([NUM_TYPE.toSByte(NUM_TYPE.EXP_BIAS + 7), 17, 59, 21, 86, 4, 44, 16]),
            new Int8Array([NUM_TYPE.toSByte(NUM_TYPE.EXP_BIAS + 8), 2, 81, 47, 49, 76, 71, 6, 56]),
            new Int8Array([NUM_TYPE.toSByte(NUM_TYPE.EXP_BIAS + 8), 45, 3, 59, 96, 27, 37, 4, 96]),
            new Int8Array([NUM_TYPE.toSByte(NUM_TYPE.EXP_BIAS + 9), 7, 20, 57, 59, 40, 37, 92, 79, 36])
        ];
        let base_Num2Pwrs = [
            new Int8Array([NUM_TYPE.toSByte(NUM_TYPE.EXP_BIAS + 1), 1]),
            new Int8Array([NUM_TYPE.toSByte(NUM_TYPE.EXP_BIAS + 1), 2]),
            new Int8Array([NUM_TYPE.toSByte(NUM_TYPE.EXP_BIAS + 1), 4]),
            new Int8Array([NUM_TYPE.toSByte(NUM_TYPE.EXP_BIAS + 1), 8])
        ];
        let tmpnum = new NUM_TYPE();
        let outVal = new NUM_TYPE();
        let exp = expr;
        if (exp === 0) {
            outVal.NUM_ZERO();
            return outVal;
        }
        outVal.num_4_ulong(long2);
        if (long1 !== 0) {
            tmpnum.num_4_ulong(long1);
            tmpnum = NUM_TYPE.mul(tmpnum, new NUM_TYPE(base_Num16Pwrs[8]));
            outVal = NUM_TYPE.add(tmpnum, outVal);
        }
        exp = (exp - bias);
        if (exp < 0) {
            exp = -exp;
            while (exp >= 60) {
                outVal = NUM_TYPE.div(outVal, new NUM_TYPE(base_Num16Pwrs[14]));
                exp -= 56;
            }
            tmpnum = NUM_TYPE.mul(new NUM_TYPE(base_Num16Pwrs[exp >> 2]), new NUM_TYPE(base_Num2Pwrs[exp & 3]));
            outVal = NUM_TYPE.div(outVal, tmpnum);
        }
        else {
            if (exp >= 60) {
                outVal.NUM_ZERO();
                return outVal;
            }
            tmpnum = NUM_TYPE.mul(new NUM_TYPE(base_Num16Pwrs[exp >> 2]), new NUM_TYPE(base_Num2Pwrs[exp & 3]));
            outVal = NUM_TYPE.mul(outVal, tmpnum);
        }
        if ((sign & 0x80) !== 0)
            outVal._data[0] = outVal._data[0] | NUM_TYPE.SIGN_MASK;
        outVal.round(dec);
        return outVal;
    }
    static eval_op_log(val1) {
        if (val1 == null)
            return null;
        let resVal = new NUM_TYPE();
        let d = val1.to_double();
        if (d > 0.0)
            resVal = NUM_TYPE.from_double(Math.log(d));
        else
            resVal.NUM_ZERO();
        return resVal;
    }
    static eval_op_exp(val1) {
        let resVal;
        if (val1 === null)
            return null;
        let d = val1.to_double();
        resVal = NUM_TYPE.from_double(Math.exp(d));
        return resVal;
    }
    static eval_op_abs(val1) {
        if (val1 === null)
            return null;
        let resVal = new NUM_TYPE(val1);
        resVal.num_abs();
        return resVal;
    }
    static eval_op_sin(val1) {
        if (val1 === null)
            return null;
        let resVal = new NUM_TYPE();
        let d = val1.to_double();
        resVal = NUM_TYPE.from_double(Math.sin(d));
        return resVal;
    }
    static eval_op_cos(val1) {
        if (val1 === null)
            return null;
        let resVal = new NUM_TYPE();
        let d = val1.to_double();
        resVal = NUM_TYPE.from_double(Math.cos(d));
        return resVal;
    }
    static eval_op_tan(val1) {
        if (val1 == null)
            return null;
        let resVal = new NUM_TYPE();
        let d = val1.to_double();
        resVal = NUM_TYPE.from_double(Math.tan(d));
        return resVal;
    }
    static eval_op_asin(val1) {
        if (val1 === null)
            return null;
        let resVal = new NUM_TYPE();
        let d = val1.to_double();
        if (d <= 1.0 && d >= -1.0)
            resVal = NUM_TYPE.from_double(Math.asin(d));
        else
            resVal = NUM_TYPE.from_double(0.0);
        return resVal;
    }
    static eval_op_acos(val1) {
        if (val1 === null)
            return null;
        let resVal = new NUM_TYPE();
        let d = val1.to_double();
        if (d <= 1.0 && d >= -1.0)
            resVal = NUM_TYPE.from_double(Math.acos(d));
        else
            resVal = NUM_TYPE.from_double(0.0);
        return resVal;
    }
    static eval_op_atan(val1) {
        if (val1 === null)
            return null;
        let resVal = new NUM_TYPE();
        let d = val1.to_double();
        resVal = NUM_TYPE.from_double(Math.atan(d));
        return resVal;
    }
    num_abs() {
        let l;
        if (this.NUM_IS_LONG()) {
            l = this.NUM_LONG();
            if (l < 0)
                l = -l;
            this.NUM_4_LONG(l);
            return;
        }
        this._data[0] &= NUM_TYPE.toSByte(~NUM_TYPE.SIGN_MASK);
    }
    static eval_op_rand(val1) {
        if (val1 === null)
            return null;
        let rand_initialized = Randomizer.get_initialized();
        let rand_mod;
        let rand_mul;
        let rand_seed;
        let tmp_num = new NUM_TYPE();
        if (!rand_initialized) {
            Randomizer.set_initialized();
            rand_mod = new NUM_TYPE();
            rand_mul = new NUM_TYPE();
            rand_seed = new NUM_TYPE();
            rand_mod.num_4_a_std("100000007");
            rand_mul.num_4_a_std("75000007");
            rand_seed.num_4_a_std("12345678");
            Randomizer.set_mod(rand_mod.to_double());
            Randomizer.set_mul(rand_mul.to_double());
            Randomizer.set_seed(rand_seed.to_double());
        }
        else {
            rand_mod = NUM_TYPE.from_double(Randomizer.get_mod());
            rand_mul = NUM_TYPE.from_double(Randomizer.get_mul());
            rand_seed = NUM_TYPE.from_double(Randomizer.get_seed());
        }
        if (!val1.num_is_zero()) {
            if (val1.num_is_neg())
                rand_seed.NUM_4_LONG(NUM_TYPE.hash_rand());
            else
                rand_seed = new NUM_TYPE(val1);
        }
        else {
            if (rand_seed.num_is_neg()) {
                tmp_num.NUM_4_LONG(-1);
                rand_seed = NUM_TYPE.mul(rand_seed, tmp_num);
            }
        }
        rand_seed = NUM_TYPE.mul(rand_seed, rand_mul);
        rand_seed = NUM_TYPE.mod(rand_seed, rand_mod);
        tmp_num = NUM_TYPE.div(rand_seed, rand_mod);
        Randomizer.set_mod(rand_mod.to_double());
        Randomizer.set_mul(rand_mul.to_double());
        Randomizer.set_seed(rand_seed.to_double());
        return tmp_num;
    }
    static hash_rand() {
        return ((new Date().getMilliseconds()) ^ Math.random() * 12345678);
    }
}
NUM_TYPE.INT_ZERO_HEX = "00000000";
NUM_TYPE.NO_ROOM = -1;
NUM_TYPE.ZERO_FILL = -2;
NUM_TYPE.NUM_SIZE = 20;
NUM_TYPE.NUM_LONG_TYPE = -1;
NUM_TYPE.EXP_BIAS = 64;
NUM_TYPE.SIGN_MASK = -128;
export class OperData {
    constructor() {
        this.NUM_Diff_ = 0;
        this.NUM_Exp1_ = 0;
        this.NUM_Exp2_ = 0;
    }
}
//# sourceMappingURL=data:application/json;base64,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