import { Debug, StackTrace } from "@magic-xpa/mscorelib";
import { Logger, Logger_LogLevels } from "@magic-xpa/utils";
export class ObjectReferenceBase {
    constructor(referent) {
        this.Referent = null;
        this.isDisposed = false;
        this.id = 0;
        this._instantiationTrace = null;
        this.id = (ObjectReferenceBase.LastId = ObjectReferenceBase.LastId + 1);
        this.isDisposed = false;
        this.Referent = referent;
        if (Logger.Instance.LogLevel >= Logger_LogLevels.Development) {
            Logger.Instance.WriteDevToLog("Creating " + this.toString());
            this._instantiationTrace = new StackTrace();
        }
        referent.AddReference();
    }
    Dispose(isDisposing) {
        if (arguments.length === 0) {
            this.Dispose_0();
            return;
        }
        this.Dispose_1();
    }
    Dispose_0() {
        Logger.Instance.WriteDevToLog("Disposing " + this);
        this.Dispose(true);
    }
    Dispose_1() {
        if (!this.isDisposed) {
            if (!this.Referent.HasReferences) {
                if (Logger.Instance.LogLevel >= Logger_LogLevels.Development) {
                    Logger.Instance.WriteSupportToLog("Referent does not have any more references: " + this.Referent, false);
                    Logger.Instance.WriteStackTrace(this._instantiationTrace, 15, "Instantiation trace:");
                }
                Debug.Assert(false, "Referent does not have any more references. See DEV level log.");
            }
            else
                this.Referent.RemoveReference();
        }
        this.isDisposed = true;
    }
    toString() {
        return "{Reference " + this.id + " to: " + this.Referent + "}";
    }
}
ObjectReferenceBase.LastId = 0;
//# sourceMappingURL=data:application/json;base64,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