import { BlobType } from './BlobType';
import { NNumber, NString, StringBuilder } from '@magic-xpa/mscorelib';
import { StorageAttribute, StrUtil, UtilStrByteMode } from '@magic-xpa/utils';
export class VectorTypeBase {
    static validateBlobContents(blob) {
        let valid = false;
        if (!NString.IsNullOrEmpty(blob)) {
            let start = BlobType.blobPrefixLength(blob);
            valid = (NString.Compare(blob, (VectorTypeBase.BLOB_TABLE_STR + VectorTypeBase.VECTOR_STR), true, start, 0, (VectorTypeBase.BLOB_TABLE_STR_LEN + VectorTypeBase.VECTOR_STR_LEN)) === 0);
        }
        return valid;
    }
    static adjustAlphaStringsInFlatData(srcBlob) {
        if (VectorTypeBase.validateBlobContents(srcBlob)) {
            let destBuf = new StringBuilder();
            let pos = BlobType.blobPrefixLength(srcBlob);
            let strToken = srcBlob.substr(0, pos);
            destBuf.Append(strToken);
            let tokens = StrUtil.tokenize(srcBlob.substr(pos), ",");
            let tokenIdx = 0;
            tokenIdx++;
            strToken = tokens[tokenIdx];
            destBuf.Append(strToken + ",");
            pos = pos + (strToken.length + 1);
            tokenIdx++;
            strToken = tokens[tokenIdx];
            destBuf.Append(strToken + ",");
            pos = pos + (strToken.length + 1);
            tokenIdx++;
            strToken = tokens[tokenIdx];
            destBuf.Append(strToken + ",");
            pos = pos + (strToken.length + 1);
            tokenIdx++;
            strToken = tokens[tokenIdx];
            if (strToken.charAt(0) !== StorageAttribute.ALPHA && strToken.charAt(0) !== StorageAttribute.MEMO)
                return srcBlob;
            destBuf.Append(strToken + ",");
            pos = pos + (strToken.length + 1);
            tokenIdx++;
            strToken = tokens[tokenIdx];
            let len = NNumber.Parse(strToken);
            destBuf.Append(strToken + ",");
            pos = pos + (strToken.length + 1);
            strToken = UtilStrByteMode.leftB(srcBlob.substr(pos), len);
            destBuf.Append(strToken + ",");
            pos = pos + (strToken.length + 1);
            tokens = StrUtil.tokenize(srcBlob.substr(pos), ",");
            tokenIdx = 0;
            tokenIdx++;
            strToken = tokens[tokenIdx];
            destBuf.Append(strToken + ",");
            pos = pos + (strToken.length + 1);
            tokenIdx++;
            strToken = tokens[tokenIdx];
            destBuf.Append(strToken + ",");
            pos = pos + (strToken.length + 1);
            tokenIdx++;
            strToken = tokens[tokenIdx];
            destBuf.Append(strToken + ",");
            pos = pos + (strToken.length + 1);
            tokenIdx++;
            strToken = tokens[tokenIdx];
            let vecSize = NNumber.Parse(strToken);
            destBuf.Append(strToken + ",");
            pos = pos + (strToken.length + 1);
            tokenIdx++;
            strToken = tokens[tokenIdx++];
            destBuf.Append(strToken + ",");
            pos = pos + (strToken.length + 1);
            for (let i = 0; i < vecSize; i = i + 1) {
                strToken = UtilStrByteMode.leftB(srcBlob.substr(pos), len);
                destBuf.Append(strToken);
                pos = pos + strToken.length;
            }
            strToken = srcBlob.substr(pos);
            destBuf.Append(strToken);
            let destBlob = destBuf.ToString();
            return destBlob;
        }
        else
            return srcBlob;
    }
}
VectorTypeBase.BLOB_TABLE_STR = "mgbt";
VectorTypeBase.BLOB_TABLE_STR_LEN = 4;
VectorTypeBase.VECTOR_STR = "MGVEC";
VectorTypeBase.VECTOR_STR_LEN = 5;
//# sourceMappingURL=data:application/json;base64,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