import { XMLConstants } from '@magic-xpa/utils';
import { MgControlBase } from './MgControlBase';
import { List, NString } from '@magic-xpa/mscorelib';
export class ControlTable {
    constructor() {
        this._controls = null;
        this._mgForm = null;
        this._controls = new List();
    }
    fillData(mgForm, parser) {
        this._mgForm = mgForm;
        while (this.initInnerObjects(parser.getNextTag(), parser)) {
        }
    }
    initInnerObjects(foundTagName, parser) {
        if (foundTagName === null)
            return false;
        if (foundTagName === XMLConstants.MG_TAG_CONTROL) {
            let control = this._mgForm.ConstructMgControl();
            control.fillData(this._mgForm, this._controls.length, parser);
            this._controls.push(control);
        }
        else if (foundTagName === ("/" + XMLConstants.MG_TAG_CONTROL)) {
            parser.setCurrIndex2EndOfTag();
            return false;
        }
        else
            return false;
        return true;
    }
    getSize() {
        return this._controls.length;
    }
    getCtrl(idxOrCtrlName) {
        if (arguments.length === 1 && (idxOrCtrlName === null || typeof idxOrCtrlName === "undefined" || idxOrCtrlName.constructor === Number)) {
            return this.getCtrl_0(idxOrCtrlName);
        }
        return this.getCtrl_1(idxOrCtrlName);
    }
    getCtrl_0(idx) {
        if (idx < this.getSize())
            return this._controls.get_Item(idx);
        return null;
    }
    getCtrl_1(ctrlName) {
        if (!NString.IsNullOrEmpty(ctrlName)) {
            return this._controls.find(ctrl => {
                return (NString.Equals(ctrlName, ctrl.getName(), true) ||
                    NString.Equals(ctrlName, ctrl.Name, true));
            });
        }
        return null;
    }
    getCtrlByName(ctrlName, ctrlType) {
        if (!NString.IsNullOrEmpty(ctrlName)) {
            return this._controls.find(ctrl => {
                return ((ctrl.Type === ctrlType) && NString.Equals(ctrlName, ctrl.getName(), true) ||
                    NString.Equals(ctrlName, ctrl.Name, true));
            });
        }
        return null;
    }
    GetControlByIsn(isn) {
        let ctrlByIsn = null;
        ctrlByIsn = this._controls.find(ctrl => {
            return (ctrl.ControlIsn === isn);
        });
        return ctrlByIsn;
    }
    GetControl(predicate) {
        return this._controls.find(predicate);
    }
    filter(callackFuntion) {
        return this._controls.filter(callackFuntion);
    }
    contains(ctrl) {
        let contains = false;
        if (ctrl !== null)
            contains = this._controls.Contains(ctrl);
        return contains;
    }
    addControl(ctrl) {
        this._controls.push(ctrl);
    }
    setControlAt(ctrl, index) {
        if (this._controls.length <= index)
            this._controls.SetSize(index + 1);
        this._controls.set_Item(index, ctrl);
    }
    deleteControlAt(index) {
        this._controls.set_Item(index, null);
    }
    Remove(ctrlOrIdx) {
        if (arguments.length === 1 && (ctrlOrIdx === null || ctrlOrIdx instanceof MgControlBase)) {
            return this.Remove_0(ctrlOrIdx);
        }
        this.Remove_1(ctrlOrIdx);
    }
    Remove_0(ctrl) {
        this._controls.Remove(ctrl);
        return this._controls.Contains(ctrl);
    }
    Remove_1(idx) {
        this._controls.RemoveAt(idx);
    }
    getControlIdx(inCtrl, includeSubs) {
        let counter = 0;
        for (let i = 0; i < this._controls.length; i++) {
            let ctrl = this._controls.get_Item(i);
            if (inCtrl === ctrl)
                return counter;
            else if (includeSubs || !ctrl.isSubform())
                counter++;
        }
        return -1;
    }
}
//# sourceMappingURL=data:application/json;base64,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