import { Exception, NChar, NNumber, NString, NumberFormatInfo, StringBuilder } from '@magic-xpa/mscorelib';
import { DisplayConvertor } from './DisplayConvertor';
import { HTML_2_STR, MgControlType, MsgInterface, PICInterface, StorageAttribute, StrUtil, UtilStrByteMode } from '@magic-xpa/utils';
import { Events } from '../../Events';
import { WrongFormatException } from './WrongFormatException';
import { NUM_TYPE } from '../data/NUM_TYPE';
import { BlobType } from '../data/BlobType';
import { GuiEnvironment } from '../../GuiEnvironment';
import { PropInterface } from './PropInterface';
export class FieldValidator {
    constructor() {
        this._newvalue = null;
        this._oldvalue = null;
        this._pictureReal = null;
        this._pictureEnable = null;
        this._valDet = null;
        this._picture = null;
        this._decimal = null;
        this._environment = null;
        this._environment = GuiEnvironment.Environment;
        this._decimal = (this._environment.GetDecimal() || "");
    }
    checkVal(valDet) {
        this._newvalue = (this._oldvalue = (this._pictureReal = (this._pictureEnable = null)));
        this.init(valDet);
        valDet.setValidationFailed(false);
        let ctrl = valDet.getControl();
        let modInQueuy = ctrl.isRepeatable() ? false : ctrl.GetComputedBooleanProperty(PropInterface.PROP_TYPE_MODIFY_IN_QUERY, false, ctrl.getDisplayLine(false));
        let useNative = ctrl.isModifiable();
        if (ctrl.getForm().getTask().getMode() === 'E' && !modInQueuy) {
            valDet.setValue(this._oldvalue);
            return valDet;
        }
        if (ctrl.Type === MgControlType.CTRL_TYPE_RADIO || ctrl.Type === MgControlType.CTRL_TYPE_CHECKBOX || ctrl.Type === MgControlType.CTRL_TYPE_TAB || ctrl.isSelectionCtrl()) {
            try {
                if (ctrl.Type === MgControlType.CTRL_TYPE_CHECKBOX) {
                    valDet.setNull(ctrl.isNullValue(this._newvalue));
                }
                if (this._newvalue !== null && ctrl.isSelectionCtrl()) {
                    let idx = NNumber.Parse(this._newvalue);
                    if (ctrl.isChoiceNull(idx)) {
                        valDet.setNull(true);
                    }
                }
            }
            catch (ex_111) {
                if (ex_111 instanceof Exception) {
                }
                else
                    throw ex_111;
            }
            valDet.setValue(this._newvalue);
            return valDet;
        }
        if (ctrl.DataType !== StorageAttribute.ALPHA && ctrl.DataType !== StorageAttribute.UNICODE && ctrl.DataType !== StorageAttribute.BLOB) {
            if ((typeof this._newvalue === 'string' && this._newvalue.trim().length === 0) || (ctrl.DataType == StorageAttribute.NUMERIC && this._newvalue == null) || (ctrl.DataType === StorageAttribute.DATE && (ctrl.isDateZero(this._newvalue) || this.isNullDisplayVal()))) {
                let field = ctrl.getField();
                let defaultValue = field.getDefaultValue();
                let text = null;
                if (field.isNullDefault()) {
                    valDet.setNull(true);
                    text = field.getNullDisplay();
                    if (NString.IsNullOrEmpty(text) && ctrl.DataType === StorageAttribute.DATE) {
                        text = DisplayConvertor.Instance.mg2disp(defaultValue, valDet.getRange(), valDet.getPIC(), useNative, field.getTask().getCompIdx(), false);
                    }
                }
                if (text === null) {
                    text = DisplayConvertor.Instance.mg2disp(defaultValue, valDet.getRange(), valDet.getPIC(), useNative, field.getTask().getCompIdx(), false);
                }
                if ((!field.isNullDefault() && (this._valDet.getContinuousRangeValues() !== null || this._valDet.getDiscreteRangeValues() !== null)))
                    this._newvalue = text;
                else {
                    valDet.setValue(text);
                    return valDet;
                }
            }
        }
        if ((typeof this._newvalue === 'string' && !(StrUtil.rtrim(this._newvalue) === StrUtil.rtrim(this._oldvalue))) || ctrl.ModifiedByUser) {
            try {
                switch (valDet.getType()) {
                    case StorageAttribute.ALPHA:
                    case StorageAttribute.UNICODE:
                        valDet.setValue(this.checkAlphaField());
                        break;
                    case StorageAttribute.NUMERIC:
                        this._pictureReal = valDet.getPictureReal();
                        this._pictureEnable = valDet.getPictureEnable();
                        this.checkNumericPicture();
                        valDet.setValue(this.checkNumericField());
                        break;
                    case StorageAttribute.BOOLEAN:
                        valDet.setValue(this.checkLogicalField());
                        break;
                    case StorageAttribute.DATE:
                        valDet.setValue(this.checkDateField());
                        break;
                    case StorageAttribute.TIME:
                        valDet.setValue(this.checkTimeField());
                        break;
                    case StorageAttribute.BLOB:
                    case StorageAttribute.BLOB_VECTOR:
                        valDet.setValue(this._newvalue);
                        break;
                    case StorageAttribute.NONE:
                    default:
                        Events.WriteExceptionToLog("FieldValidator.checkVal: Type of the field " + valDet.getType());
                        break;
                }
            }
            catch (goBack) {
                if (goBack instanceof WrongFormatException) {
                    valDet.setValue(this._oldvalue);
                    this.setValidationFailed(true);
                    if (goBack.getType() !== MsgInterface.STR_RNG_TXT) {
                        this.printMessage(goBack.getType(), false);
                        this.setValidationFailed(true);
                    }
                    else
                        this.printMessage(MsgInterface.STR_RNG_TXT, true);
                }
            }
        }
        return valDet;
    }
    checkAlphaField() {
        let control = this._valDet.getControl();
        let IsAttrAlpha = this._valDet.getType() === StorageAttribute.ALPHA;
        if (this._newvalue.length === 0 && this._valDet.getContinuousRangeValues() === null && this._valDet.getDiscreteRangeValues() === null) {
            this.setValidationFailed(false);
            return this._newvalue;
        }
        if (IsAttrAlpha && UtilStrByteMode.isLocaleDefLangDBCS()) {
            let picLenB = UtilStrByteMode.lenB(this._picture);
            if (UtilStrByteMode.lenB(this._newvalue) > picLenB) {
                this._newvalue = UtilStrByteMode.leftB(this._newvalue, picLenB);
            }
        }
        else {
            if (this._newvalue.length > this._picture.length) {
                this._newvalue = this._newvalue.substr(0, this._picture.length);
            }
        }
        let stringBuilder = new StringBuilder();
        let currPicture;
        let i = currPicture = 0;
        for (currPicture = i = 0; i < this._newvalue.length && currPicture < this._picture.length;) {
            if (!DisplayConvertor.isAlphaPositionalDirective(this._picture.charAt(currPicture)) && this._newvalue.charAt(i) === this._picture.charAt(currPicture)) {
                stringBuilder.Append(this._picture.charAt(currPicture));
                i = i + 1;
                currPicture = currPicture + 1;
            }
            else {
                if (!DisplayConvertor.isAlphaPositionalDirective(this._picture.charAt(currPicture)) && this._newvalue.charAt(i) !== this._picture.charAt(currPicture)) {
                    stringBuilder.Append(this._picture.charAt(currPicture));
                    currPicture = currPicture + 1;
                }
                else {
                    if (DisplayConvertor.isAlphaPositionalDirective(this._picture.charAt(currPicture)) && this.isPossibleAlphaLetter(i, currPicture)) {
                        if (UtilStrByteMode.isLocaleDefLangDBCS()) {
                            let strVal = this._newvalue.substr(i, 1);
                            if (UtilStrByteMode.lenB(strVal) === 2) {
                                if (IsAttrAlpha) {
                                    if (currPicture + 1 < this._picture.length) {
                                        if (DisplayConvertor.isAlphaPositionalDirective(this._picture.charAt(currPicture + 1)) && this.isPossibleAlphaLetter(i, currPicture + 1)) {
                                            stringBuilder.Append(this._newvalue.charAt(i));
                                            i = i + 1;
                                            currPicture = currPicture + 2;
                                        }
                                        else {
                                            stringBuilder.Append(' ');
                                            currPicture = currPicture + 1;
                                        }
                                    }
                                    else {
                                        stringBuilder.Append(' ');
                                        currPicture = currPicture + 1;
                                    }
                                }
                                else {
                                    stringBuilder.Append(this._newvalue.charAt(i));
                                    i = i + 1;
                                    currPicture = currPicture + 1;
                                }
                            }
                            else {
                                stringBuilder.Append(this._newvalue.charAt(i));
                                i = i + 1;
                                currPicture = currPicture + 1;
                            }
                        }
                        else {
                            stringBuilder.Append(this._newvalue.charAt(i));
                            i = i + 1;
                            currPicture = currPicture + 1;
                        }
                    }
                    else {
                        stringBuilder.Append(' ');
                        currPicture = currPicture + 1;
                        if (this._valDet.getControl() !== null) {
                            let type = control.Type;
                            if (type !== MgControlType.CTRL_TYPE_BUTTON) {
                                this.printMessage(MsgInterface.STR_ERR_NUM, false);
                            }
                        }
                    }
                }
            }
        }
        this._newvalue = stringBuilder.ToString();
        if (this._valDet.getContinuousRangeValues() !== null || this._valDet.getDiscreteRangeValues() !== null) {
            this._newvalue = this.fillAlphaByRange(this._valDet.getContinuousRangeValues(), this._valDet.getDiscreteRangeValues());
        }
        return this._newvalue;
    }
    isPossibleAlphaLetter(indexInput, indexPicture) {
        switch (this._picture.charCodeAt(indexPicture)) {
            case PICInterface.PIC_X:
            case PICInterface.PIC_J:
            case PICInterface.PIC_G:
            case PICInterface.PIC_S:
            case PICInterface.PIC_T:
                return true;
            case PICInterface.PIC_U:
                let upper = this._newvalue[indexInput].toUpperCase();
                if (upper !== this._newvalue[indexInput])
                    this.changeStringInside("" + upper, indexInput);
                return true;
            case PICInterface.PIC_L:
                let lower = this._newvalue[indexInput].toLowerCase();
                if (lower !== this._newvalue[indexInput])
                    this.changeStringInside("" + lower, indexInput);
                return true;
            case PICInterface.PIC_N:
                let number1 = this._newvalue[indexInput];
                if (UtilStrByteMode.isDigit(number1) || NChar.IsWhiteSpace(number1) || UtilStrByteMode.asNumeric(number1))
                    return true;
                else {
                    Events.WriteErrorToLog("Bad Alpha value. Should be number only on place Num. " + indexInput);
                    return false;
                }
            default:
                Events.WriteErrorToLog("FieldValidator.isPossibleAlphaLetter: illegal Char Directive: " + this._picture.indexOf(String.fromCharCode(indexPicture)) + " for " + this._newvalue[indexInput]);
                return false;
        }
    }
    fillAlphaByRange(ContinuousRangeValues, DiscreteRangeValues) {
        let tmpBuffer = DisplayConvertor.Instance.fillAlphaByDiscreteRangeValues(DiscreteRangeValues, this._newvalue);
        if (tmpBuffer !== null) {
            return tmpBuffer;
        }
        tmpBuffer = DisplayConvertor.Instance.fillAlphaByContinuousRangeValues(ContinuousRangeValues, this._newvalue);
        if (tmpBuffer !== null)
            return tmpBuffer;
        if (DiscreteRangeValues !== null)
            return this.CompleteAlphaByRange(DiscreteRangeValues);
        this.printMessage(MsgInterface.STR_RNG_TXT, true);
        return this._oldvalue;
    }
    CompleteAlphaByRange(DiscreteRangeValues) {
        let tmpNewValue = DisplayConvertor.Instance.completeAlphaByRange(DiscreteRangeValues, this._newvalue);
        if (tmpNewValue !== null) {
            return tmpNewValue;
        }
        this.printMessage(MsgInterface.STR_RNG_TXT, true);
        return this._oldvalue;
    }
    checkLogicalField() {
        if (this._newvalue.length === 0 && this._valDet.getContinuousRangeValues() === null && this._valDet.getDiscreteRangeValues() === null) {
            throw new WrongFormatException(MsgInterface.STR_RNG_TXT);
        }
        if (this._valDet.getContinuousRangeValues() !== null || this._valDet.getDiscreteRangeValues() !== null) {
            this._newvalue = this.fillAlphaByRange(this._valDet.getContinuousRangeValues(), this._valDet.getDiscreteRangeValues());
        }
        this.setValidationFailed(false);
        return this._newvalue;
    }
    checkNumericField() {
        let evaluated;
        if (typeof this._newvalue === 'string') {
            if (this._newvalue.length === 0) {
                this._newvalue = "0";
            }
            let delimeterRealIndex = this._newvalue.indexOf(this._decimal);
            let delimeterPictIndex = this._pictureReal.indexOf(this._decimal);
            evaluated = "";
            let evaluatedLeft;
            let evaluatedRight;
            this.setValidationFailed(false);
            if (!this.checkNumericInDecFormat())
                throw new WrongFormatException(MsgInterface.EDT_ERR_STR_1);
            if (delimeterPictIndex !== -1 && delimeterRealIndex !== -1) {
                evaluatedLeft = this.checkNumericLeft(delimeterPictIndex, delimeterRealIndex);
                evaluatedRight = this.checkNumericRight(delimeterPictIndex, delimeterRealIndex);
                evaluated = evaluatedLeft + this._decimal + evaluatedRight;
            }
            else {
                if (delimeterPictIndex !== -1 && delimeterRealIndex === -1) {
                    evaluatedLeft = this.checkNumericLeft(delimeterPictIndex, Math.min(delimeterPictIndex, this._newvalue.length));
                    evaluatedRight = this.checkNumericRight(delimeterPictIndex, delimeterPictIndex - 1);
                    evaluated = evaluatedLeft + this._decimal + evaluatedRight;
                }
                else {
                    if (delimeterPictIndex === -1 && delimeterRealIndex === -1) {
                        evaluated = this.checkNumericRight(-1, -1);
                        evaluatedLeft = evaluated;
                    }
                    else {
                        if (delimeterRealIndex > 0) {
                            this._newvalue = this._newvalue.substr(0, delimeterRealIndex);
                        }
                        else {
                            this._newvalue = "0";
                        }
                        evaluated = this.checkNumericRight(-1, -1);
                        evaluatedLeft = evaluated;
                    }
                }
            }
            if ((evaluatedRight.length === 0 && evaluatedLeft.length === 0) || (evaluated.length === 0 && this._newvalue.length > 0)) {
                let ctrl;
                ctrl = this._valDet.getControl();
                let field = ctrl.getField();
                let defValue = field.getDefaultValue();
                let dispDefValue = null;
                if (field.isNullDefault()) {
                    this._valDet.setNull(true);
                    dispDefValue = field.getNullDisplay();
                }
                if (dispDefValue == null)
                    dispDefValue = DisplayConvertor.Instance.mg2disp(defValue, this._valDet.getRange(), this._valDet.getPIC(), true, field.getTask().getCompIdx(), false);
            }
            let wholeDigitdiff = this.digitsBeforeDelimeter(evaluated, 0, this._decimal) - this._valDet.getPIC().getWholes();
            if (wholeDigitdiff > 0) {
                let padCharOnly = false;
                if (this._valDet.getIsPadFill()) {
                    padCharOnly = true;
                    for (let i = 0; i < wholeDigitdiff && padCharOnly; i++)
                        if (evaluated[i] !== this._valDet.getPadFillChar())
                            padCharOnly = false;
                }
                if (!padCharOnly)
                    throw new WrongFormatException(MsgInterface.EDT_ERR_STR_1);
            }
            if (this._valDet.getIsNegative() && (this._newvalue.trim().startsWith("-") || (this._valDet.getNegativeSignPref().length !== 0 && this._newvalue.trim().startsWith(this._valDet.getNegativeSignPref())))) {
                evaluated = "-" + evaluated;
            }
            evaluated = DisplayConvertor.Instance.disp2mg(this._newvalue, this._valDet.getPIC(), this._valDet.getControl().getForm().getTask().getCompIdx(), BlobType.CONTENT_TYPE_UNKNOWN);
            evaluated = DisplayConvertor.Instance.mg2disp(evaluated, "", this._valDet.getPIC(), true, this._valDet.getControl().getForm().getTask().getCompIdx(), true);
            let tempDispVal = StrUtil.ltrim(evaluated);
            if (tempDispVal.length === 0 && this._valDet.getPIC().zeroFill() && this._valDet.getPIC().getZeroPad() === ' ')
                evaluated = "0";
        }
        else {
            evaluated = DisplayConvertor.Instance.disp2mg(this._newvalue, this._valDet.getPIC(), this._valDet.getControl().getForm().getTask().getCompIdx(), BlobType.CONTENT_TYPE_UNKNOWN);
            evaluated = DisplayConvertor.Instance.mg2disp(evaluated, "", this._valDet.getPIC(), true, this._valDet.getControl().getForm().getTask().getCompIdx(), true);
        }
        if (this._valDet.getContinuousRangeValues() != null || this._valDet.getDiscreteRangeValues() != null) {
            this._newvalue = evaluated;
            evaluated = this.fillNumericByRange();
        }
        return evaluated;
    }
    checkNumericLeft(delimeterPictIndex, delimeterRealIndex) {
        let buffer = new StringBuilder();
        let RealIndex = delimeterRealIndex - 1;
        let PictIndex;
        let isFound;
        for (PictIndex = delimeterPictIndex - 1; PictIndex >= 0 && RealIndex >= 0; PictIndex--) {
            if (this._pictureEnable[PictIndex] === '1') {
                let tmpstorage = RealIndex;
                isFound = false;
                for (; RealIndex >= 0; RealIndex--) {
                    if (this._pictureReal[PictIndex] === this._newvalue[RealIndex]) {
                        isFound = true;
                        RealIndex--;
                        break;
                    }
                }
                if (!isFound)
                    RealIndex = tmpstorage;
                buffer.Append(this._pictureReal[PictIndex]);
            }
            else {
                for (; RealIndex >= 0; RealIndex--) {
                    if (UtilStrByteMode.isDigit(this._newvalue[RealIndex])) {
                        buffer.Append(this._newvalue[RealIndex]);
                        RealIndex--;
                        break;
                    }
                }
            }
        }
        if (RealIndex < 0 && PictIndex >= 0)
            for (; PictIndex >= 0; PictIndex--) {
                if (this._pictureEnable[PictIndex] === '1')
                    buffer.Append(this._pictureReal[PictIndex]);
                else {
                    if (this._valDet.getIsPadFill())
                        buffer.Append(this._valDet.getPadFillChar());
                }
            }
        return StrUtil.ReverseString(buffer).ToString();
    }
    checkNumericRight(delimeterPictIndex, delimeterRealIndex) {
        let buffer = new StringBuilder();
        let RealIndex = delimeterRealIndex + 1;
        let PictIndex;
        let pic = this._valDet.getPIC();
        for (PictIndex = delimeterPictIndex + 1; PictIndex < this._pictureEnable.length && RealIndex < this._newvalue.length; PictIndex++) {
            if (this._pictureEnable[PictIndex] === '1') {
                if (RealIndex < PictIndex)
                    RealIndex = PictIndex;
                buffer.Append(this._pictureReal[PictIndex]);
            }
            else {
                for (; RealIndex < this._newvalue.length; RealIndex++) {
                    if (UtilStrByteMode.isDigit(this._newvalue[RealIndex]) && !pic.picIsMask(RealIndex)) {
                        buffer.Append(this._newvalue[RealIndex]);
                        RealIndex++;
                        break;
                    }
                }
            }
        }
        if (buffer.Length > 0) {
            if (RealIndex >= this._newvalue.length && PictIndex < this._pictureReal.length)
                for (; PictIndex < this._pictureReal.length; PictIndex++) {
                    if (this._pictureEnable[PictIndex] === '1')
                        buffer.Append(this._pictureReal[PictIndex]);
                }
        }
        return buffer.ToString();
    }
    checkNumericPicture() {
        let indexOfDec;
        let lastDec;
        let maxLength;
        let currIndx;
        let POINT_DEC = ".";
        let pic = this._valDet.getPIC();
        if (this._pictureReal == null || this._pictureEnable == null || pic.getAttr() !== StorageAttribute.NUMERIC || !pic.withDecimal())
            return;
        lastDec = this._pictureReal.lastIndexOf(POINT_DEC);
        maxLength = this._pictureEnable.length;
        currIndx = 0;
        while (currIndx < lastDec) {
            indexOfDec = this._pictureEnable.indexOf("1", currIndx);
            if (indexOfDec === -1)
                return;
            else {
                if (indexOfDec === this._pictureReal.indexOf(POINT_DEC, currIndx)) {
                    let first;
                    let second;
                    first = second = "";
                    if (indexOfDec === 0) {
                        if (indexOfDec + 1 < maxLength)
                            second = this._pictureReal.substr(indexOfDec + 1);
                    }
                    else if (indexOfDec === maxLength) {
                        first = this._pictureReal.substr(0, indexOfDec);
                    }
                    else {
                        first = this._pictureReal.substr(0, indexOfDec);
                        second = this._pictureReal.substr(indexOfDec + 1);
                    }
                    this._pictureReal = first + this._decimal + second;
                    break;
                }
                else {
                    currIndx = ++indexOfDec;
                }
            }
        }
    }
    fillNumericByRange() {
        let controlPic = this._valDet.getControl().getPIC();
        let continuousRangeValues = this._valDet.getContinuousRangeValues();
        let discreteRangeValues = this._valDet.getDiscreteRangeValues();
        this.setValidationFailed(false);
        let checkedStr = this.setNumericValueWithoutPicture(this._newvalue.toString());
        if (checkedStr.length === 0) {
            this.printMessage(MsgInterface.STR_RNG_TXT, true);
            return this._oldvalue;
        }
        let checkedNum = new NUM_TYPE(this._newvalue.toString(), this._valDet.getControl().getPIC(), 0);
        if (discreteRangeValues !== null) {
            for (let i = 0; i < discreteRangeValues.length; i = i + 1) {
                let rangeItemValue1 = new NUM_TYPE(discreteRangeValues.get_Item(i), controlPic, 0);
                try {
                    if (NUM_TYPE.num_cmp(checkedNum, rangeItemValue1) === 0) {
                        return this._newvalue;
                    }
                }
                catch (ex_CC) {
                }
            }
        }
        if (continuousRangeValues !== null) {
            for (let i = 0; i < continuousRangeValues.length; i = i + 1) {
                let rangeItemValue1 = new NUM_TYPE();
                let rangeItemValue2 = new NUM_TYPE();
                rangeItemValue1.num_4_a_std(continuousRangeValues.get_Item(i++));
                rangeItemValue2.num_4_a_std(continuousRangeValues.get_Item(i));
                try {
                    if (NUM_TYPE.num_cmp(checkedNum, rangeItemValue1) !== -1 && NUM_TYPE.num_cmp(rangeItemValue2, checkedNum) !== -1) {
                        return this._newvalue;
                    }
                }
                catch (ex_15B) {
                }
            }
        }
        throw new WrongFormatException();
    }
    setNumericValueWithoutPicture(val) {
        let checkedStr = new StringBuilder(val.length);
        let isFirstDecimal = false;
        let currChar;
        for (let i = 0; i < this._pictureReal.length && i < val.length; i++) {
            currChar = val[i];
            if (UtilStrByteMode.isDigit(currChar))
                checkedStr.Append(currChar);
            else if (currChar === this._environment.GetDecimal() && !isFirstDecimal) {
                checkedStr.Append(NString.ToCharArray(NumberFormatInfo.NumberDecimalSeparator).toString());
                isFirstDecimal = true;
            }
            else if (currChar === '-' && this._valDet.getIsNegative())
                checkedStr.Append(NString.ToCharArray(NumberFormatInfo.NegativeSign).toString());
        }
        if (checkedStr.ToString().length === 0) {
            this.printMessage(MsgInterface.STR_ERR_NUM, false);
            this.setValidationFailed(true);
        }
        return checkedStr.ToString();
    }
    checkNumericInDecFormat() {
        let pic = this._valDet.getPIC();
        let i;
        let Dec;
        let Whole;
        let DecPos;
        let decimalChar = this._environment.GetDecimal();
        Dec = 0;
        Whole = 0;
        DecPos = -1;
        for (i = 0; i < this._newvalue.length; i++)
            if (pic.isNumeric(i))
                if (UtilStrByteMode.isDigit(this._newvalue[i]))
                    if (DecPos >= 0)
                        Dec++;
                    else
                        Whole++;
                else if (this._newvalue[i] === decimalChar)
                    DecPos = i;
        if (pic.getWholes() < Whole || pic.getDec() < Dec)
            return false;
        else
            return true;
    }
    checkDateField() {
        let newDate = (this._newvalue == null ? null : new Date(this._newvalue));
        this.setValidationFailed(false);
        if (this._valDet.getControl().isDateZero(this._newvalue)) {
            let defaultMgValue = this._valDet.getControl().getField().getDefaultValue();
            newDate = DisplayConvertor.Instance.mg2disp(defaultMgValue, "", this._valDet.getPIC(), true, this._valDet.getControl().getForm().getTask().getCompIdx(), false);
        }
        else {
            if (this._valDet.getContinuousRangeValues() != null || this._valDet.getDiscreteRangeValues() != null)
                newDate = this.fillDateByRange(this._valDet.getContinuousRangeValues(), this._valDet.getDiscreteRangeValues(), this._newvalue);
        }
        return newDate;
    }
    fillDateByRange(ContinuousRange, DiscreteRange, buffer) {
        let pic = this._valDet.getPIC();
        let i;
        let downDate;
        let topDate;
        let currDate = DisplayConvertor.Instance.fromNativeDateToMgDateNumber(buffer, pic);
        this.setValidationFailed(false);
        if (ContinuousRange != null) {
            for (i = 0; i < ContinuousRange.length - 1; i++) {
                downDate = DisplayConvertor.Instance.a_2_date_pic(ContinuousRange.get_Item(i), pic, pic.getMask(), this._valDet.getControl().getForm().getTask().getCompIdx());
                topDate = DisplayConvertor.Instance.a_2_date_pic(ContinuousRange.get_Item(++i), pic, pic.getMask(), this._valDet.getControl().getForm().getTask().getCompIdx());
                if (currDate >= downDate && currDate <= topDate)
                    return new Date(buffer);
            }
        }
        if (DiscreteRange != null) {
            for (i = 0; i < DiscreteRange.length; i++) {
                if (currDate === DisplayConvertor.Instance.a_2_date_pic(DiscreteRange.get_Item(i), pic, pic.getMask(), this._valDet.getControl().getForm().getTask().getCompIdx())) {
                    return new Date(buffer);
                }
            }
        }
        throw new WrongFormatException();
    }
    checkTimeField() {
        let newTime = new Date(this._newvalue);
        this.setValidationFailed(false);
        if (this._valDet.getControl().isDateZero(this._newvalue)) {
            let defaultMgValue = this._valDet.getControl().getField().getDefaultValue();
            newTime = DisplayConvertor.Instance.mg2disp(defaultMgValue, "", this._valDet.getPIC(), true, this._valDet.getControl().getForm().getTask().getCompIdx(), false);
        }
        else {
            if (this._valDet.getContinuousRangeValues() != null || this._valDet.getDiscreteRangeValues() != null)
                newTime = this.fillTimeByRange(this._valDet.getContinuousRangeValues(), this._valDet.getDiscreteRangeValues(), this._newvalue);
        }
        return newTime;
    }
    fillTimeByRange(ContinuousRange, DiscreteRange, buffer) {
        let pic = this._valDet.getPIC();
        let currTime = DisplayConvertor.Instance.fromNativeTimeToMgTimeNumber(buffer);
        let downTime, topTime;
        let i;
        this.setValidationFailed(false);
        if (ContinuousRange != null) {
            for (i = 0; i < ContinuousRange.length - 1; i++) {
                downTime = DisplayConvertor.Instance.a_2_time(ContinuousRange.get_Item(i), pic, false);
                topTime = DisplayConvertor.Instance.a_2_time(ContinuousRange.get_Item(++i), pic, false);
                if (currTime >= downTime && currTime <= topTime)
                    return new Date(buffer);
            }
        }
        if (DiscreteRange != null) {
            for (i = 0; i < DiscreteRange.length; i++) {
                if (currTime === DisplayConvertor.Instance.a_2_time(DiscreteRange.get_Item(i), pic, false))
                    return new Date(buffer);
            }
        }
        throw new WrongFormatException();
    }
    printMessage(msgId, setValidationFaild) {
        let message = new StringBuilder("");
        let ctrlType;
        if (msgId === MsgInterface.EDT_ERR_STR_1) {
            let pic = this._valDet.getPIC();
            let token = "%d";
            let messageString = Events.GetMessageString(msgId);
            messageString = StrUtil.replaceStringTokens(messageString, token, 1, pic.getWholes().toString());
            messageString = StrUtil.replaceStringTokens(messageString, token, 1, pic.getDec().toString());
            message.Append(messageString);
        }
        else {
            message.Append(Events.GetMessageString(msgId));
            if (msgId === MsgInterface.STR_RNG_TXT && this._valDet.getRange() != null)
                message.Append(StrUtil.makePrintableTokens(this._valDet.getRange(), HTML_2_STR));
        }
        if (this._valDet.getControl() != null) {
            ctrlType = this._valDet.getControl().Type;
            if (ctrlType !== MgControlType.CTRL_TYPE_BUTTON && ctrlType !== MgControlType.CTRL_TYPE_RADIO && !this._valDet.getControl().isSelectionCtrl()) {
                let msgString = message.ToString();
                this._valDet.getControl().getForm().getTask().WriteToMessagePane(StrUtil.makePrintable2(msgString));
                this._valDet.getControl().getForm().ErrorOccured = !NString.IsNullOrEmpty(msgString);
                this._valDet.ErrorMessage = message.ToString();
            }
        }
        if (setValidationFaild)
            this.setValidationFailed(true);
    }
    changeStringInside(to, index) {
        this._newvalue = this._newvalue.substr(0, index) + to + this._newvalue.substr(index + to.length);
    }
    init(validationDetails) {
        this._valDet = validationDetails;
        this._valDet.setNull(false);
        let pIC = this._valDet.getPIC();
        this._oldvalue = this._valDet.getOldValue();
        this._newvalue = this._valDet.getDispValue();
        if (this._newvalue === null) {
            if (pIC == null || pIC.getAttr() != StorageAttribute.DATE)
                this._newvalue = "";
        }
        if (this._oldvalue === null) {
            this._oldvalue = "";
        }
        if (!(pIC === null || pIC.getAttr() === StorageAttribute.BLOB || pIC.getAttr() === StorageAttribute.BLOB_VECTOR)) {
            this._picture = pIC.getMask();
            this._picture = this._picture.substr(0, pIC.getMaskSize());
        }
    }
    setValidationFailed(val) {
        if (this._valDet.ValidationFailed)
            return;
        else
            this._valDet.setValidationFailed(val);
    }
    digitsBeforeDelimeter(inputString, searchStart, delimeter) {
        let counter = 0;
        let searchEndPos = inputString.indexOf(delimeter, searchStart);
        if (searchEndPos < 0)
            searchEndPos = inputString.length;
        for (let i = searchStart; i < searchEndPos; i++)
            if (NChar.IsDigit(inputString[i]))
                counter++;
        return counter;
    }
    isNullDisplayVal() {
        let isNullDisplayVal = false;
        let field = this._valDet.getControl().getField();
        if (field.NullAllowed && field.hasNullDisplayValue()) {
            let dispDefValue = field.getNullDisplay();
            if (dispDefValue !== null)
                isNullDisplayVal = (dispDefValue.toString() === this._newvalue);
            else
                isNullDisplayVal = (this._newvalue === null);
        }
        return isNullDisplayVal;
    }
}
//# sourceMappingURL=data:application/json;base64,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