import { Events } from '../../Events';
import { MsgInterface } from '@magic-xpa/utils';
import { MemoryUtil } from '../../util/MemoryUtil';
export class HebrewDate {
    static dateheb_year_is_leap(year) {
        year = year % HebrewDate.YEARS_PER_CYCLE;
        return (HebrewDate.DATEHEB_months_n[(year + 1)] - HebrewDate.DATEHEB_months_n[year] === 13);
    }
    static dateheb_days_in_month(month, leap, days_in_year) {
        let days_in_month = leap ? HebrewDate.DATEHEB_leap_days_in_month[month - 1] : HebrewDate.DATEHEB_norm_days_in_month[month - 1];
        if (leap)
            days_in_year = days_in_year - 30;
        switch (days_in_year) {
            case 353:
                if (month === HebrewDate.KISLEV)
                    days_in_month = 29;
                break;
            case 355:
                if (month === HebrewDate.HESHVAN)
                    days_in_month = 30;
                break;
        }
        return days_in_month;
    }
    static dateheb_year_start(year) {
        year = year - 1;
        let cycle = Math.floor(year / HebrewDate.YEARS_PER_CYCLE);
        year = year % HebrewDate.YEARS_PER_CYCLE;
        let months = cycle * HebrewDate.MONTHS_PER_CYCLE + HebrewDate.DATEHEB_months_n[year];
        let days = months * HebrewDate.MONTH_DAYS;
        let parts = months * HebrewDate.MONTH_EXTRA_PARTS + HebrewDate.CREATION_PARTS;
        days = days + Math.floor(parts / HebrewDate.PARTS_PER_DAY);
        parts = parts % HebrewDate.PARTS_PER_DAY;
        if (parts >= Math.floor(HebrewDate.PARTS_PER_DAY * 3 / 4)) {
            parts = 0;
            days = days + 1;
        }
        let dow = (days - 1 + HebrewDate.CREATION_DOW) % 7 + 1;
        if ((dow === 1) || (dow === 4) || (dow === 6)) {
            parts = 0;
            days = days + 1;
        }
        if (!HebrewDate.dateheb_year_is_leap(year)) {
            if (dow === 3 && parts >= (9 * HebrewDate.PARTS_PER_HOUR + 204))
                days = days + 2;
        }
        if (HebrewDate.dateheb_year_is_leap(year + HebrewDate.YEARS_PER_CYCLE - 1)) {
            if (dow === 2 && parts >= (15 * HebrewDate.PARTS_PER_HOUR + 589))
                days = days + 1;
        }
        return days;
    }
    static dateheb_4_d(date, day, month, year) {
        date = date + HebrewDate.DAYS_TIL_JESUS;
        let cycle = Math.floor(date / (HebrewDate.DAYS_PER_CYCLE + 1));
        let days = date % (HebrewDate.DAYS_PER_CYCLE + 1);
        year.value = cycle * HebrewDate.YEARS_PER_CYCLE;
        year.value = year.value + Math.floor(days / (HebrewDate.DAYS_PER_LEAP_YEAR + 1));
        let next_year_start;
        while (true) {
            next_year_start = HebrewDate.dateheb_year_start(year.value + 1);
            if (next_year_start >= date)
                break;
            year.value = year.value + 1;
        }
        let curr_year_start = HebrewDate.dateheb_year_start(year.value);
        day.value = date - curr_year_start;
        let days_in_year = next_year_start - curr_year_start;
        let leap = days_in_year > 355;
        let i;
        for (i = 1; i < 13; i = i + 1) {
            let days_in_month = HebrewDate.dateheb_days_in_month(i, leap, days_in_year);
            if (day.value <= days_in_month)
                break;
            day.value = day.value - days_in_month;
        }
        if (!leap || i <= HebrewDate.ADAR)
            month.value = i;
        else if (i === HebrewDate.ADAR + 1)
            month.value = HebrewDate.ADAR_B;
        else
            month.value = i - 1;
        return leap;
    }
    static dateheb_i_2_h(val, str, strPos, use_ending, quote) {
        let let_idx = 0;
        let len = 0;
        while (val > 0) {
            for (let_idx = HebrewDate.DATEHEB_letters.length; let_idx > 0; let_idx = let_idx - 1) {
                let letter = HebrewDate.DATEHEB_letters[let_idx - 1];
                if (val >= letter) {
                    val = val - letter;
                    str[strPos++] = String.fromCharCode(HebrewDate.ALEF.charCodeAt(0) + let_idx - 1);
                    len = len + 1;
                    break;
                }
            }
        }
        if (len > 0) {
            if (len >= 2) {
                if (str[strPos - 2] === 'י')
                    if (str[strPos - 1] === 'ה' || str[strPos - 1] === 'ו') {
                        str[strPos - 2] = String.fromCharCode(str[strPos - 2].charCodeAt(0) - 1);
                        str[strPos - 1] = str[strPos - 1] + '\u0001';
                    }
            }
            if (let_idx > 10 && use_ending) {
                if (HebrewDate.DATEHEB_letters[let_idx - 1] === HebrewDate.DATEHEB_letters[let_idx - 2]) {
                    str[strPos - 1] = String.fromCharCode(str[strPos - 1].charCodeAt(0) - 1);
                }
            }
            if (quote) {
                if (len === 1)
                    str[strPos] = '\'';
                else {
                    str[strPos] = str[strPos - 1];
                    str[strPos - 1] = '"';
                }
                len = len + 1;
            }
        }
        return len;
    }
    static dateheb_2_str(outStr, strPos, len, out_len, full_len, hyear, trim, use_ending) {
        let quote = len > full_len && outStr[strPos + full_len] === outStr[strPos];
        if (quote)
            full_len = full_len + 1;
        let heb_len = HebrewDate.dateheb_i_2_h(hyear % 1000, outStr, strPos, use_ending, quote);
        let rem_len = full_len - heb_len;
        if (rem_len > 0) {
            if (trim) {
                out_len.value = out_len.value - rem_len;
                let tmp_out_len = len - full_len;
                if (tmp_out_len > 0)
                    MemoryUtil.char_memcpy(outStr, strPos + heb_len, outStr, strPos + full_len, tmp_out_len);
                else
                    heb_len = full_len;
            }
            else {
                if (rem_len > outStr.length - strPos - heb_len)
                    rem_len = outStr.length - strPos - heb_len;
                MemoryUtil.char_memset(outStr, strPos + heb_len, ' ', rem_len);
                heb_len = full_len;
            }
        }
        return heb_len;
    }
    static GetLocalMonths() {
        let monthLen = HebrewDate.MONTH_LEN;
        if (HebrewDate._localMonths[0] === null) {
            let monthStr = Events.GetMessageString(MsgInterface.DATEHEB_MONTH_STR);
            if (monthStr !== null) {
                HebrewDate._localMonths[0] = "       ";
                for (let i = 1; i < HebrewDate._localMonths.length; i = i + 1)
                    HebrewDate._localMonths[i] = monthStr.substr((i - 1) * monthLen, i * monthLen - (i - 1) * monthLen);
            }
        }
        return HebrewDate._localMonths;
    }
    static GetLocalDows() {
        let dowLen = HebrewDate.DOW_LEN;
        if (HebrewDate._localDows[0] === null) {
            let dowsStr = Events.GetMessageString(MsgInterface.DATEHEB_DOW_STR);
            if (dowsStr !== null) {
                HebrewDate._localDows[0] = "     ";
                for (let i = 1; i < HebrewDate._localDows.length; i = i + 1)
                    HebrewDate._localDows[i] = dowsStr.substr((i - 1) * dowLen, i * dowLen - (i - 1) * dowLen);
            }
        }
        return HebrewDate._localDows;
    }
    static dateheb_h_2_i(str, len, pos) {
        let val;
        let has_1_to_9 = false;
        let has_10_to_90 = false;
        let has_100_to_300 = false;
        let cnt_400 = 0;
        let last_val = 1000;
        let let_val;
        for (val = 0; len > 0 && pos < str.length; pos++, len--)
            if (str[pos] >= HebrewDate.ALEF && str[pos] <= HebrewDate.TAV) {
                let_val = HebrewDate.DATEHEB_letters[(str[pos].charCodeAt(0) - HebrewDate.ALEF.charCodeAt(0))];
                if (let_val > last_val)
                    return 0;
                if (let_val === 400) {
                    if (cnt_400 === 2)
                        return 0;
                    cnt_400 = cnt_400 + 1;
                }
                else if (let_val >= 100) {
                    if (has_100_to_300)
                        return 0;
                    has_100_to_300 = true;
                }
                else if (let_val >= 10) {
                    if (has_10_to_90)
                        return 0;
                    has_10_to_90 = true;
                }
                else {
                    if (has_1_to_9) {
                        if (has_10_to_90 || last_val !== 9)
                            return 0;
                        if (let_val !== 6 && let_val !== 7)
                            return 0;
                    }
                    has_1_to_9 = true;
                }
                val = val + let_val;
                last_val = let_val;
            }
        return val;
    }
    static dateheb_2_d(year, month, day) {
        if (day === 0 && month === 0 && year === 0)
            return 0;
        if (day === 0 || month === 0 || year === 0)
            return 1000000000;
        let days_from_creation = HebrewDate.dateheb_year_start(year);
        let days_in_year = HebrewDate.dateheb_year_start(year + 1) - days_from_creation;
        let leap = days_in_year > 355;
        if (leap && month > HebrewDate.ADAR)
            if (month === HebrewDate.ADAR_B)
                month = HebrewDate.ADAR + 1;
            else
                month = month + 1;
        if (day > HebrewDate.dateheb_days_in_month(month, leap, days_in_year))
            return 1000000000;
        for (let i = 1; i < month; i = i + 1)
            days_from_creation = days_from_creation + HebrewDate.dateheb_days_in_month(i, leap, days_in_year);
        days_from_creation = days_from_creation + day;
        return Math.max(days_from_creation - HebrewDate.DAYS_TIL_JESUS, 0);
    }
}
HebrewDate.PARTS_PER_HOUR = 1080;
HebrewDate.HOURS_PER_DAY = 24;
HebrewDate.PARTS_PER_DAY = (HebrewDate.HOURS_PER_DAY * HebrewDate.PARTS_PER_HOUR);
HebrewDate.MONTH_DAYS = 29;
HebrewDate.MONTH_EXTRA_PARTS = (12 * HebrewDate.PARTS_PER_HOUR + 793);
HebrewDate.PARTS_PER_MONTH = (HebrewDate.MONTH_DAYS * HebrewDate.PARTS_PER_DAY + HebrewDate.MONTH_EXTRA_PARTS);
HebrewDate.MONTHS_PER_NORM_YEAR = 12;
HebrewDate.MONTHS_PER_LEAP_YEAR = 13;
HebrewDate.NORM_YEARS_PER_CYCLE = 12;
HebrewDate.LEAP_YEARS_PER_CYCLE = 7;
HebrewDate.YEARS_PER_CYCLE = (HebrewDate.NORM_YEARS_PER_CYCLE + HebrewDate.LEAP_YEARS_PER_CYCLE);
HebrewDate.MONTHS_PER_CYCLE = (HebrewDate.NORM_YEARS_PER_CYCLE * HebrewDate.MONTHS_PER_NORM_YEAR + HebrewDate.LEAP_YEARS_PER_CYCLE * HebrewDate.MONTHS_PER_LEAP_YEAR);
HebrewDate.PARTS_PER_LEAP_YEAR = (HebrewDate.MONTHS_PER_LEAP_YEAR * HebrewDate.PARTS_PER_MONTH);
HebrewDate.DAYS_PER_LEAP_YEAR = Math.floor(HebrewDate.PARTS_PER_LEAP_YEAR / HebrewDate.PARTS_PER_DAY);
HebrewDate.PARTS_PER_CYCLE = (HebrewDate.MONTHS_PER_CYCLE * HebrewDate.PARTS_PER_MONTH);
HebrewDate.DAYS_PER_CYCLE = Math.floor(HebrewDate.PARTS_PER_CYCLE / HebrewDate.PARTS_PER_DAY);
HebrewDate.CREATION_DOW = 2;
HebrewDate.CREATION_PARTS = (5 * HebrewDate.PARTS_PER_HOUR + 204);
HebrewDate.DAYS_TIL_JESUS = 1373428;
HebrewDate.HESHVAN = 2;
HebrewDate.KISLEV = 3;
HebrewDate.ADAR = 6;
HebrewDate.ADAR_B = 13;
HebrewDate.DATEHEB_letters = [
    1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 20, 20, 30, 40, 40, 50, 50, 60, 70,
    80, 80, 90, 90, 100, 200, 300, 400
];
HebrewDate.ALEF = 'א';
HebrewDate.TAV = 'ת';
HebrewDate.DATEHEB_months_n = [
    0, 12, 24, 37, 49, 61, 74, 86, 99, 111, 123, 136, 148, 160, 173, 185, 197, 210, 222,
    235
];
HebrewDate.DATEHEB_norm_days_in_month = [
    30, 29, 30, 29, 30, 29, 30, 29, 30, 29, 30, 29, 0
];
HebrewDate.DATEHEB_leap_days_in_month = [
    30, 29, 30, 29, 30, 30, 29, 30, 29, 30, 29, 30, 29
];
HebrewDate.MONTH_LEN = 5;
HebrewDate._localMonths = new Array(15);
HebrewDate.DOW_LEN = 5;
HebrewDate._localDows = new Array(8);
//# sourceMappingURL=data:application/json;base64,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