import { Base64, HelpType, XMLConstants, XmlParser } from "@magic-xpa/utils";
import { Encoding, NNumber, List, NString } from "@magic-xpa/mscorelib";
import { Events } from "../../Events";
export class MagicHelp {
}
export class InternalHelp extends MagicHelp {
    GetHelpType() {
        return HelpType.Internal;
    }
    constructor() {
        super();
        this.val = null;
        this.Name = null;
        this.FrameX = 0;
        this.FrameY = 0;
        this.FrameDx = 0;
        this.FrameDy = 0;
        this.SizedX = 0;
        this.SizedY = 0;
        this.FactorX = 0;
        this.FactorY = 0;
        this.Borderstyle = 0;
        this.TitleBar = 0;
        this.FontTableIndex = 0;
    }
}
export class PromptpHelp extends MagicHelp {
    GetHelpType() {
        return HelpType.Prompt;
    }
    constructor() {
        super();
        this.PromptHelpText = null;
    }
}
export class ToolTipHelp extends MagicHelp {
    GetHelpType() {
        return HelpType.Tooltip;
    }
    constructor() {
        super();
        this.tooltipHelpText = null;
    }
}
export class URLHelp extends MagicHelp {
    GetHelpType() {
        return HelpType.URL;
    }
    constructor() {
        super();
        this.urlHelpText = null;
    }
}
export class WindowsHelp extends MagicHelp {
    GetHelpType() {
        return HelpType.Windows;
    }
    constructor() {
        super();
        this.FilePath = null;
        this.HelpCommand = 0;
        this.HelpKey = null;
    }
}
export class Helps {
    constructor() {
        this._helps = null;
        this._helps = new List();
    }
    fillData(parser) {
        while (this.initInnerObjects(parser.getNextTag(), parser)) {
        }
    }
    initInnerObjects(foundTagName, parser) {
        if (foundTagName === null)
            return false;
        if (foundTagName === XMLConstants.MG_TAG_HELPTABLE) {
            let currrentIndex = parser.getCurrIndex();
            let encoded = parser.ReadContentOfCurrentElement().trim();
            let decoded = Base64.decode(encoded.substr(0, encoded.length).trim(), Encoding.UTF8);
            let newXmlData = parser.getXMLdata().replace(encoded.trim(), decoded);
            parser.setXMLdata(newXmlData);
            parser.setCurrIndex(currrentIndex);
            parser.setCurrIndex(parser.getXMLdata().indexOf(XMLConstants.TAG_CLOSE, parser.getCurrIndex()) +
                1);
        }
        else if (foundTagName === XMLConstants.MG_TAG_HELPITEM) {
            let endContext = parser.getXMLdata().indexOf(XMLConstants.TAG_TERM, parser.getCurrIndex());
            if (endContext !== -1 && endContext < parser.getXMLdata().length) {
                let tag = parser.getXMLsubstring(endContext);
                parser.add2CurrIndex(tag.indexOf(XMLConstants.MG_TAG_HELPITEM) +
                    XMLConstants.MG_TAG_HELPITEM.length);
                let tokensVector = XmlParser.getTokens(parser.getXMLsubstring(endContext), XMLConstants.XML_ATTR_DELIM);
                this.fillHelpItem(tokensVector);
                parser.setCurrIndex(endContext + XMLConstants.TAG_TERM.length);
                return true;
            }
        }
        else if (foundTagName === "/" + XMLConstants.MG_TAG_HELPTABLE) {
            parser.setCurrIndex2EndOfTag();
            return false;
        }
        else {
            Events.WriteExceptionToLog("in Command.FillData() out of string bounds");
            return false;
        }
        return true;
    }
    fillHelpItem(tokensVector) {
        let j = 0;
        let attribute = tokensVector.get_Item(j);
        let valueStr = tokensVector.get_Item(j + 1);
        let hlpType = XmlParser.unescape(valueStr).toString();
        switch (hlpType) {
            case XMLConstants.MG_ATTR_HLP_TYP_TOOLTIP:
                let toolTipHelp = new ToolTipHelp();
                for (j = 2; j < tokensVector.length; j = j + 2) {
                    attribute = tokensVector.get_Item(j);
                    valueStr = tokensVector.get_Item(j + 1);
                    if (attribute === XMLConstants.MG_ATTR_VALUE) {
                        toolTipHelp.tooltipHelpText = XmlParser.unescape(valueStr).toString();
                    }
                    else
                        Events.WriteExceptionToLog(NString.Format("There is no such tag in <helptable><helpitem ..>.Insert case to HelpTable.FillHelpItem for {0}", attribute));
                }
                this._helps.push(toolTipHelp);
                break;
            case XMLConstants.MG_ATTR_HLP_TYP_PROMPT:
                let promptpHelp = new PromptpHelp();
                for (j = 2; j < tokensVector.length; j = j + 2) {
                    attribute = tokensVector.get_Item(j);
                    valueStr = tokensVector.get_Item(j + 1);
                    if (attribute === XMLConstants.MG_ATTR_VALUE) {
                        promptpHelp.PromptHelpText = XmlParser.unescape(valueStr).toString();
                    }
                    else
                        Events.WriteExceptionToLog(NString.Format("There is no such tag in <helptable><helpitem ..>.Insert case to HelpTable.FillHelpItem for {0}", attribute));
                }
                this._helps.push(promptpHelp);
                break;
            case XMLConstants.MG_ATTR_HLP_TYP_URL:
                let urlHelp = new URLHelp();
                for (j = 2; j < tokensVector.length; j = j + 2) {
                    attribute = tokensVector.get_Item(j);
                    valueStr = tokensVector.get_Item(j + 1);
                    if (attribute === XMLConstants.MG_ATTR_VALUE)
                        urlHelp.urlHelpText = valueStr;
                    else
                        Events.WriteExceptionToLog(NString.Format("There is no such tag in <helptable><helpitem ..>.Insert case to HelpTable.FillHelpItem for {0}", attribute));
                }
                this._helps.push(urlHelp);
                break;
            case XMLConstants.MG_ATTR_HLP_TYP_INTERNAL:
                let internalHelpWindowDetails = new InternalHelp();
                for (j = 2; j < tokensVector.length; j += 2) {
                    attribute = tokensVector.get_Item(j);
                    valueStr = tokensVector.get_Item(j + 1);
                    if (attribute === XMLConstants.MG_ATTR_VALUE) {
                        internalHelpWindowDetails.val = XmlParser.unescape(valueStr).toString();
                    }
                    else if (attribute === XMLConstants.MG_ATTR_INTERNAL_HELP_NAME) {
                        internalHelpWindowDetails.Name = XmlParser.unescape(valueStr).toString();
                    }
                    else if (attribute === XMLConstants.MG_ATTR_INTERNAL_HELP_FRAMEX) {
                        internalHelpWindowDetails.FrameX = NNumber.Parse(XmlParser.unescape(valueStr));
                    }
                    else if (attribute === XMLConstants.MG_ATTR_INTERNAL_HELP_FRAMEY) {
                        internalHelpWindowDetails.FrameY = NNumber.Parse(XmlParser.unescape(valueStr));
                    }
                    else if (attribute === XMLConstants.MG_ATTR_INTERNAL_HELP_FRAMEDX) {
                        internalHelpWindowDetails.FrameDx = NNumber.Parse(XmlParser.unescape(valueStr));
                    }
                    else if (attribute === XMLConstants.MG_ATTR_INTERNAL_HELP_FRAMEDY) {
                        internalHelpWindowDetails.FrameDy = NNumber.Parse(XmlParser.unescape(valueStr));
                    }
                    else if (attribute === XMLConstants.MG_ATTR_INTERNAL_HELP_SIZEDX) {
                        internalHelpWindowDetails.SizedX = NNumber.Parse(XmlParser.unescape(valueStr));
                    }
                    else if (attribute === XMLConstants.MG_ATTR_INTERNAL_HELP_SIZEDY) {
                        internalHelpWindowDetails.SizedY = NNumber.Parse(XmlParser.unescape(valueStr));
                    }
                    else if (attribute === XMLConstants.MG_ATTR_INTERNAL_HELP_FACTORX) {
                        internalHelpWindowDetails.FactorX = NNumber.Parse(XmlParser.unescape(valueStr));
                    }
                    else if (attribute === XMLConstants.MG_ATTR_INTERNAL_HELP_FACTORY) {
                        internalHelpWindowDetails.FactorY = NNumber.Parse(XmlParser.unescape(valueStr));
                    }
                    else if (attribute === XMLConstants.MG_ATTR_INTERNAL_HELP_BORDERSTYLE) {
                        internalHelpWindowDetails.Borderstyle = NNumber.Parse(XmlParser.unescape(valueStr));
                    }
                    else if (attribute === XMLConstants.MG_ATTR_INTERNAL_TITLE_BAR) {
                        internalHelpWindowDetails.TitleBar = NNumber.Parse(XmlParser.unescape(valueStr));
                    }
                    else if (attribute === XMLConstants.MG_ATTR_INTERNAL_HELP_SYSTEM_MENU) {
                    }
                    else if (attribute === XMLConstants.MG_ATTR_INTERNAL_HELP_FONT_TABLE_INDEX) {
                        internalHelpWindowDetails.FontTableIndex = NNumber.Parse(XmlParser.unescape(valueStr));
                    }
                    else
                        Events.WriteExceptionToLog(NString.Format("There is no such tag in <helptable><helpitem ..>.Insert case to HelpTable.FillHelpItem for {0}", attribute));
                }
                this._helps.push(internalHelpWindowDetails);
                break;
            case XMLConstants.MG_ATTR_HLP_TYP_WINDOWS:
                let wndHelpDetails = new WindowsHelp();
                for (j = 2; j < tokensVector.length; j = j + 2) {
                    attribute = tokensVector.get_Item(j);
                    valueStr = tokensVector.get_Item(j + 1);
                    if (attribute === XMLConstants.MG_ATTR_WINDOWS_HELP_FILE) {
                        wndHelpDetails.FilePath = valueStr;
                    }
                    else if (attribute === XMLConstants.MG_ATTR_WINDOWS_HELP_COMMAND) {
                        wndHelpDetails.HelpCommand = NNumber.Parse(valueStr);
                    }
                    else if (attribute === XMLConstants.MG_ATTR_WINDOWS_HELP_KEY) {
                        wndHelpDetails.HelpKey = XmlParser.unescape(valueStr).toString();
                    }
                    else
                        Events.WriteExceptionToLog(NString.Format("There is no such tag in <helptable><helpitem ..>.Insert case to HelpTable.FillHelpItem for {0}", attribute));
                }
                this._helps.push(wndHelpDetails);
                break;
        }
    }
    getHelp(idx) {
        let flag = idx < 0 || idx >= this._helps.length;
        let result;
        if (flag) {
            result = null;
        }
        else {
            result = this._helps.get_Item(idx);
        }
        return result;
    }
}
//# sourceMappingURL=data:application/json;base64,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