import { Constants, Logger_LogLevels, MgControlType, StorageAttribute, StrUtil, TabbingOrderType, WindowType, XMLConstants, XmlParser } from '@magic-xpa/utils';
import { Debug, Int32, List, NString, Stack, StringBuilder } from '@magic-xpa/mscorelib';
import { MgControlBase } from './MgControlBase';
import { PropTable } from './PropTable';
import { ControlTable } from './ControlTable';
import { Manager } from '../../Manager';
import { Events } from '../../Events';
import { Property } from './Property';
import { CommandType, HtmlProperties } from '../../GuiEnums';
import { NUM_TYPE } from '../data/NUM_TYPE';
import { Commands } from '../../Commands';
import { PropInterface } from './PropInterface';
import { GuiConstants } from '../../GuiConstants';
import { GuiFormPropertyAdapter } from './GuiFormPropertyAdapter';
const delimiter = ', ';
export class MgFormBase extends GuiFormPropertyAdapter {
    constructor() {
        super();
        this.InInitForm = false;
        this.CtrlTab = null;
        this.FormRefreshed = false;
        this.RefreshRepeatableAllowed = false;
        this.Rows = null;
        this.ModalFormsCount = 0;
        this.ErrorOccured = false;
        this.FormIsn = 0;
        this.Name = null;
        this.Opened = false;
        this.isLegalForm = false;
        this.PBImagesNumber = 0;
        this.ignoreFirstRefreshTable = false;
        this.ParentForm = null;
        this._destTblRow = Int32.MinValue;
        this._firstTableTabOrder = 0;
        this._inRefreshDisp = false;
        this._inRestore = false;
        this._lastRowSent = -1;
        this._prevGuiTopIndex = -1;
        this._propTab = null;
        this._rowsInPage = 1;
        this._maxRowsInPaginatedTable = 0;
        this._subFormCtrl = null;
        this._tableMgControl = null;
        this._tableItemsCount = 0;
        this._tableRefreshed = false;
        this._task = null;
        this._topIndexUpdated = false;
        this._transferingData = false;
        this._allowedSubformRecompute = true;
        this._concreteWindowType = 0;
        this._containerCtrl = null;
        this._firstRefreshOfProps = true;
        this._prevSelIndex = -1;
        this._shouldCreateToolbar = false;
        this._tableChildren = null;
        this._tableColumns = null;
        this._userStateId = '';
        this.displayLine = 0;
        this.defaultRouterOutlet = null;
        this._propTab = new PropTable(this);
        this.CtrlTab = new ControlTable();
        this.Rows = new List();
        this._concreteWindowType = 0;
        this.ParentForm = null;
    }
    get DisplayLine() {
        return this.displayLine;
    }
    set DisplayLine(value) {
        this.displayLine = value;
    }
    get UniqueName() {
        if (this.GetComputedProperty(PropInterface.PROP_TYPE_FORM_NAME) != null)
            return this.GetComputedProperty(PropInterface.PROP_TYPE_FORM_NAME).GetComputedValue();
        else
            return null;
    }
    get TaskTag() {
        return this.getTask().getTaskTag();
    }
    get TableChildren() {
        if (this._tableChildren === null)
            this.buildTableChildren();
        return this._tableChildren;
    }
    set TableChildren(value) {
        this._tableChildren = value;
    }
    get ShouldCreateToolbar() {
        return this._shouldCreateToolbar;
    }
    get AllowedSubformRecompute() {
        return this._allowedSubformRecompute;
    }
    set AllowedSubformRecompute(value) {
        this._allowedSubformRecompute = value;
    }
    get ConcreteWindowType() {
        if (this._concreteWindowType === 0) {
            let windowType = this.GetComputedProperty(PropInterface.PROP_TYPE_WINDOW_TYPE).GetComputedValueInteger();
            if (this.ParentForm === null || windowType !== WindowType.Overlay)
                windowType = WindowType.Default;
            this._concreteWindowType = windowType;
        }
        return this._concreteWindowType;
    }
    set ConcreteWindowType(value) {
        this._concreteWindowType = value;
    }
    static ShouldPutActOnFormClose() {
        return false;
    }
    static ShouldBehaveAsModal() {
        return false;
    }
    static ConvertArrayListToString(items, isItemNumType) {
        let from = ['\\', '-', ','];
        let to = ['\\\\', '\\-', '\\,'];
        let stringBuilder = new StringBuilder();
        let nUM_TYPE;
        for (let index = 0; index < items.length; index = index + 1) {
            if (isItemNumType) {
                nUM_TYPE = new NUM_TYPE(items.get_Item(index));
                items.set_Item(index, nUM_TYPE.to_double().toString());
            }
            stringBuilder.Append(StrUtil.searchAndReplace(items.get_Item(index), from, to));
            if (index < items.length - 1)
                stringBuilder.Append(delimiter);
        }
        return stringBuilder.ToString();
    }
    UpdateModalFormsCount(mgFormBase, increase) {
        if (increase)
            this.ModalFormsCount += 1;
        else
            this.ModalFormsCount -= 1;
        Events.SetModal(mgFormBase, increase);
    }
    async EvaluateExpression(expId, resType, length, contentTypeUnicode, resCellType, alwaysEvaluate, wasEvaluated) {
        return await this._task.EvaluateExpression(expId, resType, length, contentTypeUnicode, resCellType, true, wasEvaluated);
    }
    GetExpressionStorage(expId) {
        return this._task.GetExpressionStorage(expId);
    }
    checkIfExistProp(propId) {
        let exist = false;
        if (this._propTab !== null) {
            let propById = this._propTab.getPropById(propId);
            exist = (propById !== null);
        }
        return exist;
    }
    getProp(propId) {
        let prop = null;
        if (this._propTab !== null) {
            prop = this._propTab.getPropById(propId);
            if (prop === null) {
                prop = Property.getDefaultProp(propId, GuiConstants.PARENT_TYPE_FORM, this);
                if (prop !== null)
                    this._propTab.addProp(prop);
            }
        }
        return prop;
    }
    GetComputedProperty(propId) {
        let prop = null;
        if (this._propTab !== null)
            prop = this._propTab.getPropById(propId);
        return prop;
    }
    PropertyHasExpression(propId) {
        let prop = this._propTab.getPropById(propId);
        return prop !== null && prop.isExpression();
    }
    getCompIdx() {
        return (this.getTask() === null) ? 0 : this.getTask().getCompIdx();
    }
    IsFirstRefreshOfProps() {
        return this._firstRefreshOfProps;
    }
    getForm() {
        return this;
    }
    fillData(taskRef) {
        let parser = Manager.GetCurrentRuntimeContext().Parser;
        if (this._task === null && taskRef !== null)
            this._task = taskRef;
        while (this.initInnerObjects(parser.getNextTag())) {
        }
    }
    init() {
        for (let i = 0; i < this.CtrlTab.getSize(); i = i + 1) {
            let ctrl = this.CtrlTab.getCtrl(i);
            ctrl.Init();
        }
        this.buildLinkedControlsLists();
        this.buildTableColumnsList();
        this.createForm();
        this._task.setKeyboardMappingState(Constants.ACT_STT_TBL_SCREEN_MODE, this.isScreenMode());
        this._task.setKeyboardMappingState(Constants.ACT_STT_TBL_LEFT_TO_RIGHT, !this.GetComputedProperty(PropInterface.PROP_TYPE_HEBREW).GetComputedValueBoolean());
    }
    fillName(formTag) {
        let parser = Manager.GetCurrentRuntimeContext().Parser;
        let endContext = parser.getXMLdata().indexOf(XMLConstants.TAG_CLOSE, parser.getCurrIndex());
        if (endContext !== -1 && endContext < parser.getXMLdata().length) {
            let tag = parser.getXMLsubstring(endContext);
            parser.add2CurrIndex(tag.indexOf(formTag) + formTag.length);
            let tokensVector = XmlParser.getTokens(parser.getXMLsubstring(endContext), XMLConstants.XML_ATTR_DELIM);
            let attribute;
            let valueStr;
            for (let i = 0; i < tokensVector.length; i = i + 2) {
                attribute = tokensVector.get_Item(i);
                valueStr = tokensVector.get_Item(i + 1);
                switch (attribute) {
                    case XMLConstants.MG_ATTR_NAME:
                        this.Name = XmlParser.unescape(valueStr).toString();
                        if (Events.ShouldLog(Logger_LogLevels.Gui))
                            Events.WriteGuiToLog(NString.Format('Parsing form "{0}"', this.Name));
                        break;
                    case XMLConstants.MG_ATTR_IS_FRAMESET:
                        break;
                    case XMLConstants.MG_ATTR_IS_LIGAL_RC_FORM:
                        this.isLegalForm = XmlParser.getBoolean(valueStr);
                        break;
                    case XMLConstants.MG_ATTR_PB_IMAGES_NUMBER:
                        this.PBImagesNumber = XmlParser.getInt(valueStr);
                        break;
                    case XMLConstants.MG_ATTR_FORM_ISN:
                        this.FormIsn = XmlParser.getInt(valueStr);
                        break;
                    case XMLConstants.MG_ATTR_USERSTATE_ID:
                        this._userStateId = XmlParser.unescape(valueStr).toString();
                        break;
                    default:
                        Events.WriteExceptionToLog(NString.Format('Unhandled attribute \'{0}\'.', attribute));
                        break;
                }
            }
            parser.setCurrIndex(endContext + 1);
            return;
        }
        Events.WriteExceptionToLog('in Form.FillName() out of bounds');
    }
    createForm() {
        let inputControls = this.GetListOfInputControls();
        let formName = this.buildFormName();
        if (!this.isSubForm()) {
            Commands.addOpenForm(this, formName, '0', this.getTask().getTaskTag(), inputControls, this.isDialog());
        }
        else {
            Commands.addOpensubform(CommandType.CREATE_SUB_FORM, this.getSubFormCtrl(), this.getTask().getTaskTag(), this.getSubFormCtrl().getName(), formName, inputControls, this.getTask().RouterPath, this.getTask().GetRouterParams(), this.getTask().InDefaultRouterOutlet);
        }
        if (this.HasTable())
            this.InitTableControl();
        Commands.beginInvoke();
    }
    async CallJS(methodName, args) {
        return Commands.addCallJS(this, this.UniqueName, methodName, args);
    }
    isAutomaticTabbingOrder() {
        return this.GetComputedProperty(PropInterface.PROP_TYPE_TABBING_ORDER).GetComputedValueInteger() === TabbingOrderType.Automatically;
    }
    isRefreshRepeatableAllowed() {
        return this.RefreshRepeatableAllowed;
    }
    isScreenMode() {
        return !this.isLineMode();
    }
    isLineMode() {
        return this.getMainControl() !== null;
    }
    hasTable() {
        return this._tableMgControl !== null;
    }
    isDialog() {
        let isDialog = false;
        let windowType = this.ConcreteWindowType;
        if (windowType === WindowType.Overlay)
            isDialog = true;
        else if (MgFormBase.ShouldBehaveAsModal())
            isDialog = true;
        return isDialog;
    }
    isSubForm() {
        return this._subFormCtrl !== null;
    }
    HasTable() {
        return this._tableMgControl !== null;
    }
    getTopMostForm() {
        let topMostForm = this;
        while (topMostForm.isSubForm() && topMostForm.ParentForm !== null)
            topMostForm = topMostForm.ParentForm;
        return topMostForm;
    }
    getTopMostFrameForm() {
        let topMostForm = this;
        while (topMostForm !== null)
            topMostForm = ((topMostForm.ParentForm !== null) ? topMostForm.ParentForm : null);
        return topMostForm;
    }
    getSubFormCtrl() {
        return this._subFormCtrl;
    }
    getCtrl(ctrlIdx) {
        return this.CtrlTab.getCtrl(ctrlIdx);
    }
    GetCtrl(ctrlName) {
        return this.CtrlTab.getCtrl(ctrlName);
    }
    get DefaultRouterOutlet() {
        if (this.defaultRouterOutlet == null) {
            this.defaultRouterOutlet = this.CtrlTab.GetControl((x) => {
                return x.IsDefaultRouterOutlet();
            });
        }
        return this.defaultRouterOutlet;
    }
    async GetChoiceControlItemList(mgControl) {
        Debug.Assert(mgControl.isChoiceControl());
        let items = new List();
        let fld = mgControl.getField();
        let storageAttribute = fld.getCellsType();
        if (storageAttribute !== StorageAttribute.DATE && storageAttribute !== StorageAttribute.TIME) {
            if (mgControl.isRadio()) {
                for (let i = 0; i < fld.GetRadioCtrls().length; i++) {
                    let radioControl = fld.GetRadioCtrls().get_Item(i);
                    items.AddRange(await radioControl.GetItemsRange());
                }
            }
            else {
                items.AddRange(await mgControl.GetItemsRange());
            }
            return MgFormBase.ConvertArrayListToString(items, storageAttribute === StorageAttribute.NUMERIC);
        }
        return NString.Empty;
    }
    async GetChoiceControlDisplayList(mgControl) {
        Debug.Assert(mgControl.isChoiceControl());
        let items = new List();
        let fld = mgControl.getField();
        let storageAttribute = fld.getCellsType();
        if (storageAttribute !== StorageAttribute.DATE && storageAttribute !== StorageAttribute.TIME) {
            if (mgControl.isRadio()) {
                for (let i = 0; i < fld.GetRadioCtrls().length; i++) {
                    let radioControl = fld.GetRadioCtrls().get_Item(i);
                    items.AddRange(await radioControl.GetDisplayRange());
                }
            }
            else {
                items.AddRange(await mgControl.GetDisplayRange());
            }
            return MgFormBase.ConvertArrayListToString(items, false);
        }
        return NString.Empty;
    }
    getControlColumn(ctrl) {
        let column = null;
        if ((ctrl.IsRepeatable || ctrl.IsTableHeaderChild) && this._tableColumns !== null)
            column = this._tableColumns.get_Item(ctrl.getLayer() - 1);
        return column;
    }
    getContainerCtrl() {
        return this._containerCtrl;
    }
    getColumnControls() {
        let columnControlsList = null;
        if (this.CtrlTab !== null) {
            for (let i = 0; i < this.CtrlTab.getSize(); i = i + 1) {
                let ctrl = this.CtrlTab.getCtrl(i);
                if (ctrl.Type === MgControlType.CTRL_TYPE_COLUMN) {
                    if (columnControlsList === null)
                        columnControlsList = new List();
                    columnControlsList.push(ctrl);
                }
            }
        }
        return columnControlsList;
    }
    getTask() {
        return this._task;
    }
    getTableCtrl() {
        return this._tableMgControl;
    }
    getMainControl() {
        return this._tableMgControl;
    }
    getCtrlByName(ctrlName, ctrlType) {
        return this.CtrlTab.getCtrlByName(ctrlName, ctrlType);
    }
    checkAndCreateRow(idx) {
        if (this._tableMgControl !== null && !this.isRowCreated(idx))
            this.createRow(idx);
    }
    IsValidRow(idx) {
        let validRow = false;
        if (this._tableMgControl !== null && idx >= 0 && idx < this.Rows.length) {
            let row = this.Rows.get_Item(idx);
            validRow = (row !== null && row.Validated);
        }
        return validRow;
    }
    async refreshProps() {
        if (this._firstRefreshOfProps) {
            this.getProp(PropInterface.PROP_TYPE_TITLE_BAR);
        }
        await this._propTab.RefreshDisplay(false, false);
        if (this._firstRefreshOfProps)
            this._firstRefreshOfProps = false;
    }
    async refreshControls(repeatableOnly) {
        let ctrl;
        if (this.DisplayLine === Int32.MinValue)
            return;
        if (this._tableMgControl !== null && !repeatableOnly)
            await this._tableMgControl.RefreshDisplay();
        if (this._tableColumns !== null && !repeatableOnly) {
            for (let i = 0; i < this._tableColumns.length; i = i + 1) {
                let mgControlBase = this._tableColumns.get_Item(i);
                await mgControlBase.RefreshDisplay();
            }
        }
        this.checkAndCreateRow(this.DisplayLine);
        let tabAndGroupControls = new Stack();
        for (let i = 0; i < this.CtrlTab.getSize(); i = i + 1) {
            ctrl = this.CtrlTab.getCtrl(i);
            if ((ctrl.isTabControl() || ctrl.isGroup()) && !repeatableOnly) {
                tabAndGroupControls.push(ctrl);
            }
            if (ctrl.Type !== MgControlType.CTRL_TYPE_TABLE && ctrl.Type !== MgControlType.CTRL_TYPE_COLUMN) {
                if (ctrl.IsRepeatable || !repeatableOnly)
                    await ctrl.RefreshDisplay();
            }
            else if (ctrl.Type === MgControlType.CTRL_TYPE_TABLE && repeatableOnly)
                await ctrl.RefreshDisplay(repeatableOnly);
        }
    }
    markRowNOTCreated(idx) {
        Commands.addWithNumber(CommandType.UNDO_CREATE_TABLE_ROW, this._tableMgControl, idx);
        if (idx >= 0 && idx < this.Rows.length)
            this.Rows.set_Item(idx, new Row(false, false));
    }
    SelectRow() {
        this.SelectRowByIdx(this.DisplayLine);
    }
    getRowsInPage() {
        return this._rowsInPage;
    }
    getMaxRowsInPaginatedTable() {
        return this._maxRowsInPaginatedTable;
    }
    setRowsInPage(size) {
        this._rowsInPage = size;
    }
    getColumnsCount() {
        let columnsCount = 0;
        if (this.CtrlTab !== null) {
            for (let i = 0; i < this.CtrlTab.getSize(); i = i + 1) {
                let control = this.CtrlTab.getCtrl(i);
                if (control.Type === MgControlType.CTRL_TYPE_COLUMN)
                    columnsCount = columnsCount + 1;
            }
        }
        return columnsCount;
    }
    inRefreshDisplay() {
        return this._inRefreshDisp;
    }
    setTitle(newTitle) {
        Commands.setTitle(this, newTitle);
    }
    getControlIdx(ctrl) {
        return this.CtrlTab.getControlIdx(ctrl, true);
    }
    getTopIndexFromGUI() {
        let topDisplayLine = 0;
        if (this.hasTable())
            topDisplayLine = Commands.getTopIndex(this.getMainControl());
        return topDisplayLine;
    }
    getTableItemsCount() {
        return this._tableItemsCount;
    }
    removeRefsToCtrls() {
        for (let i = 0; i < this.CtrlTab.getSize(); i = i + 1) {
            this.CtrlTab.getCtrl(i).removeRefFromField();
        }
    }
    buildTableChildren() {
        if (this._tableChildren === null) {
            this._tableChildren = new List();
            if (this.CtrlTab !== null) {
                let minTabOrder = 2147483647;
                let automaticTabbingOrder = this.isAutomaticTabbingOrder();
                for (let i = 0; i < this.CtrlTab.getSize(); i = i + 1) {
                    let ctrl = this.CtrlTab.getCtrl(i);
                    if (ctrl.IsRepeatable || ctrl.IsTableHeaderChild) {
                        this._tableChildren.push(ctrl);
                        if (automaticTabbingOrder) {
                            let prop = ctrl.GetComputedProperty(PropInterface.PROP_TYPE_TAB_ORDER);
                            if (prop !== null) {
                                let valueInt = prop.GetComputedValueInteger();
                                if (valueInt < minTabOrder)
                                    minTabOrder = valueInt;
                            }
                        }
                    }
                }
                if (minTabOrder !== Int32.MaxValue && automaticTabbingOrder) {
                    this._firstTableTabOrder = minTabOrder;
                }
            }
        }
    }
    setTableCtrl(tableCtrl) {
        this._tableMgControl = tableCtrl;
    }
    getCtrlCount() {
        return this.CtrlTab.getSize();
    }
    GetControlsCountExcludingStatusBar() {
        return this.CtrlTab.getSize();
    }
    async refreshPropsOnExpression() {
        let i;
        let size = (this._propTab == null ? 0 : this._propTab.getSize());
        let prop;
        let refresh = false;
        for (i = 0; i < size && !refresh; i++) {
            prop = this._propTab.getProp(i);
            if (prop.isExpression()) {
                refresh = true;
                await this.refreshProps();
            }
        }
    }
    getTabControl(ctrl) {
        let obj;
        let result = null;
        obj = ctrl;
        while (obj instanceof MgControlBase) {
            let currCtrl = obj;
            if (currCtrl.isTabControl()) {
                result = currCtrl;
                break;
            }
            obj = currCtrl.getParent();
        }
        if (result == null) {
            for (let i = 0; i < this.CtrlTab.getSize(); i++) {
                obj = this.CtrlTab.getCtrl(i);
                if (obj.isTabControl()) {
                    result = obj;
                    break;
                }
            }
        }
        return result;
    }
    IsInputType(ctrl) {
        switch (ctrl.Type) {
            case MgControlType.CTRL_TYPE_CHECKBOX:
            case MgControlType.CTRL_TYPE_TEXT:
            case MgControlType.CTRL_TYPE_COMBO:
            case MgControlType.CTRL_TYPE_LIST:
            case MgControlType.CTRL_TYPE_RADIO:
                return true;
            default:
                return false;
        }
    }
    GetListOfInputControls() {
        let filterterList = this.CtrlTab.filter(((c) => this.IsInputType(c)));
        let names = filterterList.reduce((pre, ctrl) => {
            pre[ctrl.UniqueName] = ctrl.IsRepeatable ? '1' : '0';
            return pre;
        }, {});
        return names;
    }
    firstTableRefresh() {
        if (this._tableMgControl !== null) {
            this._rowsInPage = Commands.getRowsInPage(this._tableMgControl);
            this.RefreshRepeatableAllowed = true;
        }
    }
    SetTableItemsCount(dvsize, tableItemsCountOrRemoveAll, removeAll) {
        if (typeof tableItemsCountOrRemoveAll == 'boolean') {
            this.SetTableItemsCount_0(dvsize, tableItemsCountOrRemoveAll);
        }
        else
            this.SetTableItemsCount_1(dvsize, tableItemsCountOrRemoveAll, removeAll);
    }
    SetTableItemsCount_0(dvsize, removeAll) {
        this.SetTableItemsCount_1(dvsize, dvsize, removeAll);
    }
    SetTableItemsCount_1(dvsize, tableItemsCount, removeAll) {
        this.InitTableControl(dvsize, tableItemsCount, removeAll);
    }
    InitTableControl(dvSize, tableItemsCount, removeAll) {
        if (arguments.length === 0) {
            this.InitTableControl_0();
            return;
        }
        this.InitTableControl_1(dvSize, tableItemsCount);
    }
    UpdateTableChildrenArraysSize(size) {
        let children = this.TableChildren;
        if (children != null) {
            for (let i = 0; i < children.length; i++) {
                let control = children.get_Item(i);
                control.updateArrays(size);
            }
        }
        if (this._tableMgControl != null)
            this._tableMgControl.updateArrays(size);
    }
    toString() {
        return '{GuiMgForm' + ': Id=' + this._userStateId + '}';
    }
    IncludeControlInTabbingOrder(control) {
        if (!control.PropertyExists(PropInterface.PROP_TYPE_TAB_ORDER))
            return false;
        return true;
    }
    GetHashCode() {
        return this.FormIsn;
    }
    initInnerObjects(foundTagName) {
        if (foundTagName === null)
            return false;
        let parser = Manager.GetCurrentRuntimeContext().Parser;
        if (MgFormBase.IsFormTag(foundTagName))
            this.fillName(foundTagName);
        else if (foundTagName === XMLConstants.MG_TAG_PROP)
            this._propTab.fillData(this, 'F', parser);
        else if (foundTagName === XMLConstants.MG_TAG_CONTROL) {
            this.CtrlTab.fillData(this, parser);
            if (!this.HasTable())
                this.RefreshRepeatableAllowed = true;
        }
        else if (MgFormBase.IsEndFormTag(foundTagName)) {
            parser.setCurrIndex2EndOfTag();
            return false;
        }
        else
            return false;
        return true;
    }
    isRowCreated(idx) {
        if (this.Rows.length <= idx || idx < 0) {
            return false;
        }
        let row = this.Rows.get_Item(idx);
        if (row === null)
            return false;
        return row.Created;
    }
    buildLinkedControlsLists() {
        for (let i = 0; i < this.CtrlTab.getSize(); i = i + 1) {
            let ctrl = this.CtrlTab.getCtrl(i);
            let linkedParent = ctrl.getLinkedParent(false);
            if (linkedParent !== null)
                linkedParent.linkCtrl(ctrl);
        }
    }
    buildTableColumnsList() {
        if (this._tableMgControl !== null) {
            this._tableColumns = new List();
            for (let i = 0; i < this.CtrlTab.getSize(); i = i + 1) {
                let control = this.CtrlTab.getCtrl(i);
                if (control.Type === MgControlType.CTRL_TYPE_COLUMN)
                    this._tableColumns.push(control);
            }
        }
    }
    createRow(idx) {
        Commands.addWithNumber(CommandType.CREATE_TABLE_ROW, this._tableMgControl, idx);
        if (this.Rows.length <= idx)
            this.Rows.SetSize(idx + 1);
        this.Rows.set_Item(idx, new Row(true, true));
    }
    SelectRowByIdx(rowIdx) {
        let mainControl = this.getMainControl();
        if (mainControl !== null && this.RefreshRepeatableAllowed) {
            let index = rowIdx;
            if (this._task.DataView.isEmptyDataview())
                index = GuiConstants.NO_ROW_SELECTED;
            if (index !== this._prevSelIndex) {
                this._prevSelIndex = index;
                Commands.addOperationWithLine(CommandType.SET_PROPERTY, mainControl, 0, HtmlProperties.SelectedRow, index);
            }
        }
    }
    InitTableControl_0() {
        this.InitTableControl(1, 1, false);
    }
    InitTableControl_1(dvSize, tableItemsCount) {
        if (this._tableMgControl != null) {
            Commands.addWithNumber(CommandType.SET_TABLE_ITEMS_COUNT, this._tableMgControl, tableItemsCount);
            Commands.addWithNumber(CommandType.SET_CHUNK_SIZE, this._tableMgControl, (this._task.DataView).getChunkSize());
            this._tableItemsCount = tableItemsCount;
            this.Rows.SetSize(dvSize);
            this._prevGuiTopIndex = -2;
            this._prevSelIndex = -2;
            this.UpdateTableChildrenArraysSize(dvSize);
            this._maxRowsInPaginatedTable = Commands.getMaxRowsInPaginatedTable(this._tableMgControl);
        }
    }
    InsertTableChildrenArrays(idx, count) {
        let children = this.TableChildren;
        if (children != null) {
            for (let i = 0; i < children.length; i++) {
                let control = children[i];
                control.InsertArrays(idx, count);
            }
        }
    }
}
export class Row {
    constructor(created, validated) {
        this.Created = false;
        this.Validated = false;
        if (arguments.length === 0) {
            this.constructor_0();
            return;
        }
        this.constructor_1(created, validated);
    }
    constructor_0() {
        this.Validated = true;
    }
    constructor_1(created, validated) {
        this.Created = created;
        this.Validated = validated;
    }
}
//# sourceMappingURL=data:application/json;base64,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