import { MsgInterface, PICInterface, StorageAttribute, UtilImeJpn, UtilStrByteMode } from '@magic-xpa/utils';
import { Events } from '../../Events';
import { ApplicationException, Int32, NString, StringBuilder } from '@magic-xpa/mscorelib';
import { GuiEnvironment } from '../../GuiEnvironment';
export class PIC {
    constructor(picStr, attr, compIdx) {
        this._mskLen = 0;
        this._negPref = new StringBuilder();
        this._negSuff = new StringBuilder();
        this._picAttr = StorageAttribute.NONE;
        this._posPref = new StringBuilder();
        this._posSuff = new StringBuilder();
        this._autoSkip_ = false;
        this._padFill = false;
        this._zeroFill = false;
        this._comma = false;
        this._decimalDigits = 0;
        this._decPointIsFirst = false;
        this._decimal = false;
        this._embeded = false;
        this._formatIdx = 0;
        this._format = null;
        this.hebrew = false;
        this._imeMode = -1;
        this._left = false;
        this._maskLength = 0;
        this._maskChars = 0;
        this._maskSize = 0;
        this._mixed = false;
        this._formatExp = false;
        this._msk = null;
        this._needLength = false;
        this._negative = false;
        this._pad = '\0';
        this._prefLen = 0;
        this._size = 0;
        this._suffLen = 0;
        this._termFlag = false;
        this._trim = false;
        this._whole = 0;
        this._zero = '\0';
        this._picAttr = attr;
        if (this._picAttr === StorageAttribute.BLOB ||
            this._picAttr === StorageAttribute.BLOB_VECTOR) {
            if (picStr.trim().length > 0) {
                Events.WriteDevToLog("PIC.PIC the picture of BLOB must be empty string");
            }
            return;
        }
        this._format = NString.ToCharArray(picStr);
        this._formatIdx = 0;
        this._mskLen = this.getMaskLen(compIdx);
        this.prs_all(compIdx);
    }
    isHebrew() {
        return this.hebrew;
    }
    isMixed() {
        return this._mixed;
    }
    embededChars() {
        return this._embeded;
    }
    isNegative() {
        return this._negative;
    }
    withComa() {
        return this._comma;
    }
    isLeft() {
        return this._left;
    }
    padFill() {
        return this._padFill;
    }
    getPad() {
        return this._pad;
    }
    zeroFill() {
        return this._zeroFill;
    }
    getZeroPad() {
        return this._zero;
    }
    isTrimed() {
        return this._trim;
    }
    autoSkip() {
        return this._autoSkip_;
    }
    withDecimal() {
        return this._decimal;
    }
    withTerm() {
        return this._termFlag;
    }
    getMaskChars() {
        return this._maskChars;
    }
    getWholes() {
        return this._whole;
    }
    getDec() {
        return this._decimalDigits;
    }
    getSize() {
        return this._size;
    }
    getMaskSize() {
        return this._maskSize;
    }
    getMaskLength() {
        return this._maskLength;
    }
    decInFirstPos() {
        return this._decPointIsFirst;
    }
    setFormatExp(val) {
        this._formatExp = val;
    }
    isFormatExp() {
        return this._formatExp;
    }
    getPosPref_() {
        return this._posPref.ToString();
    }
    getPosSuff_() {
        return this._posSuff.ToString();
    }
    getNegPref_() {
        return this._negPref.ToString();
    }
    getNegSuff_() {
        return this._negSuff.ToString();
    }
    getMask() {
        return NString.FromChars(this._msk);
    }
    getFormat() {
        return NString.FromChars(this._format);
    }
    getAttr() {
        return this._picAttr;
    }
    setAttr(set) {
        this._picAttr == set;
    }
    getImeMode() {
        return this._imeMode;
    }
    prs_all(compIdx) {
        if (!this._needLength) {
            this._msk = new Array(this._mskLen);
            for (let _ai = 0; _ai < this._msk.length; ++_ai)
                this._msk[_ai] = '\0';
        }
        switch (this._picAttr) {
            case StorageAttribute.ALPHA:
            case StorageAttribute.UNICODE:
                this.alpha_prs();
                break;
            case StorageAttribute.NUMERIC:
                this.num_prs();
                break;
            case StorageAttribute.DATE:
                this.date_prs(compIdx);
                break;
            case StorageAttribute.TIME:
                this.time_prs();
                break;
            case StorageAttribute.BOOLEAN:
                this.bool_prs();
                break;
            case StorageAttribute.BLOB:
            case StorageAttribute.BLOB_VECTOR:
                break;
        }
    }
    alpha_prs() {
        let currChr;
        let drv;
        let count;
        while (this._formatIdx < this._format.length) {
            currChr = this._format[this._formatIdx];
            switch (currChr) {
                case 'H':
                    this._formatIdx++;
                    this.setHebrew();
                    break;
                case 'A':
                    this._autoSkip_ = true;
                    this._formatIdx++;
                    break;
                case '#':
                case 'L':
                case 'U':
                case 'X':
                    drv = 0;
                    switch (currChr) {
                        case '#':
                            drv = PICInterface.PIC_N;
                            break;
                        case 'L':
                            drv = PICInterface.PIC_L;
                            break;
                        case 'U':
                            drv = PICInterface.PIC_U;
                            break;
                        case 'X':
                            drv = PICInterface.PIC_X;
                            break;
                    }
                    this._formatIdx++;
                    count = this.pik_count();
                    this.pik_drv_fill(drv, count);
                    break;
                default:
                    if (UtilStrByteMode.isLocaleDefLangDBCS()) {
                        let useImeJpn = UtilStrByteMode.isLocaleDefLangJPN();
                        if (currChr === 'K' && useImeJpn) {
                            if (this.pic_kanji())
                                break;
                        }
                        if (GuiEnvironment.Environment.GetLocalAs400Set()) {
                            drv = 0;
                            if (currChr === 'J')
                                drv = PICInterface.PIC_J;
                            else if (currChr === 'T')
                                drv = PICInterface.PIC_T;
                            else if (currChr === 'G')
                                drv = PICInterface.PIC_G;
                            else if (currChr === 'S')
                                drv = PICInterface.PIC_S;
                            if (drv !== 0) {
                                if (this._imeMode === -1 && useImeJpn) {
                                    if (drv === PICInterface.PIC_J || drv === PICInterface.PIC_G)
                                        this._imeMode = UtilImeJpn.IME_ZEN_HIRAGANA_ROMAN;
                                    else if (drv === PICInterface.PIC_S)
                                        this._imeMode = UtilImeJpn.IME_FORCE_OFF;
                                }
                                this._formatIdx++;
                                count = this.pik_count();
                                this.pik_drv_fill(drv, count);
                                break;
                            }
                        }
                    }
                    if (UtilStrByteMode.isDigit(currChr)) {
                        count = this.pik_count();
                        this.pik_drv_fill(PICInterface.PIC_X, count);
                    }
                    else
                        this.pik_mask();
                    break;
            }
        }
        if (this._maskSize === 0)
            this.pik_drv_fill(PICInterface.PIC_X, this._mskLen);
        this._size = this._maskSize;
        if (!this._embeded)
            this._size -= this._maskChars;
    }
    num_prs() {
        let i;
        let j;
        let currChr;
        let count;
        let tmp;
        let tmps;
        let tmp_c = 0;
        let first = true;
        this._zero = ' ';
        this._pad = ' ';
        this._negPref.Append('-');
        for (i = 0; i < this._format.length; i = i + 1) {
            if (this._format[i] === '+' || this._format[i] === '-') {
                break;
            }
            if (this._format[i] === '\\' || this._format[i] === 'P') {
                i = i + 1;
            }
            if (this._format[i] === 'C') {
                this._comma = true;
            }
        }
        while (this._formatIdx < this._format.length) {
            currChr = this._format[this._formatIdx];
            switch (currChr) {
                case 'N':
                    this._formatIdx++;
                    this._negative = true;
                    break;
                case 'C':
                    this._formatIdx++;
                    this._comma = true;
                    break;
                case 'L':
                    this._formatIdx++;
                    this._left = true;
                    break;
                case 'P':
                    this._formatIdx++;
                    this._padFill = true;
                    if (this._formatIdx < this._format.length)
                        this._pad = this._format[this._formatIdx++];
                    break;
                case 'Z':
                    this._formatIdx++;
                    this._zeroFill = true;
                    if (this._formatIdx < this._format.length)
                        this._zero = this._format[this._formatIdx++];
                    break;
                case 'A':
                    this._formatIdx++;
                    this._autoSkip_ = true;
                    break;
                case '.':
                    this._formatIdx++;
                    if (this._needLength)
                        this._maskLength++;
                    this._decimal = true;
                    if (this._maskSize < this._mskLen)
                        this._msk[this._maskSize] = String.fromCharCode(PICInterface.PIC_N);
                    if (this._maskSize === 0)
                        this._decPointIsFirst = true;
                    this._maskSize++;
                    break;
                case '+':
                case '-':
                    this.pik_sign();
                    break;
                default:
                    if (UtilStrByteMode.isDigit(currChr) || currChr === '#') {
                        tmp = this._formatIdx;
                        if (currChr === '#')
                            this._formatIdx++;
                        count = this.pik_count();
                        this.pik_drv_fill(PICInterface.PIC_N, count);
                        if (this._format[tmp] === '#') {
                            if (count === 1) {
                                tmps = this._formatIdx;
                                this._formatIdx = tmp;
                                tmp_c = this.pik_dup();
                                this._formatIdx = tmps;
                            }
                            if (first && (tmp_c > 0 || count > 1)) {
                                if (count > 1)
                                    tmp_c = count;
                                if (this._comma && !this._decimal)
                                    this.pik_drv_fill(PICInterface.PIC_N, Math.floor((tmp_c - 1) / 3));
                                first = false;
                            }
                        }
                        else if (this._comma && !this._decimal)
                            this.pik_drv_fill(PICInterface.PIC_N, Math.floor((count - 1) / 3));
                        if (this._decimal)
                            this._decimalDigits += count;
                        else
                            this._whole += count;
                    }
                    else
                        this.pik_mask();
                    break;
            }
        }
        this._prefLen = this._posPref.Length;
        this._suffLen = this._posSuff.Length;
        if (this._negative) {
            if (this._negPref.Length > this._prefLen) {
                this._prefLen = this._negPref.Length;
            }
            if (this._negSuff.Length > this._suffLen) {
                this._suffLen = this._negSuff.Length;
            }
        }
        if (this._whole === 0 && this._decimalDigits === 0) {
            count = PICInterface.PIC_MAX_MSK_LEN - this._prefLen - this._suffLen;
            if (this._maskSize < count) {
                this._whole = count - this._maskSize;
                if (this._comma)
                    this._whole -= Math.floor(this._whole / 4);
                this.pik_drv_fill(PICInterface.PIC_N, this._whole);
            }
        }
        if (this._comma) {
            count = Math.floor((this._whole - 1) / 3);
            this.pik_drv_fill(PICInterface.PIC_N, count);
            this._maskSize -= count;
        }
        i = this._prefLen;
        if (i > 0 && this._msk != null) {
            if ((this._maskSize + i) <= this._mskLen) {
                for (j = this._maskSize - 1; j >= 0; j--)
                    this._msk[j + i] = this._msk[j];
                for (j = 0; j < i; j++)
                    if (this._msk != null && j < this._msk.length)
                        this._msk[j] = String.fromCharCode(PICInterface.PIC_N);
            }
            this._maskSize += i;
        }
        i = this._suffLen;
        if (i > 0 && this._msk != null) {
            if (this._maskSize + this._suffLen <= this._mskLen)
                for (j = 0; j < this._suffLen; j++)
                    this._msk[this._maskSize + j] = String.fromCharCode(PICInterface.PIC_N);
            this._maskSize += i;
        }
    }
    getUnformattedNumericPic() {
        let picStr = '';
        if (this.isNegative())
            picStr = this.isNegative() ? 'N' : '';
        picStr += this.getWholes().toString();
        if (this.getDec() > 0)
            picStr += '.' + this.getDec().toString();
        if (this._zeroFill)
            picStr += 'Z';
        let newPic = new PIC(picStr, StorageAttribute.NUMERIC, 0);
        return newPic;
    }
    date_prs(compIdx) {
        let i;
        let ocr;
        let count;
        let drv = 0;
        let SwitchAndExpandDate = false;
        let SWExpandDateChecked = false;
        let currChr;
        let isJpnEraYear = false;
        this._zero = ' ';
        ocr = 0;
        if (this._format.length === 0 || this._format[0] === '\0')
            this._format = NString.ToCharArray(PIC.getDefaultDateMask(GuiEnvironment.Environment.GetDateMode(compIdx)));
        for (let j = 0; j < this._format.length; j++)
            if (this._format[j] === 'H')
                this.setHebrew();
        while (this._formatIdx < this._format.length) {
            currChr = this._format[this._formatIdx];
            switch (currChr) {
                case 'H':
                    this._formatIdx++;
                    break;
                case 'Z':
                    this._formatIdx++;
                    this._zeroFill = true;
                    if (this._formatIdx < this._format.length)
                        this._zero = this._format[this._formatIdx++];
                    break;
                case 'T':
                    this._formatIdx++;
                    this._trim = true;
                    break;
                case 'A':
                    this._formatIdx++;
                    this._autoSkip_ = true;
                    break;
                case 'L':
                    if (this.hebrew) {
                        this._formatIdx++;
                        this.pik_drv_fill(PICInterface.PIC_HL, 1);
                    }
                    else
                        this.pik_mask();
                    break;
                case 'Y':
                    count = this.pik_dup();
                    drv = 0;
                    i = count;
                    switch (count) {
                        case 1:
                            break;
                        case 2:
                            if (!this.hebrew)
                                drv = PICInterface.PIC_YY;
                            break;
                        case 4:
                            if (!this.hebrew)
                                drv = PICInterface.PIC_YYYY;
                            else
                                drv = PICInterface.PIC_HYYYYY;
                            break;
                        case 5:
                        case 6:
                            if (this.hebrew)
                                drv = PICInterface.PIC_HYYYYY;
                            break;
                    }
                    if (drv !== 0) {
                        this._formatIdx += count;
                        this.pik_drv_fill(drv, i);
                    }
                    else
                        this.pik_mask();
                    break;
                case 'M':
                    count = this.pik_dup();
                    drv = 0;
                    if (count === 2)
                        drv = PICInterface.PIC_MMD;
                    else if (count > 2) {
                        drv = PICInterface.PIC_MMM;
                        if (count > 10)
                            drv = 0;
                    }
                    if (drv !== 0) {
                        this._formatIdx += count;
                        this.pik_drv_fill(drv, count);
                    }
                    else
                        this.pik_mask();
                    break;
                case 'D':
                    count = this.pik_dup();
                    drv = 0;
                    switch (count) {
                        case 2:
                            if (!this.hebrew) {
                                drv = PICInterface.PIC_DD;
                                break;
                            }
                        case 3:
                            if (!this.hebrew)
                                drv = PICInterface.PIC_DDD;
                            else
                                drv = PICInterface.PIC_HDD;
                            break;
                        case 4:
                            if (!this.hebrew)
                                drv = PICInterface.PIC_DDDD;
                            else
                                this.pik_mask();
                            break;
                        default:
                            this.pik_mask();
                            break;
                    }
                    if (drv !== 0) {
                        this.pik_drv_fill(drv, count);
                        this._formatIdx += count;
                    }
                    break;
                case '#':
                    count = this.pik_dup();
                    if (count === 2) {
                        drv = 0;
                        ocr++;
                        if (!this.hebrew)
                            switch (GuiEnvironment.Environment.GetDateMode(compIdx)) {
                                case 'B':
                                case 'E':
                                    switch (ocr) {
                                        case 1:
                                            drv = PICInterface.PIC_DD;
                                            break;
                                        case 2:
                                            drv = PICInterface.PIC_MMD;
                                            break;
                                        case 3:
                                            drv = PICInterface.PIC_YY;
                                            break;
                                    }
                                    break;
                                case 'A':
                                    switch (ocr) {
                                        case 1:
                                            drv = PICInterface.PIC_MMD;
                                            break;
                                        case 2:
                                            drv = PICInterface.PIC_DD;
                                            break;
                                        case 3:
                                            drv = PICInterface.PIC_YY;
                                            break;
                                    }
                                    break;
                                case 'J':
                                case 'S':
                                    switch (ocr) {
                                        case 1:
                                            if (!SWExpandDateChecked) {
                                                SwitchAndExpandDate = NString.FromChars(this._format).indexOf("####") > -1;
                                                SWExpandDateChecked = true;
                                            }
                                            if (SwitchAndExpandDate)
                                                this.pik_drv_fill(PICInterface.PIC_YYYY, 4);
                                            else
                                                drv = PICInterface.PIC_YY;
                                            break;
                                        case 2:
                                            drv = PICInterface.PIC_MMD;
                                            break;
                                        case 3:
                                            drv = PICInterface.PIC_DD;
                                            break;
                                    }
                                    break;
                            }
                        if (drv !== 0)
                            this.pik_drv_fill(drv, 2);
                    }
                    else if (count === 4) {
                        drv = 0;
                        ocr++;
                        if (!this.hebrew)
                            switch (GuiEnvironment.Environment.GetDateMode(compIdx)) {
                                case 'B':
                                case 'E':
                                case 'A':
                                    if (ocr === 3)
                                        drv = PICInterface.PIC_YYYY;
                                    break;
                                case 'J':
                                case 'S':
                                    if (ocr === 1)
                                        drv = PICInterface.PIC_YYYY;
                                    else {
                                        if (!SWExpandDateChecked) {
                                            SwitchAndExpandDate = NString.FromChars(this._format).indexOf("####") > -1;
                                            SWExpandDateChecked = true;
                                        }
                                        if (SwitchAndExpandDate && ocr === 3)
                                            this.pik_drv_fill(PICInterface.PIC_DD, 2);
                                    }
                                    break;
                            }
                        if (drv !== 0)
                            this.pik_drv_fill(drv, 4);
                    }
                    this._formatIdx += count;
                    break;
                case 'W':
                    count = this.pik_dup();
                    i = count;
                    if (count === 1)
                        drv = PICInterface.PIC_W;
                    else if (this.hebrew)
                        if (count === 5)
                            drv = PICInterface.PIC_WWW;
                        else
                            i = 0;
                    else if (count > 2 && count <= 10)
                        drv = PICInterface.PIC_WWW;
                    else
                        i = 0;
                    this._formatIdx += count;
                    this.pik_drv_fill(drv, i);
                    break;
                case '/':
                    this._formatIdx++;
                    this.pik_drv_fill(GuiEnvironment.Environment.GetDate().charCodeAt(0), 1);
                    break;
                case 'S':
                    if (UtilStrByteMode.isLocaleDefLangJPN()) {
                        count = this.pik_dup();
                        i = count;
                        if (count !== 2 && count !== 4 && count !== 6)
                            i = 0;
                        drv = PICInterface.PIC_BB;
                        this._formatIdx += count;
                        this.pik_drv_fill(drv, i);
                    }
                    else {
                        this.pik_mask();
                    }
                    break;
                case 'J':
                    if (UtilStrByteMode.isLocaleDefLangJPN()) {
                        count = this.pik_dup();
                        i = count;
                        isJpnEraYear = true;
                        switch (count) {
                            case 1:
                                drv = PICInterface.PIC_JY1;
                                break;
                            case 2:
                                drv = PICInterface.PIC_JY2;
                                break;
                            case 4:
                                drv = PICInterface.PIC_JY4;
                                break;
                            default:
                                i = 0;
                                isJpnEraYear = false;
                                break;
                        }
                        this._formatIdx += count;
                        this.pik_drv_fill(drv, i);
                    }
                    else {
                        this.pik_mask();
                    }
                    break;
                default:
                    this.pik_mask();
                    break;
            }
        }
        if (!this._needLength && isJpnEraYear) {
            for (i = 0; i < this._msk.length; i++) {
                if (this._msk[i].charCodeAt(0) === PICInterface.PIC_YY)
                    this._msk[i] = String.fromCharCode(PICInterface.PIC_YJ);
                else if (this._msk[i].charCodeAt(0) === PICInterface.PIC_YYYY)
                    this._msk[i] = 'Y';
            }
        }
    }
    time_prs() {
        let drv;
        let NoFormat;
        let currChr;
        this._zero = ' ';
        if (this._format.length === 0 || this._format[0].charCodeAt(0) === 0) {
            NoFormat = "HH:MM:SS";
            if (this._mskLen < 8)
                NoFormat = NoFormat.substr(0, this._mskLen);
            this._format = NString.ToCharArray(NoFormat);
        }
        while (this._formatIdx < this._format.length) {
            currChr = this._format[this._formatIdx];
            let maskLength;
            switch (currChr) {
                case 'H':
                case 'M':
                case 'S':
                    maskLength = 2;
                    if (this._formatIdx + 1 < this._format.length && this._format[this._formatIdx] === this._format[this._formatIdx + 1]) {
                        switch (currChr) {
                            case 'H':
                                drv = PICInterface.PIC_HH;
                                break;
                            case 'M':
                                drv = PICInterface.PIC_MMT;
                                break;
                            case 'S':
                                drv = PICInterface.PIC_SS;
                                break;
                            default:
                                drv = PICInterface.NULL_CHAR;
                                break;
                        }
                        this._formatIdx += maskLength;
                        this.pik_drv_fill(drv, maskLength);
                    }
                    else
                        this.pik_mask();
                    break;
                case 'm':
                    maskLength = 3;
                    if (this._formatIdx + 2 < this._format.length &&
                        (this._format[this._formatIdx] === this._format[this._formatIdx + 1] &&
                            this._format[this._formatIdx + 1] === this._format[this._formatIdx + 2])) {
                        drv = PICInterface.PIC_MS;
                        this._formatIdx += maskLength;
                        this.pik_drv_fill(drv, maskLength);
                    }
                    else
                        this.pik_mask();
                    break;
                case ':':
                    this._formatIdx++;
                    this.pik_drv_fill(GuiEnvironment.Environment.GetTime().charCodeAt(0), 1);
                    break;
                case 'Z':
                    this._formatIdx++;
                    this._zeroFill = true;
                    if (this._formatIdx < this._format.length)
                        this._zero = this._format[this._formatIdx++];
                    break;
                case 'A':
                    this._formatIdx++;
                    this._autoSkip_ = true;
                    break;
                case 'P':
                    if (this._format[this._formatIdx + 1] === 'M') {
                        this._formatIdx += 2;
                        this.pik_drv_fill(PICInterface.PIC_PM, 2);
                    }
                    else
                        this.pik_mask();
                    break;
                default:
                    this.pik_mask();
                    break;
            }
        }
    }
    static buildPicture(type, val, compIdx, useDecimal) {
        let pic = null;
        let mask = new StringBuilder(10);
        let decimalSeparator;
        let thousands;
        let currChar;
        let counter;
        let length;
        let beforeDec;
        let afterDec;
        let decimalDelimFound;
        let isThousandsDelim;
        let isNegative;
        switch (type) {
            case StorageAttribute.NUMERIC:
                decimalSeparator = GuiEnvironment.Environment.GetDecimal();
                thousands = GuiEnvironment.Environment.GetThousands();
                beforeDec = afterDec = 0;
                decimalDelimFound = false;
                isThousandsDelim = false;
                isNegative = false;
                if (val === null || val.length === 0)
                    beforeDec = afterDec = 1;
                else {
                    length = val.length;
                    counter = 0;
                    while (counter < length) {
                        currChar = val[counter];
                        switch (currChar) {
                            case '+':
                            case '-':
                                isNegative = true;
                                break;
                            default:
                                if (useDecimal && currChar === decimalSeparator)
                                    decimalDelimFound = true;
                                else if (currChar === thousands)
                                    isThousandsDelim = true;
                                else if (decimalDelimFound)
                                    afterDec++;
                                else
                                    beforeDec++;
                                break;
                        }
                        counter++;
                    }
                    mask.Append("" + beforeDec + decimalSeparator + afterDec);
                    if (isNegative)
                        mask.Append('N');
                    if (isThousandsDelim)
                        mask.Append('C');
                }
                break;
            case StorageAttribute.DATE:
                mask.Append(this.getDefaultDateMask(GuiEnvironment.Environment.GetDateMode(compIdx)));
                break;
            case StorageAttribute.TIME:
                mask.Append("HH" + GuiEnvironment.Environment.GetTime() + "MM" + GuiEnvironment.Environment.GetTime() + "SS");
                break;
            default:
                Events.WriteDevToLog("Event.buildPicture() there is no PICTURE building for type :" + type +
                    " and value :" + val);
                return pic;
        }
        pic = new PIC(mask.ToString(), type, compIdx);
        return pic;
    }
    setHebrew() {
        if (GuiEnvironment.Environment.Language === 'H')
            this.hebrew = true;
    }
    static getDefaultDateMask(dataMode) {
        let frmt;
        switch (dataMode) {
            case 'J':
            case 'S':
                frmt = "####/##/##";
                break;
            case 'B':
            case 'E':
            case 'A':
            default:
                frmt = "##/##/####";
                break;
        }
        return frmt;
    }
    bool_prs() {
        let count;
        let currChr;
        while (this._formatIdx < this._format.length) {
            currChr = this._format[this._formatIdx];
            switch (currChr) {
                case 'H':
                    this._formatIdx++;
                    this.setHebrew();
                    break;
                case 'A':
                    this._formatIdx++;
                    this._autoSkip_ = true;
                    break;
                case 'X':
                    this._formatIdx++;
                    count = this.pik_count();
                    this.pik_drv_fill(PICInterface.PIC_X, count);
                    break;
                default:
                    if (UtilStrByteMode.isDigit(currChr)) {
                        count = this.pik_count();
                        this.pik_drv_fill(PICInterface.PIC_X, count);
                    }
                    else
                        this.pik_mask();
                    break;
            }
        }
        if (this._maskSize === 0)
            this.pik_drv_fill(PICInterface.PIC_X, this._mskLen);
    }
    pik_sign() {
        let posSign;
        let signStr;
        let currChr;
        posSign = this._format[this._formatIdx] === '+'
            ? true
            : false;
        this._formatIdx++;
        if (posSign)
            signStr = this._posPref;
        else {
            this._negPref.Remove(0, this._negPref.Length);
            signStr = this._negPref;
        }
        while (this._formatIdx < this._format.length) {
            currChr = this._format[this._formatIdx];
            switch (currChr) {
                case ';':
                    this._formatIdx++;
                    return;
                case ',':
                    this._formatIdx++;
                    if (posSign)
                        signStr = this._posSuff;
                    else
                        signStr = this._negSuff;
                    break;
                case '\\':
                    this._formatIdx++;
                    if (this._formatIdx >= this._format.length)
                        return;
                    currChr = this._format[this._formatIdx];
                default:
                    signStr.Append(currChr);
                    this._formatIdx++;
                    break;
            }
        }
    }
    pik_count() {
        let specialValNewPolicy = GuiEnvironment.Environment.GetSpecialValNewPolicy();
        let val;
        let isDigit = false;
        val = 0;
        while (this._formatIdx < this._format.length && UtilStrByteMode.isDigit(this._format[this._formatIdx])) {
            val *= 10;
            isDigit = true;
            val += this._format[this._formatIdx].charCodeAt(0) - '0'.charCodeAt(0);
            this._formatIdx++;
        }
        if (val > 32000)
            val = 32000;
        else if (val <= 0) {
            if (specialValNewPolicy && isDigit && val === 0)
                return 0;
            else
                val = 1;
        }
        if (val > Int32.MaxValue)
            throw new ApplicationException(Events.GetMessageString(MsgInterface.STR_ERR_MAX_VAR_SIZE));
        return (val);
    }
    pik_drv_fill(drv, count) {
        let MskZ;
        let i = 0;
        if (this._needLength) {
            this._maskLength += count;
            return;
        }
        MskZ = this._maskSize;
        this._maskSize += count;
        if (MskZ + count > this._mskLen)
            count = this._mskLen - MskZ;
        if (count > 0) {
            for (i = 0; i < count; i++)
                this._msk[MskZ + i] = String.fromCharCode(drv);
            return;
        }
    }
    pik_mask() {
        let currChr;
        let count;
        if (this._format[this._formatIdx] === '\\')
            this._formatIdx++;
        if (this._formatIdx < this._format.length) {
            currChr = this._format[this._formatIdx];
            this._formatIdx++;
            count = this.pik_count();
            this.pik_drv_fill(currChr.charCodeAt(0), count);
            this._maskChars += count;
        }
    }
    pik_dup() {
        let dupCount = 1;
        let c;
        let tmpIdx = this._formatIdx;
        c = this._format[tmpIdx];
        tmpIdx++;
        while (tmpIdx < this._format.length && c === this._format[tmpIdx]) {
            dupCount++;
            tmpIdx++;
        }
        return dupCount;
    }
    pic_kanji() {
        let count;
        if (this._formatIdx + 1 >= this._format.length)
            return false;
        if (!UtilStrByteMode.isDigit(this._format[this._formatIdx + 1]))
            return false;
        this._formatIdx++;
        if (this._format[this._formatIdx] === '0') {
            this._imeMode = UtilImeJpn.IME_FORCE_OFF;
            this._formatIdx++;
        }
        else {
            count = this.pik_count();
            if (1 <= count && count <= 9)
                this._imeMode = count;
        }
        return true;
    }
    getMaskLen(compIdx) {
        this._needLength = true;
        this._maskLength = 0;
        this._formatIdx = 0;
        this.prs_all(compIdx);
        if (this._picAttr === StorageAttribute.NUMERIC && (this._prefLen > 0 || this._suffLen > 0))
            this._maskLength += (this._prefLen + this._suffLen);
        this._needLength = false;
        this._formatIdx = this._maskChars = this._whole = this._decimalDigits = this._size = this._maskSize = this._prefLen = this._suffLen = 0;
        this._pad = this._zero = String.fromCharCode(0);
        this.hebrew = this._mixed = this._embeded = this._negative = this._comma = this._left = this._padFill = this._zeroFill = this._trim = this._autoSkip_ = this._decimal = this._termFlag = this._decPointIsFirst = false;
        this._posPref.Remove(0, this._posPref.Length);
        this._posSuff.Remove(0, this._posSuff.Length);
        this._negPref.Remove(0, this._negPref.Length);
        this._negSuff.Remove(0, this._negSuff.Length);
        return this._maskLength;
    }
    picIsMask(pos) {
        if (pos < 0 || pos >= this._maskLength)
            pos = 0;
        return this._msk[pos].charCodeAt(0) > PICInterface.PIC_MAX_OP;
    }
    getDirectiveLen(posOrMskPos, bufPos, buf) {
        if (arguments.length === 1)
            return this.getDirectiveLen_0(posOrMskPos);
        else
            return this.getDirectiveLen_1(posOrMskPos, bufPos, buf);
    }
    getDirectiveLen_0(pos) {
        let c = this._msk[pos];
        let num = pos;
        while (num < this._maskSize && c === this._msk[num]) {
            num = num + 1;
        }
        return num - pos;
    }
    getDirectiveLen_1(mskPos, bufPos, buf) {
        let drv = this._msk[mskPos];
        let currMskPos = mskPos;
        let currBufPos = bufPos;
        while (currMskPos < this._maskSize && drv === this._msk[currMskPos]) {
            if (currBufPos < buf.length && UtilStrByteMode.isLocaleDefLangDBCS() && this.isAttrAlphaOrDate()) {
                if (!UtilStrByteMode.isHalfWidth(buf[currBufPos++]))
                    currMskPos++;
            }
            currMskPos++;
        }
        return (currMskPos - mskPos);
    }
    validateChar(charToValidate, pos) {
        let charReturned = charToValidate;
        if (pos >= this.getMaskSize())
            return charReturned;
        while (this.picIsMask(pos))
            pos++;
        switch (this._msk[pos].charCodeAt(0)) {
            case PICInterface.PIC_U:
                charReturned = charToValidate.toUpperCase();
                break;
            case PICInterface.PIC_L:
                charReturned = charToValidate.toLowerCase();
            default:
                if (!UtilStrByteMode.isDigit(charToValidate))
                    for (let i = 0; i < PICInterface.NumDirective.length; i++)
                        if (this._msk[pos].charCodeAt(0) === PICInterface.NumDirective[i]) {
                            charReturned = this.isValidInNum(charToValidate);
                            break;
                        }
                break;
        }
        return charReturned;
    }
    isValidInNum(letter) {
        let charRet = '\0';
        let decimalChar = GuiEnvironment.Environment.GetDecimal();
        if (GuiEnvironment.Environment.CanReplaceDecimalSeparator() && this.isAttrNumeric())
            if (letter === '.')
                letter = decimalChar;
        switch (letter) {
            case ' ':
            case '-':
            case '*':
            case '+':
            case '/':
                charRet = letter;
                break;
            default:
                if (letter === decimalChar || letter === GuiEnvironment.Environment.GetThousands())
                    charRet = letter;
                break;
        }
        return charRet;
    }
    isAttrLogical() {
        return (this._picAttr === StorageAttribute.BOOLEAN);
    }
    isAttrNumeric() {
        return (this._picAttr === StorageAttribute.NUMERIC);
    }
    isAttrAlpha() {
        return (this._picAttr === StorageAttribute.ALPHA);
    }
    isAttrUnicode() {
        return (this._picAttr === StorageAttribute.UNICODE);
    }
    isAttrAlphaOrDate() {
        return (this._picAttr === StorageAttribute.ALPHA || this._picAttr === StorageAttribute.DATE);
    }
    isAttrDateOrTime() {
        return (this._picAttr === StorageAttribute.TIME || this._picAttr === StorageAttribute.DATE);
    }
    isAttrBlob() {
        return (this._picAttr === StorageAttribute.BLOB ||
            this._picAttr === StorageAttribute.BLOB_VECTOR);
    }
    isNumeric(pos) {
        return this._msk[pos] === String.fromCharCode(PICInterface.PIC_N);
    }
    isAllX() {
        return (this._msk[0] === String.fromCharCode(PICInterface.PIC_X) && this.getDirectiveLen(0) === this._maskSize);
    }
    isMaskPicEq(pos, maskPic) {
        return this._msk[pos] === String.fromCharCode(maskPic);
    }
    isValidChar_as400(charToValidate, firstChar, pos) {
        let ret = true;
        switch (this._msk[pos].charCodeAt(0)) {
            case PICInterface.PIC_J:
            case PICInterface.PIC_G:
                ret = !UtilStrByteMode.isHalfWidth(charToValidate);
                break;
            case (PICInterface.PIC_T):
                if (firstChar === '\x0000')
                    ret = true;
                else if (UtilStrByteMode.isHalfWidth(firstChar))
                    ret = UtilStrByteMode.isHalfWidth(charToValidate);
                else
                    ret = !UtilStrByteMode.isHalfWidth(charToValidate);
                break;
            case (PICInterface.PIC_S):
                ret = UtilStrByteMode.isHalfWidth(charToValidate);
                break;
            default:
                break;
        }
        return ret;
    }
    getMinimumValueLength() {
        let minLength = this.getMaskLength();
        while (minLength > 0 && !this.picIsMask(minLength - 1))
            minLength--;
        return minLength;
    }
    toString() {
        return "{Picture: " + this._format + "}";
    }
}
//# sourceMappingURL=data:application/json;base64,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