import { Debug, NString, RefParam } from "@magic-xpa/mscorelib";
import { ListboxSelectionMode, MgControlType, StorageAttribute, TransMode } from "@magic-xpa/utils";
import { PIC } from "./PIC";
import { DisplayConvertor } from "./DisplayConvertor";
import { BlobType } from "../data/BlobType";
import { PropInterface } from "./PropInterface";
import { GuiConstants } from "../../GuiConstants";
export class PropDefaults {
    static getNumericMgValue(propParent, Value) {
        let pic = new PIC("3", StorageAttribute.NUMERIC, propParent.getCompIdx());
        return DisplayConvertor.Instance.disp2mg(Value, pic, propParent.getCompIdx(), BlobType.CONTENT_TYPE_UNKNOWN);
    }
    static getDefaultValueForTask(propId, handled) {
        let val = null;
        handled.value = true;
        switch (propId) {
            case PropInterface.PROP_TYPE_TASK_PROPERTIES_ALLOW_EVENTS:
            case PropInterface.PROP_TYPE_ALLOW_LOCATE_IN_QUERY:
            case PropInterface.PROP_TYPE_PRINT_DATA:
            case PropInterface.PROP_TYPE_ALLOW_RANGE:
            case PropInterface.PROP_TYPE_ALLOW_LOCATE:
            case PropInterface.PROP_TYPE_ALLOW_SORT:
            case PropInterface.PROP_TYPE_PRELOAD_VIEW:
            case PropInterface.PROP_TYPE_TASK_PROPERTIES_ALLOW_INDEX:
                val = "1";
                break;
            case PropInterface.PROP_TYPE_CLOSE_TASKS_BY_MDI_MENU:
                val = "0";
                break;
            default:
                handled.value = false;
                break;
        }
        return val;
    }
    static getDefaultValue(propId, parentType, propParent) {
        let val = null;
        let control = null;
        if (parentType === GuiConstants.PARENT_TYPE_TASK) {
            let handled = new RefParam(false);
            val = this.getDefaultValueForTask(propId, handled);
            if (handled.value)
                return val;
        }
        switch (propId) {
            case PropInterface.PROP_TYPE_COLOR:
                val = this.getNumericMgValue(propParent, "1");
                if (parentType === GuiConstants.PARENT_TYPE_CONTROL) {
                    control = propParent;
                    if (control.Type === MgControlType.CTRL_TYPE_BUTTON && control.IsImageButton())
                        val = this.getNumericMgValue(propParent, "0");
                }
                break;
            case PropInterface.PROP_TYPE_BORDER:
                val = "0";
                if (parentType === GuiConstants.PARENT_TYPE_CONTROL) {
                    control = propParent;
                    switch (control.Type) {
                        case MgControlType.CTRL_TYPE_SUBFORM:
                            val = "0";
                            break;
                        case MgControlType.CTRL_TYPE_TEXT:
                        case MgControlType.CTRL_TYPE_TABLE:
                        case MgControlType.CTRL_TYPE_LIST:
                        case MgControlType.CTRL_TYPE_BROWSER:
                            val = "1";
                            break;
                    }
                }
                break;
            case PropInterface.PROP_TYPE_MAXBOX:
            case PropInterface.PROP_TYPE_MINBOX:
            case PropInterface.PROP_TYPE_MUST_INPUT:
            case PropInterface.PROP_TYPE_MULTILINE:
            case PropInterface.PROP_TYPE_PASSWORD:
            case PropInterface.PROP_TYPE_HEBREW:
            case PropInterface.PROP_TYPE_MULTILINE_VERTICAL_SCROLL:
            case PropInterface.PROP_TYPE_MULTILINE_ALLOW_CR:
            case PropInterface.PROP_TYPE_IS_CACHED:
            case PropInterface.PROP_TYPE_MODIFY_IN_QUERY:
            case PropInterface.PROP_TYPE_SHOW_FULL_ROW:
            case PropInterface.PROP_TYPE_TRACK_SELECTION:
            case PropInterface.PROP_TYPE_COLUMN_DIVIDER:
            case PropInterface.PROP_TYPE_LINE_DIVIDER:
            case PropInterface.PROP_TYPE_THREE_STATES:
            case PropInterface.PROP_TYPE_REFRESH_WHEN_HIDDEN:
            case PropInterface.PROP_TYPE_RETAIN_FOCUS:
            case PropInterface.PROP_TYPE_ROW_PLACEMENT:
            case PropInterface.PROP_TYPE_SHOW_IN_WINDOW_MENU:
            case PropInterface.PROP_TYPE_DATAVIEWCONTROL:
            case PropInterface.PROP_TYPE_SORT_COLUMN:
            case PropInterface.PROP_TYPE_BEFORE_900_VERSION:
            case PropInterface.PROP_TYPE_FILL_WIDTH:
            case PropInterface.PROP_TYPE_MULTI_COLUMN_DISPLAY:
            case PropInterface.PROP_TYPE_AUTO_COMPLETE_MODE_WC:
                val = "0";
                break;
            case PropInterface.PROP_TYPE_SYSTEM_MENU:
            case PropInterface.PROP_TYPE_TITLE_BAR:
            case PropInterface.PROP_TYPE_ENABLED:
            case PropInterface.PROP_TYPE_VISIBLE:
            case PropInterface.PROP_TYPE_TAB_IN:
            case PropInterface.PROP_TYPE_MODIFIABLE:
            case PropInterface.PROP_TYPE_HIGHLIGHTING:
            case PropInterface.PROP_TYPE_AUTO_REFRESH:
            case PropInterface.PROP_TYPE_PARK_ON_CLICK:
            case PropInterface.PROP_TYPE_DISPLAY_MENU:
            case PropInterface.PROP_TYPE_DISPLAY_TOOLBAR:
            case PropInterface.PROP_TYPE_SHOW_BUTTONS:
            case PropInterface.PROP_TYPE_LINES_AT_ROOT:
            case PropInterface.PROP_TYPE_SCROLL_BAR:
            case PropInterface.PROP_TYPE_SHOW_LINES:
            case PropInterface.PROP_TYPE_ALLOW_QUERY:
            case PropInterface.PROP_TYPE_RIGHT_BORDER:
            case PropInterface.PROP_TYPE_TOP_BORDER:
            case PropInterface.PROP_TYPE_TOP_BORDER_MARGIN:
            case PropInterface.PROP_TYPE_SHOW_ELLIPISIS:
                val = "1";
                break;
            case PropInterface.PROP_TYPE_TRIGGER:
            case PropInterface.PROP_TYPE_PROMPT:
            case PropInterface.PROP_TYPE_DISPLAY_LIST:
            case PropInterface.PROP_TYPE_DATA:
            case PropInterface.PROP_TYPE_IMAGE_FILENAME:
            case PropInterface.PROP_TYPE_LABEL:
            case PropInterface.PROP_TYPE_PLACEMENT:
            case PropInterface.PROP_TYPE_PULLDOWN_MENU:
            case PropInterface.PROP_TYPE_CONTEXT_MENU:
            case PropInterface.PROP_TYPE_NODE_ID:
            case PropInterface.PROP_TYPE_NODE_PARENTID:
            case PropInterface.PROP_TYPE_SELECT_PROGRAM:
            case PropInterface.PROP_TYPE_VISIBLE_LAYERS_LIST:
            case PropInterface.PROP_TYPE_EXPANDED_IMAGEIDX:
            case PropInterface.PROP_TYPE_COLLAPSED_IMAGEIDX:
            case PropInterface.PROP_TYPE_OBJECT_TYPE:
            case PropInterface.PROP_TYPE_TAB_ORDER:
            case PropInterface.PROP_TYPE_LOAD_IMAGE_FROM:
            case PropInterface.PROP_TYPE_FORM_NAME:
            case PropInterface.PROP_TYPE_COLUMN_TITLE:
            case PropInterface.PROP_TYPE_WIDTH:
            case PropInterface.PROP_TYPE_PRGTSK_NUM:
                break;
            case PropInterface.PROP_TYPE_MULTILINE_WORDWRAP_SCROLL:
            case PropInterface.PROP_TYPE_BORDER_STYLE:
                val = this.getNumericMgValue(propParent, "2");
                break;
            case PropInterface.PROP_TYPE_WINDOW_TYPE:
                val = this.getNumericMgValue(propParent, "6");
                break;
            case PropInterface.PROP_TYPE_ROW_HIGHLIGHT_STYLE:
                val = this.getNumericMgValue(propParent, "4");
                break;
            case PropInterface.PROP_TYPE_GRADIENT_STYLE:
            case PropInterface.PROP_TYPE_TABBING_ORDER:
            case PropInterface.PROP_TYPE_STARTUP_MODE:
            case PropInterface.PROP_TYPE_CHOICE_COLUMNS:
            case PropInterface.PROP_TYPE_HORIZONTAL_ALIGNMENT:
            case PropInterface.PROP_TYPE_FONT:
            case PropInterface.PROP_TYPE_WALLPAPER_STYLE:
            case PropInterface.PROP_TYPE_CHECKBOX_MAIN_STYLE:
            case PropInterface.PROP_TYPE_TAB_CONTROL_SIDE:
            case PropInterface.PROP_TYPE_RAISE_AT:
            case PropInterface.PROP_TYPE_ALLOWED_DIRECTION:
            case PropInterface.PROP_TYPE_SUBFORM_TYPE:
            case PropInterface.PROP_TYPE_UOM:
            case PropInterface.PROP_TYPE_BOTTOM_POSITION_INTERVAL:
                val = this.getNumericMgValue(propParent, "1");
                break;
            case PropInterface.PROP_TYPE_TASK_PROPERTIES_TRANSACTION_MODE:
                val = TransMode.Physical;
                break;
            case PropInterface.PROP_TYPE_PARKED_COLLAPSED_IMAGEIDX:
            case PropInterface.PROP_TYPE_PARKED_IMAGEIDX:
            case PropInterface.PROP_TYPE_MINIMUM_HEIGHT:
            case PropInterface.PROP_TYPE_TOP:
            case PropInterface.PROP_TYPE_LEFT:
            case PropInterface.PROP_TYPE_TITLE_HEIGHT:
            case PropInterface.PROP_TYPE_LAYER:
            case PropInterface.PROP_TYPE_VISIBLE_LINES:
            case PropInterface.PROP_TYPE_FRAMESET_STYLE:
            case PropInterface.PROP_TYPE_TRANSLATOR:
            case PropInterface.PROP_TYPE_HOR_FAC:
            case PropInterface.PROP_TYPE_VER_FAC:
            case PropInterface.PROP_TYPE_FOCUS_COLOR:
                val = this.getNumericMgValue(propParent, "0");
                break;
            case PropInterface.PROP_TYPE_STYLE_3D:
                if (parentType === GuiConstants.PARENT_TYPE_CONTROL) {
                    control = propParent;
                    switch (control.Type) {
                        case MgControlType.CTRL_TYPE_COMBO:
                            val = this.getNumericMgValue(propParent, "2");
                            break;
                        case MgControlType.CTRL_TYPE_RADIO:
                        case MgControlType.CTRL_TYPE_CHECKBOX:
                            val = this.getNumericMgValue(propParent, "3");
                            break;
                    }
                }
                break;
            case PropInterface.PROP_TYPE_IMAGE_LIST_INDEXES:
            case PropInterface.PROP_TYPE_WALLPAPER:
            case PropInterface.PROP_TYPE_TEXT:
            case PropInterface.PROP_TYPE_TOOLTIP:
            case PropInterface.PROP_TYPE_FORMAT:
                val = NString.Empty;
                break;
            case PropInterface.PROP_TYPE_IMAGE_STYLE:
                val = this.getNumericMgValue(propParent, "2");
                break;
            case PropInterface.PROP_TYPE_SELECTION_MODE:
                val = this.getNumericMgValue(propParent, String(ListboxSelectionMode.Single));
                break;
            case PropInterface.PROP_TYPE_INDEX:
            case PropInterface.PROP_TYPE_LINK_FIELD:
            case PropInterface.PROP_TYPE_DISPLAY_FIELD:
            case PropInterface.PROP_TYPE_PERSISTENT_FORM_STATE_VERSION:
                val = this.getNumericMgValue(propParent, "0");
                break;
            default:
                Debug.Assert(false, "Undefined default value");
                break;
        }
        return val;
    }
    static GetPropertyName(propTypeId) {
        return "{Field ID " + propTypeId + "}";
    }
}
//# sourceMappingURL=data:application/json;base64,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