import { FieldValidator } from "./FieldValidator";
import { StringBuilder, List } from "@magic-xpa/mscorelib";
import { StorageAttribute, StrUtil, PICInterface } from "@magic-xpa/utils";
import { Events } from "../../Events";
import { ValidationDetailsBase } from "./ValidationDetailsBase";
export class ValidationDetails extends ValidationDetailsBase {
    get ErrorMessage() {
        return this.errMessage;
    }
    set ErrorMessage(msg) {
        this.errMessage = msg;
    }
    get ValidationFailed() {
        return this._validationFailed;
    }
    constructor(oldvalueOrRangeStrOrVd, val, range, pic, control) {
        super();
        this._control = null;
        this._fieldValidator = null;
        this._picData = null;
        this._pictureEnable = null;
        this._pictureReal = null;
        this._isNull = false;
        this._oldvalue = null;
        this._val = null;
        this._validationFailed = false;
        this.errMessage = null;
        this.constructor_3();
        if (arguments.length === 5)
            this.constructor_0(oldvalueOrRangeStrOrVd, val, range, pic, control);
        else if (arguments.length === 1 && (oldvalueOrRangeStrOrVd === null || oldvalueOrRangeStrOrVd.constructor === String))
            this.constructor_1(oldvalueOrRangeStrOrVd);
        else if (arguments.length === 1 && (oldvalueOrRangeStrOrVd === null || oldvalueOrRangeStrOrVd instanceof ValidationDetails))
            this.constructor_2(oldvalueOrRangeStrOrVd);
    }
    constructor_0(oldvalue, val, range, pic, control) {
        this._picData = pic;
        this._oldvalue = oldvalue;
        this._val = val;
        this._range = range;
        this._control = control;
        switch (pic.getAttr()) {
            case StorageAttribute.NUMERIC:
                this._pictureReal = new StringBuilder(this._picData.getMaskSize());
                this._pictureEnable = new StringBuilder(this._picData.getMaskSize());
                this.getRealNumericPicture();
                break;
            case StorageAttribute.BOOLEAN:
                if (this._range == null)
                    this._range = "True,False";
                break;
            case StorageAttribute.DATE:
            case StorageAttribute.TIME:
            case StorageAttribute.ALPHA:
            case StorageAttribute.BLOB:
            case StorageAttribute.BLOB_VECTOR:
            case StorageAttribute.UNICODE:
                break;
            default:
                Events.WriteExceptionToLog("ValidationDetails.ValidationDetails: There is no type " +
                    this._picData.getAttr());
                break;
        }
        if (this._range != null)
            this.fillRange();
        range = null;
    }
    constructor_1(rangeStr) {
        this.constructor_3();
        this._range = rangeStr;
        if (this._range !== null)
            this.fillRange();
    }
    constructor_2(vd) {
        this.constructor_3();
        this._oldvalue = vd.getOldValue();
        this._val = vd._val;
        this._range = vd.getRange();
        this._control = vd.getControl();
        this._validationFailed = false;
        if (vd._pictureReal !== null) {
            this._pictureReal = new StringBuilder(vd._pictureReal.ToString());
        }
        if (vd._pictureEnable !== null) {
            this._pictureEnable = new StringBuilder(vd._pictureEnable.ToString());
        }
        if (vd.getDiscreteRangeValues() !== null) {
            this._discreteRangeValues = vd.CloneDiscreteRangeValues();
        }
        if (vd.getContinuousRangeValues() != null) {
            this._continuousRangeValues = vd.CloneContinuousRangeValues();
        }
        this._picData = vd.getPIC();
        this._isNull = vd.getIsNull();
    }
    constructor_3() {
        this._fieldValidator = new FieldValidator();
    }
    getRealNumericPicture() {
        let mask = this._picData.getMask();
        let dec_ = this._picData.getDec();
        let whole_ = this._picData.getWholes();
        let decimal_ = this._picData.withDecimal();
        let dec_pnt_in_first = this._picData.decInFirstPos();
        let isNegative = this._picData.isNegative();
        let isFirstPic_N = true;
        let isPointInserted = false;
        let currChar = 0;
        for (let i = 0; i < this._picData.getMaskSize(); i = i + 1) {
            currChar = +mask.charAt(i);
            switch (currChar) {
                case PICInterface.PIC_N:
                    if (isFirstPic_N) {
                        if (isNegative)
                            this.setPictures('-', '0');
                        if (dec_pnt_in_first) {
                            this.setPictures('.', '1');
                            isPointInserted = true;
                        }
                        else if (whole_ > 0) {
                            whole_--;
                            this.setPictures('#', '0');
                        }
                        isFirstPic_N = false;
                        break;
                    }
                    if (decimal_) {
                        if (whole_ > 0) {
                            whole_--;
                            this.setPictures('#', '0');
                        }
                        else if (whole_ === 0 && !isPointInserted) {
                            this.setPictures('.', '1');
                            isPointInserted = true;
                        }
                        else if (dec_ > 0) {
                            dec_--;
                            this.setPictures('#', '0');
                        }
                    }
                    else {
                        if (whole_ > 0) {
                            whole_--;
                            this.setPictures('#', '0');
                        }
                    }
                    break;
                default:
                    this.setPictures(currChar.toString(), '1');
                    break;
            }
        }
        Events.WriteDevToLog(this._pictureReal.ToString());
        Events.WriteDevToLog(this._pictureEnable.ToString());
    }
    setPictures(Real, Enable) {
        this._pictureEnable.Append(Enable);
        this._pictureReal.Append(Real);
    }
    setValue(val) {
        this._val = val;
    }
    setOldValue(oldvalue) {
        this._oldvalue = oldvalue;
    }
    setRange(range) {
        this._range = range;
    }
    setValidationFailed(val) {
        this._validationFailed = val;
    }
    setNull(isNull_) {
        this._isNull = isNull_;
    }
    getDispValue() {
        if (typeof this._val === 'string') {
            let minimumValueLength = this._picData.getMinimumValueLength();
            if (this._val.length > minimumValueLength) {
                if (minimumValueLength > 0 || StrUtil.rtrim(this._val).length > 0) {
                    let str = this._val.substr(minimumValueLength);
                    this._val = this._val.substr(0, minimumValueLength);
                    this._val = this._val + StrUtil.rtrim(str);
                }
            }
        }
        else {
            if (this._control != null && this._control.isChoiceControl())
                this._val = this._val.toString();
        }
        return this._val;
    }
    getOldValue() {
        return this._oldvalue;
    }
    getType() {
        return this._picData.getAttr();
    }
    getPictureReal() {
        return this._pictureReal.ToString();
    }
    getPictureEnable() {
        return this._pictureEnable.ToString();
    }
    getIsNegative() {
        return this._picData.isNegative();
    }
    getIsPadFill() {
        return this._picData.padFill();
    }
    getPadFillChar() {
        return this._picData.getPad();
    }
    getIsZeroFill() {
        return this._picData.zeroFill();
    }
    getZeroFillChar() {
        return this._picData.getZeroPad();
    }
    getNegativeSignPref() {
        return this._picData.getNegPref_();
    }
    getRange() {
        return this._range;
    }
    getControl() {
        return this._control;
    }
    getPIC() {
        return this._picData;
    }
    getIsNull() {
        return this._isNull;
    }
    evaluate() {
        return this._fieldValidator.checkVal(this);
    }
    CloneDiscreteRangeValues() {
        let clone = new List();
        clone.AddRange(this._discreteRangeValues.GetEnumerator());
        return clone;
    }
    CloneContinuousRangeValues() {
        let clone = new List();
        clone.AddRange(this._continuousRangeValues.GetEnumerator());
        return clone;
    }
}
//# sourceMappingURL=data:application/json;base64,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