import { Events } from "../../Events";
import { StrUtil, SEQ_2_HTML, HTML_2_STR } from "@magic-xpa/utils";
import { List, NString } from "@magic-xpa/mscorelib";
export class ValidationDetailsBase {
    constructor(rangeStr) {
        this._continuousRangeValues = null;
        this._discreteRangeValues = null;
        this._range = null;
        if (arguments.length === 1) {
            this._range = rangeStr;
            if (this._range !== null)
                this.fillRange();
        }
    }
    fillRange() {
        this._range = StrUtil.makePrintableTokens(this._range, SEQ_2_HTML);
        let from = 0;
        let prev = 0;
        while ((from = this.findDelimeter(from, ",", this._range)) !== -1 && prev < this._range.length) {
            this.rangeForms(this._range.substr(prev, from - prev));
            from = (prev = from + 1);
        }
        if (prev < this._range.length) {
            this.rangeForms(this._range.substr(prev));
        }
        if (this._discreteRangeValues != null) {
            StrUtil.makePrintableTokens(this._discreteRangeValues, HTML_2_STR);
            Events.WriteDevToLog(this._discreteRangeValues.toString());
        }
        if (this._continuousRangeValues !== null) {
            StrUtil.makePrintableTokens(this._continuousRangeValues, HTML_2_STR);
            Events.WriteDevToLog(this._continuousRangeValues.toString());
        }
    }
    rangeForms(found) {
        let minus;
        if ((minus = this.findDelimeter(0, "-", found)) === -1) {
            found = NString.TrimStart(found);
            let todel = 0;
            while (todel < found.length && (todel = this.findDelimeter(todel, "\\", found)) !== -1) {
                found = found.substr(0, todel) + found.substr(todel = todel + 1);
                todel = todel + 1;
            }
            if (this._discreteRangeValues === null)
                this._discreteRangeValues = new List();
            this._discreteRangeValues.push(found);
        }
        else {
            let val;
            for (let i = 0; i < 2; i = i + 1) {
                if (i === 0) {
                    val = found.substr(0, minus);
                }
                else {
                    minus = minus + 1;
                    while (minus < found.length && found.charAt(minus) === " ") {
                        minus = minus + 1;
                    }
                    val = found.substr(minus);
                }
                val = this.deleteChar("\\", val);
                if (this._continuousRangeValues === null) {
                    this._continuousRangeValues = new List();
                }
                this._continuousRangeValues.push(val);
            }
        }
    }
    deleteChar(stringToDelete, from) {
        let index = 0;
        while ((index = from.indexOf(stringToDelete, index)) !== -1)
            from = from.substr(0, index) + from.substr(index + stringToDelete.length);
        return from;
    }
    findDelimeter(start, delim, str) {
        let found = str.indexOf(delim, start);
        while (found < str.length && found > 0) {
            if (str.charAt(found - 1) === "\\") {
                found = str.indexOf(delim, found + 1);
            }
            else
                break;
        }
        return found;
    }
    getDiscreteRangeValues() {
        return this._discreteRangeValues;
    }
    getContinuousRangeValues() {
        return this._continuousRangeValues;
    }
}
//# sourceMappingURL=data:application/json;base64,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