import { NNumber, NotImplementedException, NString, RefParam } from "@magic-xpa/mscorelib";
import { Constants, Logger_LogLevels, XMLConstants, XmlParser } from "@magic-xpa/utils";
import { PropTable } from "../gui/PropTable";
import { Property } from "../gui/Property";
import { PropInterface } from "../gui/PropInterface";
import { Commands } from "../../Commands";
import { Events } from "../../Events";
import { GuiConstants } from "../../GuiConstants";
import { GuiDataCollection } from "./GuiDataCollection";
import { CommandType, HtmlProperties } from "../../GuiEnums";
export class GuiTaskBase {
    Init() {
        this.DataView.Init();
    }
    get RouterPath() {
        return this.routerPath;
    }
    get RouterParams() {
        return this.routeParams;
    }
    get InDefaultRouterOutlet() {
        return this.inDefaultRouterOutlet;
    }
    get IsBlockingBatch() {
        return !this._isMainPrg && this.isOpenWin() && !this._allowEvents && !this.IsInteractive;
    }
    constructor() {
        this._flowMonitor = null;
        this._keyboardMappingState = 0xFFFF0000;
        this._refreshType = "T";
        this._lastParkedCtrl = null;
        this._brkLevel = null;
        this._brkLevelIndex = -1;
        this._mainLevel = null;
        this._level = "\0";
        this._enteredRecLevel = false;
        this._currParkedFld = null;
        this.isInRecompute = false;
        this.CurrentEditingControl = null;
        this.shouldResumeSubformLayout = true;
        this.ApplicationGuid = null;
        this.ProgramIsn = 0;
        this.TaskIsn = 0;
        this.ContextID = 0;
        this.IsSubForm = false;
        this._ctlIdx = 0;
        this._compIdx = 0;
        this._isPrg = false;
        this._isMainPrg = false;
        this.IsInteractive = false;
        this._taskTag = null;
        this._openWin = false;
        this._allowEvents = false;
        this.Form = null;
        this._propTab = null;
        this._helpTab = null;
        this.IconFileName = null;
        this.IsParallel = false;
        this.DataView = null;
        this.ActionManager = null;
        this.StudioParentTask = null;
        this.routerPath = null;
        this.routeParams = null;
        this.inDefaultRouterOutlet = false;
        this.IsSubtask = false;
        this.DataViewWasRetrieved = false;
        this.TaskPrefixExecuted = false;
        this._nullArithmetic = Constants.NULL_ARITH_USE_DEF;
        this._propTab = new PropTable(this);
    }
    getTaskTag() {
        return this._taskTag;
    }
    getCtlIdx() {
        return this._ctlIdx;
    }
    isMainProg() {
        return this._isMainPrg;
    }
    getTopMostForm() {
        let form = null;
        if (this.Form !== null)
            form = this.Form.getTopMostForm();
        return form;
    }
    getCtrl(ctrlIdx) {
        return this.Form.getCtrl(ctrlIdx);
    }
    setMode(val) {
        if (this.getMode() !== val) {
            this.setProp(PropInterface.PROP_TYPE_TASK_MODE, val);
            if (this._flowMonitor !== null)
                this._flowMonitor.addTaskCngMode(val, this.GetTaskDetails());
        }
    }
    getMode() {
        let taskMode = Constants.TASK_MODE_MODIFY;
        let prop = this._propTab.getPropById(PropInterface.PROP_TYPE_TASK_MODE);
        if (prop !== null) {
            taskMode = prop.GetComputedValue();
        }
        return taskMode;
    }
    SetInRecompute(inRecompute) {
        this.isInRecompute = inRecompute;
    }
    IsInRecompute() {
        return this.isInRecompute;
    }
    resetRefreshType() {
        this._refreshType = Constants.TASK_REFRESH_NONE;
    }
    getRefreshType() {
        return this._refreshType;
    }
    SetRefreshType(refreshType) {
        switch (refreshType) {
            case Constants.TASK_REFRESH_FORM:
            case Constants.TASK_REFRESH_TABLE:
            case Constants.TASK_REFRESH_CURR_REC:
                this._refreshType = refreshType;
                break;
            default:
                break;
        }
    }
    GetRouterParams() {
        return this.routeParams;
    }
    getLastParkedCtrl() {
        return this._lastParkedCtrl;
    }
    isOpenWin() {
        return this._openWin;
    }
    async checkProp(propId, defaultRetVal) {
        let prop = this.getProp(propId);
        if (prop !== null)
            return await prop.getValueBoolean();
        return defaultRetVal;
    }
    getClickedControl() {
        let clickedCtrl = Events.GetRuntimeContext(null).CurrentClickedCtrl;
        if (clickedCtrl !== null && clickedCtrl.getForm().getTask() !== this)
            clickedCtrl = null;
        return clickedCtrl;
    }
    getKeyboardMappingState() {
        return this._keyboardMappingState;
    }
    isStateEnabled(state) {
        return (state & this._keyboardMappingState) > 0;
    }
    setKeyboardMappingState(state, on) {
        this._keyboardMappingState = on
            ? GuiTaskBase.mkInt(GuiTaskBase.hiShrt(this._keyboardMappingState) & ~state, GuiTaskBase.loShrt(this._keyboardMappingState) | state)
            : GuiTaskBase.mkInt(GuiTaskBase.hiShrt(this._keyboardMappingState) | state, GuiTaskBase.loShrt(this._keyboardMappingState) & ~state);
    }
    static hiShrt(n) {
        return (n & 0xffff0000) >> 16;
    }
    static loShrt(n) {
        return n & 0x0000ffff;
    }
    static mkInt(n1, n2) {
        return n1 << 16 | n2;
    }
    getHelpItem(idx) {
        if (this._helpTab !== null)
            return this._helpTab.getHelp(idx);
    }
    setProp(propId, val) {
        this._propTab.setProp(propId, val, this, "T");
    }
    setBrkLevel(cBrkLevel, NewBrkLevelIndex) {
        this._brkLevel = cBrkLevel;
        this._brkLevelIndex = NewBrkLevelIndex;
        this.setMainLevel(cBrkLevel);
    }
    getBrkLevel() {
        return this._brkLevel;
    }
    getBrkLevelIndex() {
        return this._brkLevelIndex;
    }
    setMainLevel(cBrkLevel) {
        if (cBrkLevel !== null && cBrkLevel.length > 0) {
            let level = cBrkLevel.charAt(0);
            if (level === Constants.TASK_LEVEL_NONE || level === Constants.TASK_LEVEL_TASK ||
                level === Constants.TASK_LEVEL_RECORD)
                this._mainLevel = cBrkLevel;
        }
    }
    getMainLevel() {
        return this._mainLevel;
    }
    setLevel(cLevel) {
        this._level = cLevel;
        if (this._level === Constants.TASK_LEVEL_RECORD)
            this._enteredRecLevel = true;
    }
    getLevel() {
        return this._level;
    }
    setDataSynced(synced) {
    }
    getNullArithmetic() {
        return this._nullArithmetic;
    }
    setLastParkedCtrl(ctrl) {
        this._lastParkedCtrl = ctrl;
        this._currParkedFld = ((this._lastParkedCtrl !== null)
            ? this._lastParkedCtrl.getField()
            : null);
        this.CurrentEditingControl = ctrl;
    }
    getCurrField() {
        return this._currParkedFld;
    }
    setCurrField(currField) {
        this._currParkedFld = currField;
    }
    getCurrFieldIdx() {
        if (this._currParkedFld !== null)
            return this._currParkedFld.getId();
        return -1;
    }
    getFieldByValueStr(valueStr, parent, vee) {
        if (arguments.length === 1)
            return this.getFieldByValueStr_0(valueStr);
        else
            return this.getFieldByValueStr_1(valueStr, parent, vee);
    }
    getFieldByValueStr_0(valueStr) {
        let parent;
        let vee;
        let refParent = new RefParam(parent);
        let refVee = new RefParam(vee);
        return this.getFieldByValueStr_1(valueStr, refParent, refVee);
    }
    getFieldByValueStr_1(valueStr, parent, vee) {
        parent.value = vee.value = 0;
        let tempField = null;
        let comma = valueStr.indexOf(",");
        if (comma > 0) {
            let parentId = NNumber.Parse(valueStr.substr(0, comma));
            let fldIdx = NNumber.Parse(valueStr.substr(comma + 1));
            tempField = ((parentId !== 0)
                ? this.getFieldDef(parentId, fldIdx)
                : this.getFieldDef(fldIdx));
            parent.value = parentId;
            vee.value = fldIdx;
        }
        return tempField;
    }
    getMainProgFieldByValueStr(valueStr) {
        let fldIdx = NNumber.Parse(valueStr) - 1;
        return this.getFieldDef(fldIdx);
    }
    getFieldDef(fldIdOrParent, fldIdx) {
        if (arguments.length === 1)
            return this.getField_0(fldIdOrParent);
        else
            return this.getField_1(fldIdOrParent, fldIdx);
    }
    getField_0(fldId) {
        return this.DataView.getField(fldId);
    }
    async InitForm() {
        if (this.Form !== null && this.isOpenWin()) {
            this.Form.InInitForm = true;
            this.Form.init();
            this.SetRefreshType(Constants.TASK_REFRESH_FORM);
            await this.RefreshDisplay();
            Commands.beginInvoke();
            this.Form.InInitForm = false;
        }
    }
    ResumeSubformLayout() {
        if (this.Form !== null) {
            let subFormCtrl = this.Form.getSubFormCtrl();
            if (subFormCtrl !== null && this.shouldResumeSubformLayout) {
                Commands.addOperationWithLine(CommandType.SET_PROPERTY, subFormCtrl, 0, HtmlProperties.Visible, subFormCtrl.isVisible());
                this.shouldResumeSubformLayout = false;
            }
        }
    }
    GetLastParkedCtrlName(depth) {
        let ancestor = this.GetTaskAncestor(depth);
        if (ancestor === null || ancestor._lastParkedCtrl === null)
            return "";
        return ancestor._lastParkedCtrl.Name;
    }
    getForm() {
        return this.Form;
    }
    SetForm(value) {
        this.Form = value;
        return value;
    }
    checkIfExistProp(propId) {
        let exist = false;
        if (this._propTab !== null) {
            let prop = this._propTab.getPropById(propId);
            exist = (prop !== null);
        }
        return exist;
    }
    getProp(propId) {
        let prop = null;
        if (this._propTab !== null) {
            prop = this._propTab.getPropById(propId);
            if (prop === null) {
                prop = Property.getDefaultProp(propId, GuiConstants.PARENT_TYPE_TASK, this);
                if (prop !== null) {
                    prop.StudioValue = prop.getOrgValue();
                    this._propTab.addProp(prop);
                }
            }
        }
        return prop;
    }
    GetComputedProperty(propId) {
        let prop = null;
        if (this._propTab !== null)
            prop = this._propTab.getPropById(propId);
        return prop;
    }
    getCompIdx() {
        return this._compIdx;
    }
    IsFirstRefreshOfProps() {
        throw new NotImplementedException();
    }
    async EvaluateExpression(expId, resType, length, contentTypeUnicode, resCellType, alwaysEvaluate, wasEvaluated) {
        let result = null;
        wasEvaluated.value = false;
        if (alwaysEvaluate || this.DataViewWasRetrieved) {
            result = await this.CalculateExpression(expId, resType, length);
            wasEvaluated.value = true;
        }
        return result;
    }
    GetExpressionStorage(expId) {
        return this.GetExpressionStorage(expId);
    }
    async CalculateExpression(expId, resType, length) {
        return Promise.resolve("");
    }
    isStarted() {
        return true;
    }
    isAborting() {
        return false;
    }
    getField_1(parent, fldIdx) {
        switch (parent) {
            case 0:
                return this.getFieldDef(fldIdx);
            case GuiTaskBase.MAIN_PRG_PARENT_ID:
                let compMainProg = GuiDataCollection.MGDataTable.GetMainProgByCtlIdx(this.ContextID, this._ctlIdx);
                return compMainProg.getFieldDef(fldIdx);
            default:
                parent--;
                if (this.StudioParentTask != null)
                    return this.StudioParentTask.getFieldDef(parent, fldIdx);
                return null;
        }
    }
    fillAttributes(parser) {
        let endContext = parser.getXMLdata().indexOf(XMLConstants.TAG_CLOSE, parser.getCurrIndex());
        if (endContext !== -1 && endContext < parser.getXMLdata().length) {
            let tag = parser.getXMLsubstring(endContext);
            parser.add2CurrIndex(tag.indexOf(XMLConstants.MG_TAG_TASK) + XMLConstants.MG_TAG_TASK.length);
            let tokens = XmlParser.getTokens(parser.getXMLsubstring(endContext), XMLConstants.XML_ATTR_DELIM);
            for (let j = 0; j < tokens.length; j = j + 2) {
                let attribute = tokens.get_Item(j);
                let valueStr = tokens.get_Item(j + 1);
                if (!this.setAttribute(attribute, valueStr) && Events.ShouldLog(Logger_LogLevels.Development))
                    Events.WriteDevToLog(NString.Format("In TaskBase.fillAttributes(): Unprocessed(!) attribute: '{0}' = '{1}'", attribute, valueStr));
            }
            parser.setCurrIndex(parser.getXMLdata().indexOf(XMLConstants.TAG_CLOSE, parser.getCurrIndex()) + 1);
        }
    }
    setAttribute(attribute, valueStr) {
        let isTagProcessed = true;
        switch (attribute) {
            case XMLConstants.MG_ATTR_APPL_GUID:
                this.ApplicationGuid = valueStr;
                break;
            case XMLConstants.MG_ATTR_PROGRAM_ISN:
                this.ProgramIsn = NNumber.Parse(valueStr);
                break;
            case XMLConstants.MG_ATTR_TASK_ISN:
                this.TaskIsn = NNumber.Parse(valueStr);
                break;
            case XMLConstants.MG_ATTR_TOOLKIT_PARENT_TASK:
                if (NNumber.Parse(valueStr) !== 0)
                    this.StudioParentTask = GuiDataCollection.MGDataTable.GetTaskByID(valueStr);
                this.IsSubtask = true;
                break;
            case XMLConstants.MG_ATTR_TASKID:
                this.setTaskId(valueStr);
                if (Events.ShouldLog(Logger_LogLevels.Development))
                    Events.WriteDevToLog("TASK: " + this._taskTag);
                break;
            case XMLConstants.MG_ATTR_CTL_IDX:
                this.setCtlAndCompIdx(valueStr);
                break;
            case XMLConstants.MG_ATTR_MAINPRG:
                this.setMainPrg(valueStr);
                break;
            case XMLConstants.MG_ATTR_NULL_ARITHMETIC:
                this.setNullArithmetic(valueStr);
                break;
            case XMLConstants.MG_ATTR_INTERACTIVE:
                this.setIsInteracive(valueStr);
                break;
            case XMLConstants.MG_ATTR_OPEN_WIN:
                this.setOpenWin(valueStr);
                break;
            case XMLConstants.MG_ATTR_ALLOW_EVENTS:
                this.SetAllowEvents(valueStr);
                break;
            case XMLConstants.MG_ATTR_ISPRG:
                this.setIsPrg(valueStr);
                break;
            case XMLConstants.MG_ATTR_ICON_FILE_NAME:
                this.IconFileName = valueStr;
                break;
            case XMLConstants.MG_ATTR_PARALLEL:
                this.IsParallel = XmlParser.getBoolean(valueStr);
                break;
            case XMLConstants.MG_ATTR_ROUTER_PATH:
                if (valueStr.trim() != "")
                    this.routerPath = valueStr;
                break;
            case XMLConstants.MG_ATTR_IN_DEFAULT_ROUTER_OUTLET:
                this.inDefaultRouterOutlet = XmlParser.getBoolean(valueStr);
                break;
            default:
                isTagProcessed = false;
                break;
        }
        return isTagProcessed;
    }
    FormInitData(parentForm) {
        let alreadySetParentForm = false;
        let refAlreadySetParentForm = new RefParam(alreadySetParentForm);
        if (this.Form === null)
            this.Form = this.ConstructMgForm(refAlreadySetParentForm);
        if (!alreadySetParentForm)
            this.Form.ParentForm = parentForm;
        if (Events.ShouldLog(Logger_LogLevels.Development))
            Events.WriteDevToLog("form");
        this.Form.fillData(this);
        return this.Form;
    }
    setTaskId(valueStr) {
        this._taskTag = valueStr;
    }
    setCtlAndCompIdx(valueStr) {
        let i = valueStr.indexOf(",");
        if (i > -1) {
            this._ctlIdx = NNumber.Parse(valueStr.substr(0, i));
            this._compIdx = NNumber.Parse(valueStr.substr(i + 1));
        }
    }
    GetAncestorTaskContainingForm() {
        let parentTask = this.GetTaskAncestor(1);
        while (parentTask !== null && parentTask.getForm() === null) {
            parentTask = parentTask.GetTaskAncestor(1);
        }
        return parentTask;
    }
    setMainPrg(valueStr) {
        this._isMainPrg = XmlParser.getBoolean(valueStr);
    }
    setNullArithmetic(valueStr) {
        this._nullArithmetic = valueStr.charAt(0);
    }
    setIsInteracive(valueStr) {
        this.IsInteractive = XmlParser.getBoolean(valueStr);
    }
    setOpenWin(valueStr) {
        this._openWin = XmlParser.getBoolean(valueStr);
    }
    SetOpenWin(valuebool) {
        this._openWin = valuebool;
    }
    SetAllowEvents(valueStr) {
        this._allowEvents = XmlParser.getBoolean(valueStr);
    }
    setIsPrg(valueStr) {
        this._isPrg = XmlParser.getBoolean(valueStr);
    }
    ShouldEvaluatePropertyLocally(propId) {
        return false;
    }
    WriteToMessagePane(msg) {
        if (msg != null)
            console.log(msg);
    }
    WriteToMessagePanebyMsgId(msgId) {
        let msg = Events.GetMessageString(msgId);
        this.WriteToMessagePane(msg);
    }
}
GuiTaskBase.MAIN_PRG_PARENT_ID = 32768;
//# sourceMappingURL=data:application/json;base64,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